function _defineProperty(obj,key,value){return key in obj?Object.defineProperty(obj,key,{value:value,enumerable:!0,configurable:!0,writable:!0}):obj[key]=value,obj}var global,factory;global=window,factory=function(){var plugins=Object.freeze({__proto__:null,get Colors(){return plugin_colors},get Decimation(){return plugin_decimation},get Filler(){return index},get Legend(){return plugin_legend},get SubTitle(){return plugin_subtitle},get Title(){return plugin_title},get Tooltip(){return plugin_tooltip}});function noop(){}const uid=(()=>{let id=0;return()=>id++})();function isNullOrUndef(value){return null==value}function isArray(value){if(Array.isArray&&Array.isArray(value))return!0;const type=Object.prototype.toString.call(value);return"[object"===type.slice(0,7)&&"Array]"===type.slice(-6)}function isObject(value){return null!==value&&"[object Object]"===Object.prototype.toString.call(value)}function isNumberFinite(value){return("number"==typeof value||value instanceof Number)&&isFinite(+value)}function finiteOrDefault(value,defaultValue){return isNumberFinite(value)?value:defaultValue}function valueOrDefault(value,defaultValue){return void 0===value?defaultValue:value}const toPercentage=(value,dimension)=>"string"==typeof value&&value.endsWith("%")?parseFloat(value)/100:+value/dimension,toDimension=(value,dimension)=>"string"==typeof value&&value.endsWith("%")?parseFloat(value)/100*dimension:+value;function callback(fn,args,thisArg){if(fn&&"function"==typeof fn.call)return fn.apply(thisArg,args)}function each(loopable,fn,thisArg,reverse){let i,len,keys;if(isArray(loopable))if(len=loopable.length,reverse)for(i=len-1;i>=0;i--)fn.call(thisArg,loopable[i],i);else for(i=0;i<len;i++)fn.call(thisArg,loopable[i],i);else if(isObject(loopable))for(keys=Object.keys(loopable),len=keys.length,i=0;i<len;i++)fn.call(thisArg,loopable[keys[i]],keys[i])}function _elementsEqual(a0,a1){let i,ilen,v0,v1;if(!a0||!a1||a0.length!==a1.length)return!1;for(i=0,ilen=a0.length;i<ilen;++i)if(v0=a0[i],v1=a1[i],v0.datasetIndex!==v1.datasetIndex||v0.index!==v1.index)return!1;return!0}function clone$1(source){if(isArray(source))return source.map(clone$1);if(isObject(source)){const target=Object.create(null),keys=Object.keys(source),klen=keys.length;let k=0;for(;k<klen;++k)target[keys[k]]=clone$1(source[keys[k]]);return target}return source}function isValidKey(key){return-1===["__proto__","prototype","constructor"].indexOf(key)}function _merger(key,target,source,options){if(!isValidKey(key))return;const tval=target[key],sval=source[key];isObject(tval)&&isObject(sval)?merge(tval,sval,options):target[key]=clone$1(sval)}function merge(target,source,options){const sources=isArray(source)?source:[source],ilen=sources.length;if(!isObject(target))return target;const merger=(options=options||{}).merger||_merger;let current;for(let i=0;i<ilen;++i){if(current=sources[i],!isObject(current))continue;const keys=Object.keys(current);for(let k=0,klen=keys.length;k<klen;++k)merger(keys[k],target,current,options)}return target}function mergeIf(target,source){return merge(target,source,{merger:_mergerIf})}function _mergerIf(key,target,source){if(!isValidKey(key))return;const tval=target[key],sval=source[key];isObject(tval)&&isObject(sval)?mergeIf(tval,sval):Object.prototype.hasOwnProperty.call(target,key)||(target[key]=clone$1(sval))}const keyResolvers={"":v=>v,x:o=>o.x,y:o=>o.y};function _splitKey(key){const parts=key.split("."),keys=[];let tmp="";for(const part of parts)tmp+=part,tmp.endsWith("\\")?tmp=tmp.slice(0,-1)+".":(keys.push(tmp),tmp="");return keys}function resolveObjectKey(obj,key){const resolver=keyResolvers[key]||(keyResolvers[key]=function(key){const keys=_splitKey(key);return obj=>{for(const k of keys){if(""===k)break;obj=obj&&obj[k]}return obj}}(key));return resolver(obj)}function _capitalize(str){return str.charAt(0).toUpperCase()+str.slice(1)}const defined=value=>void 0!==value,isFunction=value=>"function"==typeof value,setsEqual=(a,b)=>{if(a.size!==b.size)return!1;for(const item of a)if(!b.has(item))return!1;return!0};function _isClickEvent(e){return"mouseup"===e.type||"click"===e.type||"contextmenu"===e.type}const PI=Math.PI,TAU=2*PI,PITAU=TAU+PI,INFINITY=Number.POSITIVE_INFINITY,RAD_PER_DEG=PI/180,HALF_PI=PI/2,QUARTER_PI=PI/4,TWO_THIRDS_PI=2*PI/3,log10=Math.log10,sign=Math.sign;function almostEquals(x,y,epsilon){return Math.abs(x-y)<epsilon}function niceNum(range){const roundedRange=Math.round(range);range=almostEquals(range,roundedRange,range/1e3)?roundedRange:range;const niceRange=Math.pow(10,Math.floor(log10(range))),fraction=range/niceRange;return(fraction<=1?1:fraction<=2?2:fraction<=5?5:10)*niceRange}function _factorize(value){const result=[],sqrt=Math.sqrt(value);let i;for(i=1;i<sqrt;i++)value%i==0&&(result.push(i),result.push(value/i));return sqrt===(0|sqrt)&&result.push(sqrt),result.sort(((a,b)=>a-b)).pop(),result}function isNumber(n){return!isNaN(parseFloat(n))&&isFinite(n)}function almostWhole(x,epsilon){const rounded=Math.round(x);return rounded-epsilon<=x&&rounded+epsilon>=x}function _setMinAndMaxByKey(array,target,property){let i,ilen,value;for(i=0,ilen=array.length;i<ilen;i++)value=array[i][property],isNaN(value)||(target.min=Math.min(target.min,value),target.max=Math.max(target.max,value))}function toRadians(degrees){return degrees*(PI/180)}function toDegrees(radians){return radians*(180/PI)}function _decimalPlaces(x){if(!isNumberFinite(x))return;let e=1,p=0;for(;Math.round(x*e)/e!==x;)e*=10,p++;return p}function getAngleFromPoint(centrePoint,anglePoint){const distanceFromXCenter=anglePoint.x-centrePoint.x,distanceFromYCenter=anglePoint.y-centrePoint.y,radialDistanceFromCenter=Math.sqrt(distanceFromXCenter*distanceFromXCenter+distanceFromYCenter*distanceFromYCenter);let angle=Math.atan2(distanceFromYCenter,distanceFromXCenter);return angle<-.5*PI&&(angle+=TAU),{angle:angle,distance:radialDistanceFromCenter}}function distanceBetweenPoints(pt1,pt2){return Math.sqrt(Math.pow(pt2.x-pt1.x,2)+Math.pow(pt2.y-pt1.y,2))}function _angleDiff(a,b){return(a-b+PITAU)%TAU-PI}function _normalizeAngle(a){return(a%TAU+TAU)%TAU}function _angleBetween(angle,start,end,sameAngleIsFullCircle){const a=_normalizeAngle(angle),s=_normalizeAngle(start),e=_normalizeAngle(end),angleToStart=_normalizeAngle(s-a),angleToEnd=_normalizeAngle(e-a),startToAngle=_normalizeAngle(a-s),endToAngle=_normalizeAngle(a-e);return a===s||a===e||sameAngleIsFullCircle&&s===e||angleToStart>angleToEnd&&startToAngle<endToAngle}function _limitValue(value,min,max){return Math.max(min,Math.min(max,value))}function _int16Range(value){return _limitValue(value,-32768,32767)}function _isBetween(value,start,end){let epsilon=arguments.length>3&&void 0!==arguments[3]?arguments[3]:1e-6;return value>=Math.min(start,end)-epsilon&&value<=Math.max(start,end)+epsilon}function _lookup(table,value,cmp){cmp=cmp||(index=>table[index]<value);let mid,hi=table.length-1,lo=0;for(;hi-lo>1;)mid=lo+hi>>1,cmp(mid)?lo=mid:hi=mid;return{lo:lo,hi:hi}}const _lookupByKey=(table,key,value,last)=>_lookup(table,value,last?index=>{const ti=table[index][key];return ti<value||ti===value&&table[index+1][key]===value}:index=>table[index][key]<value),_rlookupByKey=(table,key,value)=>_lookup(table,value,(index=>table[index][key]>=value));function _filterBetween(values,min,max){let start=0,end=values.length;for(;start<end&&values[start]<min;)start++;for(;end>start&&values[end-1]>max;)end--;return start>0||end<values.length?values.slice(start,end):values}const arrayEvents=["push","pop","shift","splice","unshift"];function listenArrayEvents(array,listener){array._chartjs?array._chartjs.listeners.push(listener):(Object.defineProperty(array,"_chartjs",{configurable:!0,enumerable:!1,value:{listeners:[listener]}}),arrayEvents.forEach((key=>{const method="_onData"+_capitalize(key),base=array[key];Object.defineProperty(array,key,{configurable:!0,enumerable:!1,value(){for(var _len=arguments.length,args=new Array(_len),_key=0;_key<_len;_key++)args[_key]=arguments[_key];const res=base.apply(this,args);return array._chartjs.listeners.forEach((object=>{"function"==typeof object[method]&&object[method](...args)})),res}})})))}function unlistenArrayEvents(array,listener){const stub=array._chartjs;if(!stub)return;const listeners=stub.listeners,index=listeners.indexOf(listener);-1!==index&&listeners.splice(index,1),listeners.length>0||(arrayEvents.forEach((key=>{delete array[key]})),delete array._chartjs)}function _arrayUnique(items){const set=new Set(items);return set.size===items.length?items:Array.from(set)}const requestAnimFrame="undefined"==typeof window?function(callback){return callback()}:window.requestAnimationFrame;function throttled(fn,thisArg){let argsToUse=[],ticking=!1;return function(){for(var _len2=arguments.length,args=new Array(_len2),_key2=0;_key2<_len2;_key2++)args[_key2]=arguments[_key2];argsToUse=args,ticking||(ticking=!0,requestAnimFrame.call(window,(()=>{ticking=!1,fn.apply(thisArg,argsToUse)})))}}function debounce(fn,delay){let timeout;return function(){for(var _len3=arguments.length,args=new Array(_len3),_key3=0;_key3<_len3;_key3++)args[_key3]=arguments[_key3];return delay?(clearTimeout(timeout),timeout=setTimeout(fn,delay,args)):fn.apply(this,args),delay}}const _toLeftRightCenter=align=>"start"===align?"left":"end"===align?"right":"center",_alignStartEnd=(align,start,end)=>"start"===align?start:"end"===align?end:(start+end)/2,_textX=(align,left,right,rtl)=>align===(rtl?"left":"right")?right:"center"===align?(left+right)/2:left;function _getStartAndCountOfVisiblePoints(meta,points,animationsDisabled){const pointCount=points.length;let start=0,count=pointCount;if(meta._sorted){const{iScale:iScale,_parsed:_parsed}=meta,axis=iScale.axis,{min:min,max:max,minDefined:minDefined,maxDefined:maxDefined}=iScale.getUserBounds();minDefined&&(start=_limitValue(Math.min(_lookupByKey(_parsed,axis,min).lo,animationsDisabled?pointCount:_lookupByKey(points,axis,iScale.getPixelForValue(min)).lo),0,pointCount-1)),count=maxDefined?_limitValue(Math.max(_lookupByKey(_parsed,iScale.axis,max,!0).hi+1,animationsDisabled?0:_lookupByKey(points,axis,iScale.getPixelForValue(max),!0).hi+1),start,pointCount)-start:pointCount-start}return{start:start,count:count}}function _scaleRangesChanged(meta){const{xScale:xScale,yScale:yScale,_scaleRanges:_scaleRanges}=meta,newRanges={xmin:xScale.min,xmax:xScale.max,ymin:yScale.min,ymax:yScale.max};if(!_scaleRanges)return meta._scaleRanges=newRanges,!0;const changed=_scaleRanges.xmin!==xScale.min||_scaleRanges.xmax!==xScale.max||_scaleRanges.ymin!==yScale.min||_scaleRanges.ymax!==yScale.max;return Object.assign(_scaleRanges,newRanges),changed}var animator=new class{constructor(){this._request=null,this._charts=new Map,this._running=!1,this._lastDate=void 0}_notify(chart,anims,date,type){const callbacks=anims.listeners[type],numSteps=anims.duration;callbacks.forEach((fn=>fn({chart:chart,initial:anims.initial,numSteps:numSteps,currentStep:Math.min(date-anims.start,numSteps)})))}_refresh(){this._request||(this._running=!0,this._request=requestAnimFrame.call(window,(()=>{this._update(),this._request=null,this._running&&this._refresh()})))}_update(){let date=arguments.length>0&&void 0!==arguments[0]?arguments[0]:Date.now(),remaining=0;this._charts.forEach(((anims,chart)=>{if(!anims.running||!anims.items.length)return;const items=anims.items;let item,i=items.length-1,draw=!1;for(;i>=0;--i)item=items[i],item._active?(item._total>anims.duration&&(anims.duration=item._total),item.tick(date),draw=!0):(items[i]=items[items.length-1],items.pop());draw&&(chart.draw(),this._notify(chart,anims,date,"progress")),items.length||(anims.running=!1,this._notify(chart,anims,date,"complete"),anims.initial=!1),remaining+=items.length})),this._lastDate=date,0===remaining&&(this._running=!1)}_getAnims(chart){const charts=this._charts;let anims=charts.get(chart);return anims||(anims={running:!1,initial:!0,items:[],listeners:{complete:[],progress:[]}},charts.set(chart,anims)),anims}listen(chart,event,cb){this._getAnims(chart).listeners[event].push(cb)}add(chart,items){items&&items.length&&this._getAnims(chart).items.push(...items)}has(chart){return this._getAnims(chart).items.length>0}start(chart){const anims=this._charts.get(chart);anims&&(anims.running=!0,anims.start=Date.now(),anims.duration=anims.items.reduce(((acc,cur)=>Math.max(acc,cur._duration)),0),this._refresh())}running(chart){if(!this._running)return!1;const anims=this._charts.get(chart);return!!(anims&&anims.running&&anims.items.length)}stop(chart){const anims=this._charts.get(chart);if(!anims||!anims.items.length)return;const items=anims.items;let i=items.length-1;for(;i>=0;--i)items[i].cancel();anims.items=[],this._notify(chart,anims,Date.now(),"complete")}remove(chart){return this._charts.delete(chart)}};function round(v){return v+.5|0}const lim=(v,l,h)=>Math.max(Math.min(v,h),l);function p2b(v){return lim(round(2.55*v),0,255)}function n2b(v){return lim(round(255*v),0,255)}function b2n(v){return lim(round(v/2.55)/100,0,1)}function n2p(v){return lim(round(100*v),0,100)}const map$1={0:0,1:1,2:2,3:3,4:4,5:5,6:6,7:7,8:8,9:9,A:10,B:11,C:12,D:13,E:14,F:15,a:10,b:11,c:12,d:13,e:14,f:15},hex=[..."0123456789ABCDEF"],h1=b=>hex[15&b],h2=b=>hex[(240&b)>>4]+hex[15&b],eq=b=>(240&b)>>4==(15&b);function hexString(v){var f=(v=>eq(v.r)&&eq(v.g)&&eq(v.b)&&eq(v.a))(v)?h1:h2;return v?"#"+f(v.r)+f(v.g)+f(v.b)+((a,f)=>a<255?f(a):"")(v.a,f):void 0}const HUE_RE=/^(hsla?|hwb|hsv)\(\s*([-+.e\d]+)(?:deg)?[\s,]+([-+.e\d]+)%[\s,]+([-+.e\d]+)%(?:[\s,]+([-+.e\d]+)(%)?)?\s*\)$/;function hsl2rgbn(h,s,l){const a=s*Math.min(l,1-l),f=function(n){let k=arguments.length>1&&void 0!==arguments[1]?arguments[1]:(n+h/30)%12;return l-a*Math.max(Math.min(k-3,9-k,1),-1)};return[f(0),f(8),f(4)]}function hsv2rgbn(h,s,v){const f=function(n){let k=arguments.length>1&&void 0!==arguments[1]?arguments[1]:(n+h/60)%6;return v-v*s*Math.max(Math.min(k,4-k,1),0)};return[f(5),f(3),f(1)]}function hwb2rgbn(h,w,b){const rgb=hsl2rgbn(h,1,.5);let i;for(w+b>1&&(i=1/(w+b),w*=i,b*=i),i=0;i<3;i++)rgb[i]*=1-w-b,rgb[i]+=w;return rgb}function rgb2hsl(v){const r=v.r/255,g=v.g/255,b=v.b/255,max=Math.max(r,g,b),min=Math.min(r,g,b),l=(max+min)/2;let h,s,d;return max!==min&&(d=max-min,s=l>.5?d/(2-max-min):d/(max+min),h=function(r,g,b,d,max){return r===max?(g-b)/d+(g<b?6:0):g===max?(b-r)/d+2:(r-g)/d+4}(r,g,b,d,max),h=60*h+.5),[0|h,s||0,l]}function calln(f,a,b,c){return(Array.isArray(a)?f(a[0],a[1],a[2]):f(a,b,c)).map(n2b)}function hsl2rgb(h,s,l){return calln(hsl2rgbn,h,s,l)}function hue(h){return(h%360+360)%360}function hueParse(str){const m=HUE_RE.exec(str);let v,a=255;if(!m)return;m[5]!==v&&(a=m[6]?p2b(+m[5]):n2b(+m[5]));const h=hue(+m[2]),p1=+m[3]/100,p2=+m[4]/100;return v="hwb"===m[1]?function(h,w,b){return calln(hwb2rgbn,h,w,b)}(h,p1,p2):"hsv"===m[1]?function(h,s,v){return calln(hsv2rgbn,h,s,v)}(h,p1,p2):hsl2rgb(h,p1,p2),{r:v[0],g:v[1],b:v[2],a:a}}const map$2={x:"dark",Z:"light",Y:"re",X:"blu",W:"gr",V:"medium",U:"slate",A:"ee",T:"ol",S:"or",B:"ra",C:"lateg",D:"ights",R:"in",Q:"turquois",E:"hi",P:"ro",O:"al",N:"le",M:"de",L:"yello",F:"en",K:"ch",G:"arks",H:"ea",I:"ightg",J:"wh"},names$1={OiceXe:"f0f8ff",antiquewEte:"faebd7",aqua:"ffff",aquamarRe:"7fffd4",azuY:"f0ffff",beige:"f5f5dc",bisque:"ffe4c4",black:"0",blanKedOmond:"ffebcd",Xe:"ff",XeviTet:"8a2be2",bPwn:"a52a2a",burlywood:"deb887",caMtXe:"5f9ea0",KartYuse:"7fff00",KocTate:"d2691e",cSO:"ff7f50",cSnflowerXe:"6495ed",cSnsilk:"fff8dc",crimson:"dc143c",cyan:"ffff",xXe:"8b",xcyan:"8b8b",xgTMnPd:"b8860b",xWay:"a9a9a9",xgYF:"6400",xgYy:"a9a9a9",xkhaki:"bdb76b",xmagFta:"8b008b",xTivegYF:"556b2f",xSange:"ff8c00",xScEd:"9932cc",xYd:"8b0000",xsOmon:"e9967a",xsHgYF:"8fbc8f",xUXe:"483d8b",xUWay:"2f4f4f",xUgYy:"2f4f4f",xQe:"ced1",xviTet:"9400d3",dAppRk:"ff1493",dApskyXe:"bfff",dimWay:"696969",dimgYy:"696969",dodgerXe:"1e90ff",fiYbrick:"b22222",flSOwEte:"fffaf0",foYstWAn:"228b22",fuKsia:"ff00ff",gaRsbSo:"dcdcdc",ghostwEte:"f8f8ff",gTd:"ffd700",gTMnPd:"daa520",Way:"808080",gYF:"8000",gYFLw:"adff2f",gYy:"808080",honeyMw:"f0fff0",hotpRk:"ff69b4",RdianYd:"cd5c5c",Rdigo:"4b0082",ivSy:"fffff0",khaki:"f0e68c",lavFMr:"e6e6fa",lavFMrXsh:"fff0f5",lawngYF:"7cfc00",NmoncEffon:"fffacd",ZXe:"add8e6",ZcSO:"f08080",Zcyan:"e0ffff",ZgTMnPdLw:"fafad2",ZWay:"d3d3d3",ZgYF:"90ee90",ZgYy:"d3d3d3",ZpRk:"ffb6c1",ZsOmon:"ffa07a",ZsHgYF:"20b2aa",ZskyXe:"87cefa",ZUWay:"778899",ZUgYy:"778899",ZstAlXe:"b0c4de",ZLw:"ffffe0",lime:"ff00",limegYF:"32cd32",lRF:"faf0e6",magFta:"ff00ff",maPon:"800000",VaquamarRe:"66cdaa",VXe:"cd",VScEd:"ba55d3",VpurpN:"9370db",VsHgYF:"3cb371",VUXe:"7b68ee",VsprRggYF:"fa9a",VQe:"48d1cc",VviTetYd:"c71585",midnightXe:"191970",mRtcYam:"f5fffa",mistyPse:"ffe4e1",moccasR:"ffe4b5",navajowEte:"ffdead",navy:"80",Tdlace:"fdf5e6",Tive:"808000",TivedBb:"6b8e23",Sange:"ffa500",SangeYd:"ff4500",ScEd:"da70d6",pOegTMnPd:"eee8aa",pOegYF:"98fb98",pOeQe:"afeeee",pOeviTetYd:"db7093",papayawEp:"ffefd5",pHKpuff:"ffdab9",peru:"cd853f",pRk:"ffc0cb",plum:"dda0dd",powMrXe:"b0e0e6",purpN:"800080",YbeccapurpN:"663399",Yd:"ff0000",Psybrown:"bc8f8f",PyOXe:"4169e1",saddNbPwn:"8b4513",sOmon:"fa8072",sandybPwn:"f4a460",sHgYF:"2e8b57",sHshell:"fff5ee",siFna:"a0522d",silver:"c0c0c0",skyXe:"87ceeb",UXe:"6a5acd",UWay:"708090",UgYy:"708090",snow:"fffafa",sprRggYF:"ff7f",stAlXe:"4682b4",tan:"d2b48c",teO:"8080",tEstN:"d8bfd8",tomato:"ff6347",Qe:"40e0d0",viTet:"ee82ee",JHt:"f5deb3",wEte:"ffffff",wEtesmoke:"f5f5f5",Lw:"ffff00",LwgYF:"9acd32"};let names;function nameParse(str){names||(names=function(){const unpacked={},keys=Object.keys(names$1),tkeys=Object.keys(map$2);let i,j,k,ok,nk;for(i=0;i<keys.length;i++){for(ok=nk=keys[i],j=0;j<tkeys.length;j++)k=tkeys[j],nk=nk.replace(k,map$2[k]);k=parseInt(names$1[ok],16),unpacked[nk]=[k>>16&255,k>>8&255,255&k]}return unpacked}(),names.transparent=[0,0,0,0]);const a=names[str.toLowerCase()];return a&&{r:a[0],g:a[1],b:a[2],a:4===a.length?a[3]:255}}const RGB_RE=/^rgba?\(\s*([-+.\d]+)(%)?[\s,]+([-+.e\d]+)(%)?[\s,]+([-+.e\d]+)(%)?(?:[\s,/]+([-+.e\d]+)(%)?)?\s*\)$/,to=v=>v<=.0031308?12.92*v:1.055*Math.pow(v,1/2.4)-.055,from=v=>v<=.04045?v/12.92:Math.pow((v+.055)/1.055,2.4);function modHSL(v,i,ratio){if(v){let tmp=rgb2hsl(v);tmp[i]=Math.max(0,Math.min(tmp[i]+tmp[i]*ratio,0===i?360:1)),tmp=hsl2rgb(tmp),v.r=tmp[0],v.g=tmp[1],v.b=tmp[2]}}function clone(v,proto){return v?Object.assign(proto||{},v):v}function fromObject(input){var v={r:0,g:0,b:0,a:255};return Array.isArray(input)?input.length>=3&&(v={r:input[0],g:input[1],b:input[2],a:255},input.length>3&&(v.a=n2b(input[3]))):(v=clone(input,{r:0,g:0,b:0,a:1})).a=n2b(v.a),v}function functionParse(str){return"r"===str.charAt(0)?function(str){const m=RGB_RE.exec(str);let r,g,b,a=255;if(m){if(m[7]!==r){const v=+m[7];a=m[8]?p2b(v):lim(255*v,0,255)}return r=+m[1],g=+m[3],b=+m[5],r=255&(m[2]?p2b(r):lim(r,0,255)),g=255&(m[4]?p2b(g):lim(g,0,255)),b=255&(m[6]?p2b(b):lim(b,0,255)),{r:r,g:g,b:b,a:a}}}(str):hueParse(str)}class Color{constructor(input){if(input instanceof Color)return input;const type=typeof input;let v;var str,ret,len;"object"===type?v=fromObject(input):"string"===type&&(len=(str=input).length,"#"===str[0]&&(4===len||5===len?ret={r:255&17*map$1[str[1]],g:255&17*map$1[str[2]],b:255&17*map$1[str[3]],a:5===len?17*map$1[str[4]]:255}:7!==len&&9!==len||(ret={r:map$1[str[1]]<<4|map$1[str[2]],g:map$1[str[3]]<<4|map$1[str[4]],b:map$1[str[5]]<<4|map$1[str[6]],a:9===len?map$1[str[7]]<<4|map$1[str[8]]:255})),v=ret||nameParse(input)||functionParse(input)),this._rgb=v,this._valid=!!v}get valid(){return this._valid}get rgb(){var v=clone(this._rgb);return v&&(v.a=b2n(v.a)),v}set rgb(obj){this._rgb=fromObject(obj)}rgbString(){return this._valid?(v=this._rgb)&&(v.a<255?"rgba(".concat(v.r,", ").concat(v.g,", ").concat(v.b,", ").concat(b2n(v.a),")"):"rgb(".concat(v.r,", ").concat(v.g,", ").concat(v.b,")")):void 0;var v}hexString(){return this._valid?hexString(this._rgb):void 0}hslString(){return this._valid?function(v){if(!v)return;const a=rgb2hsl(v),h=a[0],s=n2p(a[1]),l=n2p(a[2]);return v.a<255?"hsla(".concat(h,", ").concat(s,"%, ").concat(l,"%, ").concat(b2n(v.a),")"):"hsl(".concat(h,", ").concat(s,"%, ").concat(l,"%)")}(this._rgb):void 0}mix(color,weight){if(color){const c1=this.rgb,c2=color.rgb;let w2;const p=weight===w2?.5:weight,w=2*p-1,a=c1.a-c2.a,w1=((w*a==-1?w:(w+a)/(1+w*a))+1)/2;w2=1-w1,c1.r=255&w1*c1.r+w2*c2.r+.5,c1.g=255&w1*c1.g+w2*c2.g+.5,c1.b=255&w1*c1.b+w2*c2.b+.5,c1.a=p*c1.a+(1-p)*c2.a,this.rgb=c1}return this}interpolate(color,t){return color&&(this._rgb=function(rgb1,rgb2,t){const r=from(b2n(rgb1.r)),g=from(b2n(rgb1.g)),b=from(b2n(rgb1.b));return{r:n2b(to(r+t*(from(b2n(rgb2.r))-r))),g:n2b(to(g+t*(from(b2n(rgb2.g))-g))),b:n2b(to(b+t*(from(b2n(rgb2.b))-b))),a:rgb1.a+t*(rgb2.a-rgb1.a)}}(this._rgb,color._rgb,t)),this}clone(){return new Color(this.rgb)}alpha(a){return this._rgb.a=n2b(a),this}clearer(ratio){return this._rgb.a*=1-ratio,this}greyscale(){const rgb=this._rgb,val=round(.3*rgb.r+.59*rgb.g+.11*rgb.b);return rgb.r=rgb.g=rgb.b=val,this}opaquer(ratio){return this._rgb.a*=1+ratio,this}negate(){const v=this._rgb;return v.r=255-v.r,v.g=255-v.g,v.b=255-v.b,this}lighten(ratio){return modHSL(this._rgb,2,ratio),this}darken(ratio){return modHSL(this._rgb,2,-ratio),this}saturate(ratio){return modHSL(this._rgb,1,ratio),this}desaturate(ratio){return modHSL(this._rgb,1,-ratio),this}rotate(deg){return function(v,deg){var h=rgb2hsl(v);h[0]=hue(h[0]+deg),h=hsl2rgb(h),v.r=h[0],v.g=h[1],v.b=h[2]}(this._rgb,deg),this}}function isPatternOrGradient(value){if(value&&"object"==typeof value){const type=value.toString();return"[object CanvasPattern]"===type||"[object CanvasGradient]"===type}return!1}function color(value){return isPatternOrGradient(value)?value:new Color(value)}function getHoverColor(value){return isPatternOrGradient(value)?value:new Color(value).saturate(.5).darken(.1).hexString()}const numbers=["x","y","borderWidth","radius","tension"],colors=["color","borderColor","backgroundColor"],intlCache=new Map;function formatNumber(num,locale,options){return function(locale,options){options=options||{};const cacheKey=locale+JSON.stringify(options);let formatter=intlCache.get(cacheKey);return formatter||(formatter=new Intl.NumberFormat(locale,options),intlCache.set(cacheKey,formatter)),formatter}(locale,options).format(num)}const formatters={values:value=>isArray(value)?value:""+value,numeric(tickValue,index,ticks){if(0===tickValue)return"0";const locale=this.chart.options.locale;let notation,delta=tickValue;if(ticks.length>1){const maxTick=Math.max(Math.abs(ticks[0].value),Math.abs(ticks[ticks.length-1].value));(maxTick<1e-4||maxTick>1e15)&&(notation="scientific"),delta=function(tickValue,ticks){let delta=ticks.length>3?ticks[2].value-ticks[1].value:ticks[1].value-ticks[0].value;return Math.abs(delta)>=1&&tickValue!==Math.floor(tickValue)&&(delta=tickValue-Math.floor(tickValue)),delta}(tickValue,ticks)}const logDelta=log10(Math.abs(delta)),numDecimal=isNaN(logDelta)?1:Math.max(Math.min(-1*Math.floor(logDelta),20),0),options={notation:notation,minimumFractionDigits:numDecimal,maximumFractionDigits:numDecimal};return Object.assign(options,this.options.ticks.format),formatNumber(tickValue,locale,options)},logarithmic(tickValue,index,ticks){if(0===tickValue)return"0";const remain=ticks[index].significand||tickValue/Math.pow(10,Math.floor(log10(tickValue)));return[1,2,3,5,10,15].includes(remain)||index>.8*ticks.length?formatters.numeric.call(this,tickValue,index,ticks):""}};var Ticks={formatters:formatters};const overrides=Object.create(null),descriptors=Object.create(null);function getScope$1(node,key){if(!key)return node;const keys=key.split(".");for(let i=0,n=keys.length;i<n;++i){const k=keys[i];node=node[k]||(node[k]=Object.create(null))}return node}function set(root,scope,values){return"string"==typeof scope?merge(getScope$1(root,scope),values):merge(getScope$1(root,""),scope)}var defaults=new class{constructor(_descriptors,_appliers){this.animation=void 0,this.backgroundColor="rgba(0,0,0,0.1)",this.borderColor="rgba(0,0,0,0.1)",this.color="#666",this.datasets={},this.devicePixelRatio=context=>context.chart.platform.getDevicePixelRatio(),this.elements={},this.events=["mousemove","mouseout","click","touchstart","touchmove"],this.font={family:"'Helvetica Neue', 'Helvetica', 'Arial', sans-serif",size:12,style:"normal",lineHeight:1.2,weight:null},this.hover={},this.hoverBackgroundColor=(ctx,options)=>getHoverColor(options.backgroundColor),this.hoverBorderColor=(ctx,options)=>getHoverColor(options.borderColor),this.hoverColor=(ctx,options)=>getHoverColor(options.color),this.indexAxis="x",this.interaction={mode:"nearest",intersect:!0,includeInvisible:!1},this.maintainAspectRatio=!0,this.onHover=null,this.onClick=null,this.parsing=!0,this.plugins={},this.responsive=!0,this.scale=void 0,this.scales={},this.showLine=!0,this.drawActiveElementsOnTop=!0,this.describe(_descriptors),this.apply(_appliers)}set(scope,values){return set(this,scope,values)}get(scope){return getScope$1(this,scope)}describe(scope,values){return set(descriptors,scope,values)}override(scope,values){return set(overrides,scope,values)}route(scope,name,targetScope,targetName){const scopeObject=getScope$1(this,scope),targetScopeObject=getScope$1(this,targetScope),privateName="_"+name;Object.defineProperties(scopeObject,{[privateName]:{value:scopeObject[name],writable:!0},[name]:{enumerable:!0,get(){const local=this[privateName],target=targetScopeObject[targetName];return isObject(local)?Object.assign({},target,local):valueOrDefault(local,target)},set(value){this[privateName]=value}}})}apply(appliers){appliers.forEach((apply=>apply(this)))}}({_scriptable:name=>!name.startsWith("on"),_indexable:name=>"events"!==name,hover:{_fallback:"interaction"},interaction:{_scriptable:!1,_indexable:!1}},[function(defaults){defaults.set("animation",{delay:void 0,duration:1e3,easing:"easeOutQuart",fn:void 0,from:void 0,loop:void 0,to:void 0,type:void 0}),defaults.describe("animation",{_fallback:!1,_indexable:!1,_scriptable:name=>"onProgress"!==name&&"onComplete"!==name&&"fn"!==name}),defaults.set("animations",{colors:{type:"color",properties:colors},numbers:{type:"number",properties:numbers}}),defaults.describe("animations",{_fallback:"animation"}),defaults.set("transitions",{active:{animation:{duration:400}},resize:{animation:{duration:0}},show:{animations:{colors:{from:"transparent"},visible:{type:"boolean",duration:0}}},hide:{animations:{colors:{to:"transparent"},visible:{type:"boolean",easing:"linear",fn:v=>0|v}}}})},function(defaults){defaults.set("layout",{autoPadding:!0,padding:{top:0,right:0,bottom:0,left:0}})},function(defaults){defaults.set("scale",{display:!0,offset:!1,reverse:!1,beginAtZero:!1,bounds:"ticks",clip:!0,grace:0,grid:{display:!0,lineWidth:1,drawOnChartArea:!0,drawTicks:!0,tickLength:8,tickWidth:(_ctx,options)=>options.lineWidth,tickColor:(_ctx,options)=>options.color,offset:!1},border:{display:!0,dash:[],dashOffset:0,width:1},title:{display:!1,text:"",padding:{top:4,bottom:4}},ticks:{minRotation:0,maxRotation:50,mirror:!1,textStrokeWidth:0,textStrokeColor:"",padding:3,display:!0,autoSkip:!0,autoSkipPadding:3,labelOffset:0,callback:Ticks.formatters.values,minor:{},major:{},align:"center",crossAlign:"near",showLabelBackdrop:!1,backdropColor:"rgba(255, 255, 255, 0.75)",backdropPadding:2}}),defaults.route("scale.ticks","color","","color"),defaults.route("scale.grid","color","","borderColor"),defaults.route("scale.border","color","","borderColor"),defaults.route("scale.title","color","","color"),defaults.describe("scale",{_fallback:!1,_scriptable:name=>!name.startsWith("before")&&!name.startsWith("after")&&"callback"!==name&&"parser"!==name,_indexable:name=>"borderDash"!==name&&"tickBorderDash"!==name&&"dash"!==name}),defaults.describe("scales",{_fallback:"scale"}),defaults.describe("scale.ticks",{_scriptable:name=>"backdropPadding"!==name&&"callback"!==name,_indexable:name=>"backdropPadding"!==name})}]);function _isDomSupported(){return"undefined"!=typeof window&&"undefined"!=typeof document}function _getParentNode(domNode){let parent=domNode.parentNode;return parent&&"[object ShadowRoot]"===parent.toString()&&(parent=parent.host),parent}function parseMaxStyle(styleValue,node,parentProperty){let valueInPixels;return"string"==typeof styleValue?(valueInPixels=parseInt(styleValue,10),-1!==styleValue.indexOf("%")&&(valueInPixels=valueInPixels/100*node.parentNode[parentProperty])):valueInPixels=styleValue,valueInPixels}const getComputedStyle=element=>element.ownerDocument.defaultView.getComputedStyle(element,null);function getStyle(el,property){return getComputedStyle(el).getPropertyValue(property)}const positions=["top","right","bottom","left"];function getPositionedStyle(styles,style,suffix){const result={};suffix=suffix?"-"+suffix:"";for(let i=0;i<4;i++){const pos=positions[i];result[pos]=parseFloat(styles[style+"-"+pos+suffix])||0}return result.width=result.left+result.right,result.height=result.top+result.bottom,result}function getRelativePosition(event,chart){if("native"in event)return event;const{canvas:canvas,currentDevicePixelRatio:currentDevicePixelRatio}=chart,style=getComputedStyle(canvas),borderBox="border-box"===style.boxSizing,paddings=getPositionedStyle(style,"padding"),borders=getPositionedStyle(style,"border","width"),{x:x,y:y,box:box}=function(e,canvas){const touches=e.touches,source=touches&&touches.length?touches[0]:e,{offsetX:offsetX,offsetY:offsetY}=source;let x,y,box=!1;if(((x,y,target)=>(x>0||y>0)&&(!target||!target.shadowRoot))(offsetX,offsetY,e.target))x=offsetX,y=offsetY;else{const rect=canvas.getBoundingClientRect();x=source.clientX-rect.left,y=source.clientY-rect.top,box=!0}return{x:x,y:y,box:box}}(event,canvas),xOffset=paddings.left+(box&&borders.left),yOffset=paddings.top+(box&&borders.top);let{width:width,height:height}=chart;return borderBox&&(width-=paddings.width+borders.width,height-=paddings.height+borders.height),{x:Math.round((x-xOffset)/width*canvas.width/currentDevicePixelRatio),y:Math.round((y-yOffset)/height*canvas.height/currentDevicePixelRatio)}}const round1=v=>Math.round(10*v)/10;function getMaximumSize(canvas,bbWidth,bbHeight,aspectRatio){const style=getComputedStyle(canvas),margins=getPositionedStyle(style,"margin"),maxWidth=parseMaxStyle(style.maxWidth,canvas,"clientWidth")||INFINITY,maxHeight=parseMaxStyle(style.maxHeight,canvas,"clientHeight")||INFINITY,containerSize=function(canvas,width,height){let maxWidth,maxHeight;if(void 0===width||void 0===height){const container=_getParentNode(canvas);if(container){const rect=container.getBoundingClientRect(),containerStyle=getComputedStyle(container),containerBorder=getPositionedStyle(containerStyle,"border","width"),containerPadding=getPositionedStyle(containerStyle,"padding");width=rect.width-containerPadding.width-containerBorder.width,height=rect.height-containerPadding.height-containerBorder.height,maxWidth=parseMaxStyle(containerStyle.maxWidth,container,"clientWidth"),maxHeight=parseMaxStyle(containerStyle.maxHeight,container,"clientHeight")}else width=canvas.clientWidth,height=canvas.clientHeight}return{width:width,height:height,maxWidth:maxWidth||INFINITY,maxHeight:maxHeight||INFINITY}}(canvas,bbWidth,bbHeight);let{width:width,height:height}=containerSize;if("content-box"===style.boxSizing){const borders=getPositionedStyle(style,"border","width"),paddings=getPositionedStyle(style,"padding");width-=paddings.width+borders.width,height-=paddings.height+borders.height}return width=Math.max(0,width-margins.width),height=Math.max(0,aspectRatio?width/aspectRatio:height-margins.height),width=round1(Math.min(width,maxWidth,containerSize.maxWidth)),height=round1(Math.min(height,maxHeight,containerSize.maxHeight)),width&&!height&&(height=round1(width/2)),(void 0!==bbWidth||void 0!==bbHeight)&&aspectRatio&&containerSize.height&&height>containerSize.height&&(height=containerSize.height,width=round1(Math.floor(height*aspectRatio))),{width:width,height:height}}function retinaScale(chart,forceRatio,forceStyle){const pixelRatio=forceRatio||1,deviceHeight=Math.floor(chart.height*pixelRatio),deviceWidth=Math.floor(chart.width*pixelRatio);chart.height=Math.floor(chart.height),chart.width=Math.floor(chart.width);const canvas=chart.canvas;return canvas.style&&(forceStyle||!canvas.style.height&&!canvas.style.width)&&(canvas.style.height="".concat(chart.height,"px"),canvas.style.width="".concat(chart.width,"px")),(chart.currentDevicePixelRatio!==pixelRatio||canvas.height!==deviceHeight||canvas.width!==deviceWidth)&&(chart.currentDevicePixelRatio=pixelRatio,canvas.height=deviceHeight,canvas.width=deviceWidth,chart.ctx.setTransform(pixelRatio,0,0,pixelRatio,0,0),!0)}const supportsEventListenerOptions=function(){let passiveSupported=!1;try{const options={get passive(){return passiveSupported=!0,!1}};_isDomSupported()&&(window.addEventListener("test",null,options),window.removeEventListener("test",null,options))}catch(e){}return passiveSupported}();function readUsedSize(element,property){const value=getStyle(element,property),matches=value&&value.match(/^(\d+)(\.\d+)?px$/);return matches?+matches[1]:void 0}function toFontString(font){return!font||isNullOrUndef(font.size)||isNullOrUndef(font.family)?null:(font.style?font.style+" ":"")+(font.weight?font.weight+" ":"")+font.size+"px "+font.family}function _measureText(ctx,data,gc,longest,string){let textWidth=data[string];return textWidth||(textWidth=data[string]=ctx.measureText(string).width,gc.push(string)),textWidth>longest&&(longest=textWidth),longest}function _longestText(ctx,font,arrayOfThings,cache){let data=(cache=cache||{}).data=cache.data||{},gc=cache.garbageCollect=cache.garbageCollect||[];cache.font!==font&&(data=cache.data={},gc=cache.garbageCollect=[],cache.font=font),ctx.save(),ctx.font=font;let longest=0;const ilen=arrayOfThings.length;let i,j,jlen,thing,nestedThing;for(i=0;i<ilen;i++)if(thing=arrayOfThings[i],null==thing||isArray(thing)){if(isArray(thing))for(j=0,jlen=thing.length;j<jlen;j++)nestedThing=thing[j],null==nestedThing||isArray(nestedThing)||(longest=_measureText(ctx,data,gc,longest,nestedThing))}else longest=_measureText(ctx,data,gc,longest,thing);ctx.restore();const gcLen=gc.length/2;if(gcLen>arrayOfThings.length){for(i=0;i<gcLen;i++)delete data[gc[i]];gc.splice(0,gcLen)}return longest}function _alignPixel(chart,pixel,width){const devicePixelRatio=chart.currentDevicePixelRatio,halfWidth=0!==width?Math.max(width/2,.5):0;return Math.round((pixel-halfWidth)*devicePixelRatio)/devicePixelRatio+halfWidth}function clearCanvas(canvas,ctx){(ctx=ctx||canvas.getContext("2d")).save(),ctx.resetTransform(),ctx.clearRect(0,0,canvas.width,canvas.height),ctx.restore()}function drawPoint(ctx,options,x,y){drawPointLegend(ctx,options,x,y,null)}function drawPointLegend(ctx,options,x,y,w){let type,xOffset,yOffset,size,cornerRadius,width,xOffsetW,yOffsetW;const style=options.pointStyle,rotation=options.rotation,radius=options.radius;let rad=(rotation||0)*RAD_PER_DEG;if(style&&"object"==typeof style&&(type=style.toString(),"[object HTMLImageElement]"===type||"[object HTMLCanvasElement]"===type))return ctx.save(),ctx.translate(x,y),ctx.rotate(rad),ctx.drawImage(style,-style.width/2,-style.height/2,style.width,style.height),void ctx.restore();if(!(isNaN(radius)||radius<=0)){switch(ctx.beginPath(),style){default:w?ctx.ellipse(x,y,w/2,radius,0,0,TAU):ctx.arc(x,y,radius,0,TAU),ctx.closePath();break;case"triangle":width=w?w/2:radius,ctx.moveTo(x+Math.sin(rad)*width,y-Math.cos(rad)*radius),rad+=TWO_THIRDS_PI,ctx.lineTo(x+Math.sin(rad)*width,y-Math.cos(rad)*radius),rad+=TWO_THIRDS_PI,ctx.lineTo(x+Math.sin(rad)*width,y-Math.cos(rad)*radius),ctx.closePath();break;case"rectRounded":cornerRadius=.516*radius,size=radius-cornerRadius,xOffset=Math.cos(rad+QUARTER_PI)*size,xOffsetW=Math.cos(rad+QUARTER_PI)*(w?w/2-cornerRadius:size),yOffset=Math.sin(rad+QUARTER_PI)*size,yOffsetW=Math.sin(rad+QUARTER_PI)*(w?w/2-cornerRadius:size),ctx.arc(x-xOffsetW,y-yOffset,cornerRadius,rad-PI,rad-HALF_PI),ctx.arc(x+yOffsetW,y-xOffset,cornerRadius,rad-HALF_PI,rad),ctx.arc(x+xOffsetW,y+yOffset,cornerRadius,rad,rad+HALF_PI),ctx.arc(x-yOffsetW,y+xOffset,cornerRadius,rad+HALF_PI,rad+PI),ctx.closePath();break;case"rect":if(!rotation){size=Math.SQRT1_2*radius,width=w?w/2:size,ctx.rect(x-width,y-size,2*width,2*size);break}rad+=QUARTER_PI;case"rectRot":xOffsetW=Math.cos(rad)*(w?w/2:radius),xOffset=Math.cos(rad)*radius,yOffset=Math.sin(rad)*radius,yOffsetW=Math.sin(rad)*(w?w/2:radius),ctx.moveTo(x-xOffsetW,y-yOffset),ctx.lineTo(x+yOffsetW,y-xOffset),ctx.lineTo(x+xOffsetW,y+yOffset),ctx.lineTo(x-yOffsetW,y+xOffset),ctx.closePath();break;case"crossRot":rad+=QUARTER_PI;case"cross":xOffsetW=Math.cos(rad)*(w?w/2:radius),xOffset=Math.cos(rad)*radius,yOffset=Math.sin(rad)*radius,yOffsetW=Math.sin(rad)*(w?w/2:radius),ctx.moveTo(x-xOffsetW,y-yOffset),ctx.lineTo(x+xOffsetW,y+yOffset),ctx.moveTo(x+yOffsetW,y-xOffset),ctx.lineTo(x-yOffsetW,y+xOffset);break;case"star":xOffsetW=Math.cos(rad)*(w?w/2:radius),xOffset=Math.cos(rad)*radius,yOffset=Math.sin(rad)*radius,yOffsetW=Math.sin(rad)*(w?w/2:radius),ctx.moveTo(x-xOffsetW,y-yOffset),ctx.lineTo(x+xOffsetW,y+yOffset),ctx.moveTo(x+yOffsetW,y-xOffset),ctx.lineTo(x-yOffsetW,y+xOffset),rad+=QUARTER_PI,xOffsetW=Math.cos(rad)*(w?w/2:radius),xOffset=Math.cos(rad)*radius,yOffset=Math.sin(rad)*radius,yOffsetW=Math.sin(rad)*(w?w/2:radius),ctx.moveTo(x-xOffsetW,y-yOffset),ctx.lineTo(x+xOffsetW,y+yOffset),ctx.moveTo(x+yOffsetW,y-xOffset),ctx.lineTo(x-yOffsetW,y+xOffset);break;case"line":xOffset=w?w/2:Math.cos(rad)*radius,yOffset=Math.sin(rad)*radius,ctx.moveTo(x-xOffset,y-yOffset),ctx.lineTo(x+xOffset,y+yOffset);break;case"dash":ctx.moveTo(x,y),ctx.lineTo(x+Math.cos(rad)*(w?w/2:radius),y+Math.sin(rad)*radius);break;case!1:ctx.closePath()}ctx.fill(),options.borderWidth>0&&ctx.stroke()}}function _isPointInArea(point,area,margin){return margin=margin||.5,!area||point&&point.x>area.left-margin&&point.x<area.right+margin&&point.y>area.top-margin&&point.y<area.bottom+margin}function clipArea(ctx,area){ctx.save(),ctx.beginPath(),ctx.rect(area.left,area.top,area.right-area.left,area.bottom-area.top),ctx.clip()}function unclipArea(ctx){ctx.restore()}function _steppedLineTo(ctx,previous,target,flip,mode){if(!previous)return ctx.lineTo(target.x,target.y);if("middle"===mode){const midpoint=(previous.x+target.x)/2;ctx.lineTo(midpoint,previous.y),ctx.lineTo(midpoint,target.y)}else"after"===mode!=!!flip?ctx.lineTo(previous.x,target.y):ctx.lineTo(target.x,previous.y);ctx.lineTo(target.x,target.y)}function _bezierCurveTo(ctx,previous,target,flip){if(!previous)return ctx.lineTo(target.x,target.y);ctx.bezierCurveTo(flip?previous.cp1x:previous.cp2x,flip?previous.cp1y:previous.cp2y,flip?target.cp2x:target.cp1x,flip?target.cp2y:target.cp1y,target.x,target.y)}function setRenderOpts(ctx,opts){opts.translation&&ctx.translate(opts.translation[0],opts.translation[1]),isNullOrUndef(opts.rotation)||ctx.rotate(opts.rotation),opts.color&&(ctx.fillStyle=opts.color),opts.textAlign&&(ctx.textAlign=opts.textAlign),opts.textBaseline&&(ctx.textBaseline=opts.textBaseline)}function decorateText(ctx,x,y,line,opts){if(opts.strikethrough||opts.underline){const metrics=ctx.measureText(line),left=x-metrics.actualBoundingBoxLeft,right=x+metrics.actualBoundingBoxRight,top=y-metrics.actualBoundingBoxAscent,bottom=y+metrics.actualBoundingBoxDescent,yDecoration=opts.strikethrough?(top+bottom)/2:bottom;ctx.strokeStyle=ctx.fillStyle,ctx.beginPath(),ctx.lineWidth=opts.decorationWidth||2,ctx.moveTo(left,yDecoration),ctx.lineTo(right,yDecoration),ctx.stroke()}}function drawBackdrop(ctx,opts){const oldColor=ctx.fillStyle;ctx.fillStyle=opts.color,ctx.fillRect(opts.left,opts.top,opts.width,opts.height),ctx.fillStyle=oldColor}function renderText(ctx,text,x,y,font){let opts=arguments.length>5&&void 0!==arguments[5]?arguments[5]:{};const lines=isArray(text)?text:[text],stroke=opts.strokeWidth>0&&""!==opts.strokeColor;let i,line;for(ctx.save(),ctx.font=font.string,setRenderOpts(ctx,opts),i=0;i<lines.length;++i)line=lines[i],opts.backdrop&&drawBackdrop(ctx,opts.backdrop),stroke&&(opts.strokeColor&&(ctx.strokeStyle=opts.strokeColor),isNullOrUndef(opts.strokeWidth)||(ctx.lineWidth=opts.strokeWidth),ctx.strokeText(line,x,y,opts.maxWidth)),ctx.fillText(line,x,y,opts.maxWidth),decorateText(ctx,x,y,line,opts),y+=Number(font.lineHeight);ctx.restore()}function addRoundedRectPath(ctx,rect){const{x:x,y:y,w:w,h:h,radius:radius}=rect;ctx.arc(x+radius.topLeft,y+radius.topLeft,radius.topLeft,1.5*PI,PI,!0),ctx.lineTo(x,y+h-radius.bottomLeft),ctx.arc(x+radius.bottomLeft,y+h-radius.bottomLeft,radius.bottomLeft,PI,HALF_PI,!0),ctx.lineTo(x+w-radius.bottomRight,y+h),ctx.arc(x+w-radius.bottomRight,y+h-radius.bottomRight,radius.bottomRight,HALF_PI,0,!0),ctx.lineTo(x+w,y+radius.topRight),ctx.arc(x+w-radius.topRight,y+radius.topRight,radius.topRight,0,-HALF_PI,!0),ctx.lineTo(x+radius.topLeft,y)}function _createResolver(scopes){let prefixes=arguments.length>1&&void 0!==arguments[1]?arguments[1]:[""],rootScopes=arguments.length>2?arguments[2]:void 0,fallback=arguments.length>3?arguments[3]:void 0,getTarget=arguments.length>4&&void 0!==arguments[4]?arguments[4]:()=>scopes[0];const finalRootScopes=rootScopes||scopes;void 0===fallback&&(fallback=_resolve("_fallback",scopes));const cache={[Symbol.toStringTag]:"Object",_cacheable:!0,_scopes:scopes,_rootScopes:finalRootScopes,_fallback:fallback,_getTarget:getTarget,override:scope=>_createResolver([scope,...scopes],prefixes,finalRootScopes,fallback)};return new Proxy(cache,{deleteProperty:(target,prop)=>(delete target[prop],delete target._keys,delete scopes[0][prop],!0),get:(target,prop)=>_cached(target,prop,(()=>_resolveWithPrefixes(prop,prefixes,scopes,target))),getOwnPropertyDescriptor:(target,prop)=>Reflect.getOwnPropertyDescriptor(target._scopes[0],prop),getPrototypeOf:()=>Reflect.getPrototypeOf(scopes[0]),has:(target,prop)=>getKeysFromAllScopes(target).includes(prop),ownKeys:target=>getKeysFromAllScopes(target),set(target,prop,value){const storage=target._storage||(target._storage=getTarget());return target[prop]=storage[prop]=value,delete target._keys,!0}})}function _attachContext(proxy,context,subProxy,descriptorDefaults){const cache={_cacheable:!1,_proxy:proxy,_context:context,_subProxy:subProxy,_stack:new Set,_descriptors:_descriptors(proxy,descriptorDefaults),setContext:ctx=>_attachContext(proxy,ctx,subProxy,descriptorDefaults),override:scope=>_attachContext(proxy.override(scope),context,subProxy,descriptorDefaults)};return new Proxy(cache,{deleteProperty:(target,prop)=>(delete target[prop],delete proxy[prop],!0),get:(target,prop,receiver)=>_cached(target,prop,(()=>function(target,prop,receiver){const{_proxy:_proxy,_context:_context,_subProxy:_subProxy,_descriptors:descriptors}=target;let value=_proxy[prop];return isFunction(value)&&descriptors.isScriptable(prop)&&(value=function(prop,getValue,target,receiver){const{_proxy:_proxy,_context:_context,_subProxy:_subProxy,_stack:_stack}=target;if(_stack.has(prop))throw new Error("Recursion detected: "+Array.from(_stack).join("->")+"->"+prop);_stack.add(prop);let value=getValue(_context,_subProxy||receiver);return _stack.delete(prop),needsSubResolver(prop,value)&&(value=createSubResolver(_proxy._scopes,_proxy,prop,value)),value}(prop,value,target,receiver)),isArray(value)&&value.length&&(value=function(prop,value,target,isIndexable){const{_proxy:_proxy,_context:_context,_subProxy:_subProxy,_descriptors:descriptors}=target;if(void 0!==_context.index&&isIndexable(prop))return value[_context.index%value.length];if(isObject(value[0])){const arr=value,scopes=_proxy._scopes.filter((s=>s!==arr));value=[];for(const item of arr){const resolver=createSubResolver(scopes,_proxy,prop,item);value.push(_attachContext(resolver,_context,_subProxy&&_subProxy[prop],descriptors))}}return value}(prop,value,target,descriptors.isIndexable)),needsSubResolver(prop,value)&&(value=_attachContext(value,_context,_subProxy&&_subProxy[prop],descriptors)),value}(target,prop,receiver))),getOwnPropertyDescriptor:(target,prop)=>target._descriptors.allKeys?Reflect.has(proxy,prop)?{enumerable:!0,configurable:!0}:void 0:Reflect.getOwnPropertyDescriptor(proxy,prop),getPrototypeOf:()=>Reflect.getPrototypeOf(proxy),has:(target,prop)=>Reflect.has(proxy,prop),ownKeys:()=>Reflect.ownKeys(proxy),set:(target,prop,value)=>(proxy[prop]=value,delete target[prop],!0)})}function _descriptors(proxy){let defaults=arguments.length>1&&void 0!==arguments[1]?arguments[1]:{scriptable:!0,indexable:!0};const{_scriptable:_scriptable=defaults.scriptable,_indexable:_indexable=defaults.indexable,_allKeys:_allKeys=defaults.allKeys}=proxy;return{allKeys:_allKeys,scriptable:_scriptable,indexable:_indexable,isScriptable:isFunction(_scriptable)?_scriptable:()=>_scriptable,isIndexable:isFunction(_indexable)?_indexable:()=>_indexable}}const readKey=(prefix,name)=>prefix?prefix+_capitalize(name):name,needsSubResolver=(prop,value)=>isObject(value)&&"adapters"!==prop&&(null===Object.getPrototypeOf(value)||value.constructor===Object);function _cached(target,prop,resolve){if(Object.prototype.hasOwnProperty.call(target,prop))return target[prop];const value=resolve();return target[prop]=value,value}function resolveFallback(fallback,prop,value){return isFunction(fallback)?fallback(prop,value):fallback}const getScope=(key,parent)=>!0===key?parent:"string"==typeof key?resolveObjectKey(parent,key):void 0;function addScopes(set,parentScopes,key,parentFallback,value){for(const parent of parentScopes){const scope=getScope(key,parent);if(scope){set.add(scope);const fallback=resolveFallback(scope._fallback,key,value);if(void 0!==fallback&&fallback!==key&&fallback!==parentFallback)return fallback}else if(!1===scope&&void 0!==parentFallback&&key!==parentFallback)return null}return!1}function createSubResolver(parentScopes,resolver,prop,value){const rootScopes=resolver._rootScopes,fallback=resolveFallback(resolver._fallback,prop,value),allScopes=[...parentScopes,...rootScopes],set=new Set;set.add(value);let key=addScopesFromKey(set,allScopes,prop,fallback||prop,value);return null!==key&&(void 0===fallback||fallback===prop||(key=addScopesFromKey(set,allScopes,fallback,key,value),null!==key))&&_createResolver(Array.from(set),[""],rootScopes,fallback,(()=>function(resolver,prop,value){const parent=resolver._getTarget();prop in parent||(parent[prop]={});const target=parent[prop];return isArray(target)&&isObject(value)?value:target||{}}(resolver,prop,value)))}function addScopesFromKey(set,allScopes,key,fallback,item){for(;key;)key=addScopes(set,allScopes,key,fallback,item);return key}function _resolveWithPrefixes(prop,prefixes,scopes,proxy){let value;for(const prefix of prefixes)if(value=_resolve(readKey(prefix,prop),scopes),void 0!==value)return needsSubResolver(prop,value)?createSubResolver(scopes,proxy,prop,value):value}function _resolve(key,scopes){for(const scope of scopes){if(!scope)continue;const value=scope[key];if(void 0!==value)return value}}function getKeysFromAllScopes(target){let keys=target._keys;return keys||(keys=target._keys=function(scopes){const set=new Set;for(const scope of scopes)for(const key of Object.keys(scope).filter((k=>!k.startsWith("_"))))set.add(key);return Array.from(set)}(target._scopes)),keys}function _parseObjectDataRadialScale(meta,data,start,count){const{iScale:iScale}=meta,{key:key="r"}=this._parsing,parsed=new Array(count);let i,ilen,index,item;for(i=0,ilen=count;i<ilen;++i)index=i+start,item=data[index],parsed[i]={r:iScale.parse(resolveObjectKey(item,key),index)};return parsed}const EPSILON=Number.EPSILON||1e-14,getPoint=(points,i)=>i<points.length&&!points[i].skip&&points[i],getValueAxis=indexAxis=>"x"===indexAxis?"y":"x";function splineCurve(firstPoint,middlePoint,afterPoint,t){const previous=firstPoint.skip?middlePoint:firstPoint,current=middlePoint,next=afterPoint.skip?middlePoint:afterPoint,d01=distanceBetweenPoints(current,previous),d12=distanceBetweenPoints(next,current);let s01=d01/(d01+d12),s12=d12/(d01+d12);s01=isNaN(s01)?0:s01,s12=isNaN(s12)?0:s12;const fa=t*s01,fb=t*s12;return{previous:{x:current.x-fa*(next.x-previous.x),y:current.y-fa*(next.y-previous.y)},next:{x:current.x+fb*(next.x-previous.x),y:current.y+fb*(next.y-previous.y)}}}function monotoneAdjust(points,deltaK,mK){const pointsLen=points.length;let alphaK,betaK,tauK,squaredMagnitude,pointCurrent,pointAfter=getPoint(points,0);for(let i=0;i<pointsLen-1;++i)pointCurrent=pointAfter,pointAfter=getPoint(points,i+1),pointCurrent&&pointAfter&&(almostEquals(deltaK[i],0,EPSILON)?mK[i]=mK[i+1]=0:(alphaK=mK[i]/deltaK[i],betaK=mK[i+1]/deltaK[i],squaredMagnitude=Math.pow(alphaK,2)+Math.pow(betaK,2),squaredMagnitude<=9||(tauK=3/Math.sqrt(squaredMagnitude),mK[i]=alphaK*tauK*deltaK[i],mK[i+1]=betaK*tauK*deltaK[i])))}function monotoneCompute(points,mK){let indexAxis=arguments.length>2&&void 0!==arguments[2]?arguments[2]:"x";const valueAxis=getValueAxis(indexAxis),pointsLen=points.length;let delta,pointBefore,pointCurrent,pointAfter=getPoint(points,0);for(let i=0;i<pointsLen;++i){if(pointBefore=pointCurrent,pointCurrent=pointAfter,pointAfter=getPoint(points,i+1),!pointCurrent)continue;const iPixel=pointCurrent[indexAxis],vPixel=pointCurrent[valueAxis];pointBefore&&(delta=(iPixel-pointBefore[indexAxis])/3,pointCurrent["cp1".concat(indexAxis)]=iPixel-delta,pointCurrent["cp1".concat(valueAxis)]=vPixel-delta*mK[i]),pointAfter&&(delta=(pointAfter[indexAxis]-iPixel)/3,pointCurrent["cp2".concat(indexAxis)]=iPixel+delta,pointCurrent["cp2".concat(valueAxis)]=vPixel+delta*mK[i])}}function splineCurveMonotone(points){let indexAxis=arguments.length>1&&void 0!==arguments[1]?arguments[1]:"x";const valueAxis=getValueAxis(indexAxis),pointsLen=points.length,deltaK=Array(pointsLen).fill(0),mK=Array(pointsLen);let i,pointBefore,pointCurrent,pointAfter=getPoint(points,0);for(i=0;i<pointsLen;++i)if(pointBefore=pointCurrent,pointCurrent=pointAfter,pointAfter=getPoint(points,i+1),pointCurrent){if(pointAfter){const slopeDelta=pointAfter[indexAxis]-pointCurrent[indexAxis];deltaK[i]=0!==slopeDelta?(pointAfter[valueAxis]-pointCurrent[valueAxis])/slopeDelta:0}mK[i]=pointBefore?pointAfter?sign(deltaK[i-1])!==sign(deltaK[i])?0:(deltaK[i-1]+deltaK[i])/2:deltaK[i-1]:deltaK[i]}monotoneAdjust(points,deltaK,mK),monotoneCompute(points,mK,indexAxis)}function capControlPoint(pt,min,max){return Math.max(Math.min(pt,max),min)}function _updateBezierControlPoints(points,options,area,loop,indexAxis){let i,ilen,point,controlPoints;if(options.spanGaps&&(points=points.filter((pt=>!pt.skip))),"monotone"===options.cubicInterpolationMode)splineCurveMonotone(points,indexAxis);else{let prev=loop?points[points.length-1]:points[0];for(i=0,ilen=points.length;i<ilen;++i)point=points[i],controlPoints=splineCurve(prev,point,points[Math.min(i+1,ilen-(loop?0:1))%ilen],options.tension),point.cp1x=controlPoints.previous.x,point.cp1y=controlPoints.previous.y,point.cp2x=controlPoints.next.x,point.cp2y=controlPoints.next.y,prev=point}options.capBezierPoints&&function(points,area){let i,ilen,point,inArea,inAreaPrev,inAreaNext=_isPointInArea(points[0],area);for(i=0,ilen=points.length;i<ilen;++i)inAreaPrev=inArea,inArea=inAreaNext,inAreaNext=i<ilen-1&&_isPointInArea(points[i+1],area),inArea&&(point=points[i],inAreaPrev&&(point.cp1x=capControlPoint(point.cp1x,area.left,area.right),point.cp1y=capControlPoint(point.cp1y,area.top,area.bottom)),inAreaNext&&(point.cp2x=capControlPoint(point.cp2x,area.left,area.right),point.cp2y=capControlPoint(point.cp2y,area.top,area.bottom)))}(points,area)}const atEdge=t=>0===t||1===t,elasticIn=(t,s,p)=>-Math.pow(2,10*(t-=1))*Math.sin((t-s)*TAU/p),elasticOut=(t,s,p)=>Math.pow(2,-10*t)*Math.sin((t-s)*TAU/p)+1,effects={linear:t=>t,easeInQuad:t=>t*t,easeOutQuad:t=>-t*(t-2),easeInOutQuad:t=>(t/=.5)<1?.5*t*t:-.5*(--t*(t-2)-1),easeInCubic:t=>t*t*t,easeOutCubic:t=>(t-=1)*t*t+1,easeInOutCubic:t=>(t/=.5)<1?.5*t*t*t:.5*((t-=2)*t*t+2),easeInQuart:t=>t*t*t*t,easeOutQuart:t=>-((t-=1)*t*t*t-1),easeInOutQuart:t=>(t/=.5)<1?.5*t*t*t*t:-.5*((t-=2)*t*t*t-2),easeInQuint:t=>t*t*t*t*t,easeOutQuint:t=>(t-=1)*t*t*t*t+1,easeInOutQuint:t=>(t/=.5)<1?.5*t*t*t*t*t:.5*((t-=2)*t*t*t*t+2),easeInSine:t=>1-Math.cos(t*HALF_PI),easeOutSine:t=>Math.sin(t*HALF_PI),easeInOutSine:t=>-.5*(Math.cos(PI*t)-1),easeInExpo:t=>0===t?0:Math.pow(2,10*(t-1)),easeOutExpo:t=>1===t?1:1-Math.pow(2,-10*t),easeInOutExpo:t=>atEdge(t)?t:t<.5?.5*Math.pow(2,10*(2*t-1)):.5*(2-Math.pow(2,-10*(2*t-1))),easeInCirc:t=>t>=1?t:-(Math.sqrt(1-t*t)-1),easeOutCirc:t=>Math.sqrt(1-(t-=1)*t),easeInOutCirc:t=>(t/=.5)<1?-.5*(Math.sqrt(1-t*t)-1):.5*(Math.sqrt(1-(t-=2)*t)+1),easeInElastic:t=>atEdge(t)?t:elasticIn(t,.075,.3),easeOutElastic:t=>atEdge(t)?t:elasticOut(t,.075,.3),easeInOutElastic(t){const s=.1125;return atEdge(t)?t:t<.5?.5*elasticIn(2*t,s,.45):.5+.5*elasticOut(2*t-1,s,.45)},easeInBack(t){const s=1.70158;return t*t*((s+1)*t-s)},easeOutBack(t){const s=1.70158;return(t-=1)*t*((s+1)*t+s)+1},easeInOutBack(t){let s=1.70158;return(t/=.5)<1?t*t*((1+(s*=1.525))*t-s)*.5:.5*((t-=2)*t*((1+(s*=1.525))*t+s)+2)},easeInBounce:t=>1-effects.easeOutBounce(1-t),easeOutBounce(t){const m=7.5625,d=2.75;return t<1/d?m*t*t:t<2/d?m*(t-=1.5/d)*t+.75:t<2.5/d?m*(t-=2.25/d)*t+.9375:m*(t-=2.625/d)*t+.984375},easeInOutBounce:t=>t<.5?.5*effects.easeInBounce(2*t):.5*effects.easeOutBounce(2*t-1)+.5};function _pointInLine(p1,p2,t,mode){return{x:p1.x+t*(p2.x-p1.x),y:p1.y+t*(p2.y-p1.y)}}function _steppedInterpolation(p1,p2,t,mode){return{x:p1.x+t*(p2.x-p1.x),y:"middle"===mode?t<.5?p1.y:p2.y:"after"===mode?t<1?p1.y:p2.y:t>0?p2.y:p1.y}}function _bezierInterpolation(p1,p2,t,mode){const cp1={x:p1.cp2x,y:p1.cp2y},cp2={x:p2.cp1x,y:p2.cp1y},a=_pointInLine(p1,cp1,t),b=_pointInLine(cp1,cp2,t),c=_pointInLine(cp2,p2,t),d=_pointInLine(a,b,t),e=_pointInLine(b,c,t);return _pointInLine(d,e,t)}const LINE_HEIGHT=/^(normal|(\d+(?:\.\d+)?)(px|em|%)?)$/,FONT_STYLE=/^(normal|italic|initial|inherit|unset|(oblique( -?[0-9]?[0-9]deg)?))$/;function toLineHeight(value,size){const matches=(""+value).match(LINE_HEIGHT);if(!matches||"normal"===matches[1])return 1.2*size;switch(value=+matches[2],matches[3]){case"px":return value;case"%":value/=100}return size*value}function _readValueToProps(value,props){const ret={},objProps=isObject(props),keys=objProps?Object.keys(props):props,read=isObject(value)?objProps?prop=>valueOrDefault(value[prop],value[props[prop]]):prop=>value[prop]:()=>value;for(const prop of keys)ret[prop]=+read(prop)||0;return ret}function toTRBL(value){return _readValueToProps(value,{top:"y",right:"x",bottom:"y",left:"x"})}function toTRBLCorners(value){return _readValueToProps(value,["topLeft","topRight","bottomLeft","bottomRight"])}function toPadding(value){const obj=toTRBL(value);return obj.width=obj.left+obj.right,obj.height=obj.top+obj.bottom,obj}function toFont(options,fallback){options=options||{},fallback=fallback||defaults.font;let size=valueOrDefault(options.size,fallback.size);"string"==typeof size&&(size=parseInt(size,10));let style=valueOrDefault(options.style,fallback.style);style&&!(""+style).match(FONT_STYLE)&&(console.warn('Invalid font style specified: "'+style+'"'),style=void 0);const font={family:valueOrDefault(options.family,fallback.family),lineHeight:toLineHeight(valueOrDefault(options.lineHeight,fallback.lineHeight),size),size:size,style:style,weight:valueOrDefault(options.weight,fallback.weight),string:""};return font.string=toFontString(font),font}function resolve(inputs,context,index,info){let i,ilen,value,cacheable=!0;for(i=0,ilen=inputs.length;i<ilen;++i)if(value=inputs[i],void 0!==value&&(void 0!==context&&"function"==typeof value&&(value=value(context),cacheable=!1),void 0!==index&&isArray(value)&&(value=value[index%value.length],cacheable=!1),void 0!==value))return info&&!cacheable&&(info.cacheable=!1),value}function _addGrace(minmax,grace,beginAtZero){const{min:min,max:max}=minmax,change=toDimension(grace,(max-min)/2),keepZero=(value,add)=>beginAtZero&&0===value?0:value+add;return{min:keepZero(min,-Math.abs(change)),max:keepZero(max,change)}}function createContext(parentContext,context){return Object.assign(Object.create(parentContext),context)}function getRtlAdapter(rtl,rectX,width){return rtl?function(rectX,width){return{x:x=>rectX+rectX+width-x,setWidth(w){width=w},textAlign:align=>"center"===align?align:"right"===align?"left":"right",xPlus:(x,value)=>x-value,leftForLtr:(x,itemWidth)=>x-itemWidth}}(rectX,width):{x:x=>x,setWidth(w){},textAlign:align=>align,xPlus:(x,value)=>x+value,leftForLtr:(x,_itemWidth)=>x}}function overrideTextDirection(ctx,direction){let style,original;"ltr"!==direction&&"rtl"!==direction||(style=ctx.canvas.style,original=[style.getPropertyValue("direction"),style.getPropertyPriority("direction")],style.setProperty("direction",direction,"important"),ctx.prevTextDirection=original)}function restoreTextDirection(ctx,original){void 0!==original&&(delete ctx.prevTextDirection,ctx.canvas.style.setProperty("direction",original[0],original[1]))}function propertyFn(property){return"angle"===property?{between:_angleBetween,compare:_angleDiff,normalize:_normalizeAngle}:{between:_isBetween,compare:(a,b)=>a-b,normalize:x=>x}}function normalizeSegment(_ref){let{start:start,end:end,count:count,loop:loop,style:style}=_ref;return{start:start%count,end:end%count,loop:loop&&(end-start+1)%count==0,style:style}}function _boundSegment(segment,points,bounds){if(!bounds)return[segment];const{property:property,start:startBound,end:endBound}=bounds,count=points.length,{compare:compare,between:between,normalize:normalize}=propertyFn(property),{start:start,end:end,loop:loop,style:style}=function(segment,points,bounds){const{property:property,start:startBound,end:endBound}=bounds,{between:between,normalize:normalize}=propertyFn(property),count=points.length;let i,ilen,{start:start,end:end,loop:loop}=segment;if(loop){for(start+=count,end+=count,i=0,ilen=count;i<ilen&&between(normalize(points[start%count][property]),startBound,endBound);++i)start--,end--;start%=count,end%=count}return end<start&&(end+=count),{start:start,end:end,loop:loop,style:segment.style}}(segment,points,bounds),result=[];let value,point,prevValue,inside=!1,subStart=null;const shouldStart=()=>inside||between(startBound,prevValue,value)&&0!==compare(startBound,prevValue),shouldStop=()=>!inside||0===compare(endBound,value)||between(endBound,prevValue,value);for(let i=start,prev=start;i<=end;++i)point=points[i%count],point.skip||(value=normalize(point[property]),value!==prevValue&&(inside=between(value,startBound,endBound),null===subStart&&shouldStart()&&(subStart=0===compare(value,startBound)?i:prev),null!==subStart&&shouldStop()&&(result.push(normalizeSegment({start:subStart,end:i,loop:loop,count:count,style:style})),subStart=null),prev=i,prevValue=value));return null!==subStart&&result.push(normalizeSegment({start:subStart,end:end,loop:loop,count:count,style:style})),result}function _boundSegments(line,bounds){const result=[],segments=line.segments;for(let i=0;i<segments.length;i++){const sub=_boundSegment(segments[i],line.points,bounds);sub.length&&result.push(...sub)}return result}function _computeSegments(line,segmentOptions){const points=line.points,spanGaps=line.options.spanGaps,count=points.length;if(!count)return[];const loop=!!line._loop,{start:start,end:end}=function(points,count,loop,spanGaps){let start=0,end=count-1;if(loop&&!spanGaps)for(;start<count&&!points[start].skip;)start++;for(;start<count&&points[start].skip;)start++;for(start%=count,loop&&(end+=start);end>start&&points[end%count].skip;)end--;return end%=count,{start:start,end:end}}(points,count,loop,spanGaps);return splitByStyles(line,!0===spanGaps?[{start:start,end:end,loop:loop}]:function(points,start,max,loop){const count=points.length,result=[];let end,last=start,prev=points[start];for(end=start+1;end<=max;++end){const cur=points[end%count];cur.skip||cur.stop?prev.skip||(loop=!1,result.push({start:start%count,end:(end-1)%count,loop:loop}),start=last=cur.stop?end:null):(last=end,prev.skip&&(start=end)),prev=cur}return null!==last&&result.push({start:start%count,end:last%count,loop:loop}),result}(points,start,end<start?end+count:end,!!line._fullLoop&&0===start&&end===count-1),points,segmentOptions)}function splitByStyles(line,segments,points,segmentOptions){return segmentOptions&&segmentOptions.setContext&&points?function(line,segments,points,segmentOptions){const chartContext=line._chart.getContext(),baseStyle=readStyle(line.options),{_datasetIndex:datasetIndex,options:{spanGaps:spanGaps}}=line,count=points.length,result=[];let prevStyle=baseStyle,start=segments[0].start,i=start;function addStyle(s,e,l,st){const dir=spanGaps?-1:1;if(s!==e){for(s+=count;points[s%count].skip;)s-=dir;for(;points[e%count].skip;)e+=dir;s%count!=e%count&&(result.push({start:s%count,end:e%count,loop:l,style:st}),prevStyle=st,start=e%count)}}for(const segment of segments){start=spanGaps?start:segment.start;let style,prev=points[start%count];for(i=start+1;i<=segment.end;i++){const pt=points[i%count];style=readStyle(segmentOptions.setContext(createContext(chartContext,{type:"segment",p0:prev,p1:pt,p0DataIndex:(i-1)%count,p1DataIndex:i%count,datasetIndex:datasetIndex}))),styleChanged(style,prevStyle)&&addStyle(start,i-1,segment.loop,prevStyle),prev=pt,prevStyle=style}start<i-1&&addStyle(start,i-1,segment.loop,prevStyle)}return result}(line,segments,points,segmentOptions):segments}function readStyle(options){return{backgroundColor:options.backgroundColor,borderCapStyle:options.borderCapStyle,borderDash:options.borderDash,borderDashOffset:options.borderDashOffset,borderJoinStyle:options.borderJoinStyle,borderWidth:options.borderWidth,borderColor:options.borderColor}}function styleChanged(style,prevStyle){if(!prevStyle)return!1;const cache=[],replacer=function(key,value){return isPatternOrGradient(value)?(cache.includes(value)||cache.push(value),cache.indexOf(value)):value};return JSON.stringify(style,replacer)!==JSON.stringify(prevStyle,replacer)}var helpers=Object.freeze({__proto__:null,HALF_PI:HALF_PI,INFINITY:INFINITY,PI:PI,PITAU:PITAU,QUARTER_PI:QUARTER_PI,RAD_PER_DEG:RAD_PER_DEG,TAU:TAU,TWO_THIRDS_PI:TWO_THIRDS_PI,_addGrace:_addGrace,_alignPixel:_alignPixel,_alignStartEnd:_alignStartEnd,_angleBetween:_angleBetween,_angleDiff:_angleDiff,_arrayUnique:_arrayUnique,_attachContext:_attachContext,_bezierCurveTo:_bezierCurveTo,_bezierInterpolation:_bezierInterpolation,_boundSegment:_boundSegment,_boundSegments:_boundSegments,_capitalize:_capitalize,_computeSegments:_computeSegments,_createResolver:_createResolver,_decimalPlaces:_decimalPlaces,_deprecated:function(scope,value,previous,current){void 0!==value&&console.warn(scope+': "'+previous+'" is deprecated. Please use "'+current+'" instead')},_descriptors:_descriptors,_elementsEqual:_elementsEqual,_factorize:_factorize,_filterBetween:_filterBetween,_getParentNode:_getParentNode,_getStartAndCountOfVisiblePoints:_getStartAndCountOfVisiblePoints,_int16Range:_int16Range,_isBetween:_isBetween,_isClickEvent:_isClickEvent,_isDomSupported:_isDomSupported,_isPointInArea:_isPointInArea,_limitValue:_limitValue,_longestText:_longestText,_lookup:_lookup,_lookupByKey:_lookupByKey,_measureText:_measureText,_merger:_merger,_mergerIf:_mergerIf,_normalizeAngle:_normalizeAngle,_parseObjectDataRadialScale:_parseObjectDataRadialScale,_pointInLine:_pointInLine,_readValueToProps:_readValueToProps,_rlookupByKey:_rlookupByKey,_scaleRangesChanged:_scaleRangesChanged,_setMinAndMaxByKey:_setMinAndMaxByKey,_splitKey:_splitKey,_steppedInterpolation:_steppedInterpolation,_steppedLineTo:_steppedLineTo,_textX:_textX,_toLeftRightCenter:_toLeftRightCenter,_updateBezierControlPoints:_updateBezierControlPoints,addRoundedRectPath:addRoundedRectPath,almostEquals:almostEquals,almostWhole:almostWhole,callback:callback,clearCanvas:clearCanvas,clipArea:clipArea,clone:clone$1,color:color,createContext:createContext,debounce:debounce,defined:defined,distanceBetweenPoints:distanceBetweenPoints,drawPoint:drawPoint,drawPointLegend:drawPointLegend,each:each,easingEffects:effects,finiteOrDefault:finiteOrDefault,fontString:function(pixelSize,fontStyle,fontFamily){return fontStyle+" "+pixelSize+"px "+fontFamily},formatNumber:formatNumber,getAngleFromPoint:getAngleFromPoint,getHoverColor:getHoverColor,getMaximumSize:getMaximumSize,getRelativePosition:getRelativePosition,getRtlAdapter:getRtlAdapter,getStyle:getStyle,isArray:isArray,isFinite:isNumberFinite,isFunction:isFunction,isNullOrUndef:isNullOrUndef,isNumber:isNumber,isObject:isObject,isPatternOrGradient:isPatternOrGradient,listenArrayEvents:listenArrayEvents,log10:log10,merge:merge,mergeIf:mergeIf,niceNum:niceNum,noop:noop,overrideTextDirection:overrideTextDirection,readUsedSize:readUsedSize,renderText:renderText,requestAnimFrame:requestAnimFrame,resolve:resolve,resolveObjectKey:resolveObjectKey,restoreTextDirection:restoreTextDirection,retinaScale:retinaScale,setsEqual:setsEqual,sign:sign,splineCurve:splineCurve,splineCurveMonotone:splineCurveMonotone,supportsEventListenerOptions:supportsEventListenerOptions,throttled:throttled,toDegrees:toDegrees,toDimension:toDimension,toFont:toFont,toFontString:toFontString,toLineHeight:toLineHeight,toPadding:toPadding,toPercentage:toPercentage,toRadians:toRadians,toTRBL:toTRBL,toTRBLCorners:toTRBLCorners,uid:uid,unclipArea:unclipArea,unlistenArrayEvents:unlistenArrayEvents,valueOrDefault:valueOrDefault});function binarySearch(metaset,axis,value,intersect){const{controller:controller,data:data,_sorted:_sorted}=metaset,iScale=controller._cachedMeta.iScale;if(iScale&&axis===iScale.axis&&"r"!==axis&&_sorted&&data.length){const lookupMethod=iScale._reversePixels?_rlookupByKey:_lookupByKey;if(!intersect)return lookupMethod(data,axis,value);if(controller._sharedOptions){const el=data[0],range="function"==typeof el.getRange&&el.getRange(axis);if(range){const start=lookupMethod(data,axis,value-range),end=lookupMethod(data,axis,value+range);return{lo:start.lo,hi:end.hi}}}}return{lo:0,hi:data.length-1}}function evaluateInteractionItems(chart,axis,position,handler,intersect){const metasets=chart.getSortedVisibleDatasetMetas(),value=position[axis];for(let i=0,ilen=metasets.length;i<ilen;++i){const{index:index,data:data}=metasets[i],{lo:lo,hi:hi}=binarySearch(metasets[i],axis,value,intersect);for(let j=lo;j<=hi;++j){const element=data[j];element.skip||handler(element,index,j)}}}function getIntersectItems(chart,position,axis,useFinalPosition,includeInvisible){const items=[];return includeInvisible||chart.isPointInArea(position)?(evaluateInteractionItems(chart,axis,position,(function(element,datasetIndex,index){(includeInvisible||_isPointInArea(element,chart.chartArea,0))&&element.inRange(position.x,position.y,useFinalPosition)&&items.push({element:element,datasetIndex:datasetIndex,index:index})}),!0),items):items}function getNearestCartesianItems(chart,position,axis,intersect,useFinalPosition,includeInvisible){let items=[];const distanceMetric=function(axis){const useX=-1!==axis.indexOf("x"),useY=-1!==axis.indexOf("y");return function(pt1,pt2){const deltaX=useX?Math.abs(pt1.x-pt2.x):0,deltaY=useY?Math.abs(pt1.y-pt2.y):0;return Math.sqrt(Math.pow(deltaX,2)+Math.pow(deltaY,2))}}(axis);let minDistance=Number.POSITIVE_INFINITY;return evaluateInteractionItems(chart,axis,position,(function(element,datasetIndex,index){const inRange=element.inRange(position.x,position.y,useFinalPosition);if(intersect&&!inRange)return;const center=element.getCenterPoint(useFinalPosition);if(!includeInvisible&&!chart.isPointInArea(center)&&!inRange)return;const distance=distanceMetric(position,center);distance<minDistance?(items=[{element:element,datasetIndex:datasetIndex,index:index}],minDistance=distance):distance===minDistance&&items.push({element:element,datasetIndex:datasetIndex,index:index})})),items}function getNearestItems(chart,position,axis,intersect,useFinalPosition,includeInvisible){return includeInvisible||chart.isPointInArea(position)?"r"!==axis||intersect?getNearestCartesianItems(chart,position,axis,intersect,useFinalPosition,includeInvisible):function(chart,position,axis,useFinalPosition){let items=[];return evaluateInteractionItems(chart,axis,position,(function(element,datasetIndex,index){const{startAngle:startAngle,endAngle:endAngle}=element.getProps(["startAngle","endAngle"],useFinalPosition),{angle:angle}=getAngleFromPoint(element,{x:position.x,y:position.y});_angleBetween(angle,startAngle,endAngle)&&items.push({element:element,datasetIndex:datasetIndex,index:index})})),items}(chart,position,axis,useFinalPosition):[]}function getAxisItems(chart,position,axis,intersect,useFinalPosition){const items=[],rangeMethod="x"===axis?"inXRange":"inYRange";let intersectsItem=!1;return evaluateInteractionItems(chart,axis,position,((element,datasetIndex,index)=>{element[rangeMethod](position[axis],useFinalPosition)&&(items.push({element:element,datasetIndex:datasetIndex,index:index}),intersectsItem=intersectsItem||element.inRange(position.x,position.y,useFinalPosition))})),intersect&&!intersectsItem?[]:items}var Interaction={evaluateInteractionItems:evaluateInteractionItems,modes:{index(chart,e,options,useFinalPosition){const position=getRelativePosition(e,chart),axis=options.axis||"x",includeInvisible=options.includeInvisible||!1,items=options.intersect?getIntersectItems(chart,position,axis,useFinalPosition,includeInvisible):getNearestItems(chart,position,axis,!1,useFinalPosition,includeInvisible),elements=[];return items.length?(chart.getSortedVisibleDatasetMetas().forEach((meta=>{const index=items[0].index,element=meta.data[index];element&&!element.skip&&elements.push({element:element,datasetIndex:meta.index,index:index})})),elements):[]},dataset(chart,e,options,useFinalPosition){const position=getRelativePosition(e,chart),axis=options.axis||"xy",includeInvisible=options.includeInvisible||!1;let items=options.intersect?getIntersectItems(chart,position,axis,useFinalPosition,includeInvisible):getNearestItems(chart,position,axis,!1,useFinalPosition,includeInvisible);if(items.length>0){const datasetIndex=items[0].datasetIndex,data=chart.getDatasetMeta(datasetIndex).data;items=[];for(let i=0;i<data.length;++i)items.push({element:data[i],datasetIndex:datasetIndex,index:i})}return items},point:(chart,e,options,useFinalPosition)=>getIntersectItems(chart,getRelativePosition(e,chart),options.axis||"xy",useFinalPosition,options.includeInvisible||!1),nearest(chart,e,options,useFinalPosition){const position=getRelativePosition(e,chart),axis=options.axis||"xy",includeInvisible=options.includeInvisible||!1;return getNearestItems(chart,position,axis,options.intersect,useFinalPosition,includeInvisible)},x:(chart,e,options,useFinalPosition)=>getAxisItems(chart,getRelativePosition(e,chart),"x",options.intersect,useFinalPosition),y:(chart,e,options,useFinalPosition)=>getAxisItems(chart,getRelativePosition(e,chart),"y",options.intersect,useFinalPosition)}};const STATIC_POSITIONS=["left","top","right","bottom"];function filterByPosition(array,position){return array.filter((v=>v.pos===position))}function filterDynamicPositionByAxis(array,axis){return array.filter((v=>-1===STATIC_POSITIONS.indexOf(v.pos)&&v.box.axis===axis))}function sortByWeight(array,reverse){return array.sort(((a,b)=>{const v0=reverse?b:a,v1=reverse?a:b;return v0.weight===v1.weight?v0.index-v1.index:v0.weight-v1.weight}))}function setLayoutDims(layouts,params){const stacks=function(layouts){const stacks={};for(const wrap of layouts){const{stack:stack,pos:pos,stackWeight:stackWeight}=wrap;if(!stack||!STATIC_POSITIONS.includes(pos))continue;const _stack=stacks[stack]||(stacks[stack]={count:0,placed:0,weight:0,size:0});_stack.count++,_stack.weight+=stackWeight}return stacks}(layouts),{vBoxMaxWidth:vBoxMaxWidth,hBoxMaxHeight:hBoxMaxHeight}=params;let i,ilen,layout;for(i=0,ilen=layouts.length;i<ilen;++i){layout=layouts[i];const{fullSize:fullSize}=layout.box,stack=stacks[layout.stack],factor=stack&&layout.stackWeight/stack.weight;layout.horizontal?(layout.width=factor?factor*vBoxMaxWidth:fullSize&&params.availableWidth,layout.height=hBoxMaxHeight):(layout.width=vBoxMaxWidth,layout.height=factor?factor*hBoxMaxHeight:fullSize&&params.availableHeight)}return stacks}function getCombinedMax(maxPadding,chartArea,a,b){return Math.max(maxPadding[a],chartArea[a])+Math.max(maxPadding[b],chartArea[b])}function updateMaxPadding(maxPadding,boxPadding){maxPadding.top=Math.max(maxPadding.top,boxPadding.top),maxPadding.left=Math.max(maxPadding.left,boxPadding.left),maxPadding.bottom=Math.max(maxPadding.bottom,boxPadding.bottom),maxPadding.right=Math.max(maxPadding.right,boxPadding.right)}function updateDims(chartArea,params,layout,stacks){const{pos:pos,box:box}=layout,maxPadding=chartArea.maxPadding;if(!isObject(pos)){layout.size&&(chartArea[pos]-=layout.size);const stack=stacks[layout.stack]||{size:0,count:1};stack.size=Math.max(stack.size,layout.horizontal?box.height:box.width),layout.size=stack.size/stack.count,chartArea[pos]+=layout.size}box.getPadding&&updateMaxPadding(maxPadding,box.getPadding());const newWidth=Math.max(0,params.outerWidth-getCombinedMax(maxPadding,chartArea,"left","right")),newHeight=Math.max(0,params.outerHeight-getCombinedMax(maxPadding,chartArea,"top","bottom")),widthChanged=newWidth!==chartArea.w,heightChanged=newHeight!==chartArea.h;return chartArea.w=newWidth,chartArea.h=newHeight,layout.horizontal?{same:widthChanged,other:heightChanged}:{same:heightChanged,other:widthChanged}}function getMargins(horizontal,chartArea){const maxPadding=chartArea.maxPadding;function marginForPositions(positions){const margin={left:0,top:0,right:0,bottom:0};return positions.forEach((pos=>{margin[pos]=Math.max(chartArea[pos],maxPadding[pos])})),margin}return marginForPositions(horizontal?["left","right"]:["top","bottom"])}function fitBoxes(boxes,chartArea,params,stacks){const refitBoxes=[];let i,ilen,layout,box,refit,changed;for(i=0,ilen=boxes.length,refit=0;i<ilen;++i){layout=boxes[i],box=layout.box,box.update(layout.width||chartArea.w,layout.height||chartArea.h,getMargins(layout.horizontal,chartArea));const{same:same,other:other}=updateDims(chartArea,params,layout,stacks);refit|=same&&refitBoxes.length,changed=changed||other,box.fullSize||refitBoxes.push(layout)}return refit&&fitBoxes(refitBoxes,chartArea,params,stacks)||changed}function setBoxDims(box,left,top,width,height){box.top=top,box.left=left,box.right=left+width,box.bottom=top+height,box.width=width,box.height=height}function placeBoxes(boxes,chartArea,params,stacks){const userPadding=params.padding;let{x:x,y:y}=chartArea;for(const layout of boxes){const box=layout.box,stack=stacks[layout.stack]||{count:1,placed:0,weight:1},weight=layout.stackWeight/stack.weight||1;if(layout.horizontal){const width=chartArea.w*weight,height=stack.size||box.height;defined(stack.start)&&(y=stack.start),box.fullSize?setBoxDims(box,userPadding.left,y,params.outerWidth-userPadding.right-userPadding.left,height):setBoxDims(box,chartArea.left+stack.placed,y,width,height),stack.start=y,stack.placed+=width,y=box.bottom}else{const height=chartArea.h*weight,width=stack.size||box.width;defined(stack.start)&&(x=stack.start),box.fullSize?setBoxDims(box,x,userPadding.top,width,params.outerHeight-userPadding.bottom-userPadding.top):setBoxDims(box,x,chartArea.top+stack.placed,width,height),stack.start=x,stack.placed+=height,x=box.right}}chartArea.x=x,chartArea.y=y}var layouts={addBox(chart,item){chart.boxes||(chart.boxes=[]),item.fullSize=item.fullSize||!1,item.position=item.position||"top",item.weight=item.weight||0,item._layers=item._layers||function(){return[{z:0,draw(chartArea){item.draw(chartArea)}}]},chart.boxes.push(item)},removeBox(chart,layoutItem){const index=chart.boxes?chart.boxes.indexOf(layoutItem):-1;-1!==index&&chart.boxes.splice(index,1)},configure(chart,item,options){item.fullSize=options.fullSize,item.position=options.position,item.weight=options.weight},update(chart,width,height,minPadding){if(!chart)return;const padding=toPadding(chart.options.layout.padding),availableWidth=Math.max(width-padding.width,0),availableHeight=Math.max(height-padding.height,0),boxes=function(boxes){const layoutBoxes=function(boxes){const layoutBoxes=[];let i,ilen,box,pos,stack,stackWeight;for(i=0,ilen=(boxes||[]).length;i<ilen;++i)box=boxes[i],({position:pos,options:{stack:stack,stackWeight:stackWeight=1}}=box),layoutBoxes.push({index:i,box:box,pos:pos,horizontal:box.isHorizontal(),weight:box.weight,stack:stack&&pos+stack,stackWeight:stackWeight});return layoutBoxes}(boxes),fullSize=sortByWeight(layoutBoxes.filter((wrap=>wrap.box.fullSize)),!0),left=sortByWeight(filterByPosition(layoutBoxes,"left"),!0),right=sortByWeight(filterByPosition(layoutBoxes,"right")),top=sortByWeight(filterByPosition(layoutBoxes,"top"),!0),bottom=sortByWeight(filterByPosition(layoutBoxes,"bottom")),centerHorizontal=filterDynamicPositionByAxis(layoutBoxes,"x"),centerVertical=filterDynamicPositionByAxis(layoutBoxes,"y");return{fullSize:fullSize,leftAndTop:left.concat(top),rightAndBottom:right.concat(centerVertical).concat(bottom).concat(centerHorizontal),chartArea:filterByPosition(layoutBoxes,"chartArea"),vertical:left.concat(right).concat(centerVertical),horizontal:top.concat(bottom).concat(centerHorizontal)}}(chart.boxes),verticalBoxes=boxes.vertical,horizontalBoxes=boxes.horizontal;each(chart.boxes,(box=>{"function"==typeof box.beforeLayout&&box.beforeLayout()}));const visibleVerticalBoxCount=verticalBoxes.reduce(((total,wrap)=>wrap.box.options&&!1===wrap.box.options.display?total:total+1),0)||1,params=Object.freeze({outerWidth:width,outerHeight:height,padding:padding,availableWidth:availableWidth,availableHeight:availableHeight,vBoxMaxWidth:availableWidth/2/visibleVerticalBoxCount,hBoxMaxHeight:availableHeight/2}),maxPadding=Object.assign({},padding);updateMaxPadding(maxPadding,toPadding(minPadding));const chartArea=Object.assign({maxPadding:maxPadding,w:availableWidth,h:availableHeight,x:padding.left,y:padding.top},padding),stacks=setLayoutDims(verticalBoxes.concat(horizontalBoxes),params);fitBoxes(boxes.fullSize,chartArea,params,stacks),fitBoxes(verticalBoxes,chartArea,params,stacks),fitBoxes(horizontalBoxes,chartArea,params,stacks)&&fitBoxes(verticalBoxes,chartArea,params,stacks),function(chartArea){const maxPadding=chartArea.maxPadding;function updatePos(pos){const change=Math.max(maxPadding[pos]-chartArea[pos],0);return chartArea[pos]+=change,change}chartArea.y+=updatePos("top"),chartArea.x+=updatePos("left"),updatePos("right"),updatePos("bottom")}(chartArea),placeBoxes(boxes.leftAndTop,chartArea,params,stacks),chartArea.x+=chartArea.w,chartArea.y+=chartArea.h,placeBoxes(boxes.rightAndBottom,chartArea,params,stacks),chart.chartArea={left:chartArea.left,top:chartArea.top,right:chartArea.left+chartArea.w,bottom:chartArea.top+chartArea.h,height:chartArea.h,width:chartArea.w},each(boxes.chartArea,(layout=>{const box=layout.box;Object.assign(box,chart.chartArea),box.update(chartArea.w,chartArea.h,{left:0,top:0,right:0,bottom:0})}))}};class BasePlatform{acquireContext(canvas,aspectRatio){}releaseContext(context){return!1}addEventListener(chart,type,listener){}removeEventListener(chart,type,listener){}getDevicePixelRatio(){return 1}getMaximumSize(element,width,height,aspectRatio){return width=Math.max(0,width||element.width),height=height||element.height,{width:width,height:Math.max(0,aspectRatio?Math.floor(width/aspectRatio):height)}}isAttached(canvas){return!0}updateConfig(config){}}class BasicPlatform extends BasePlatform{acquireContext(item){return item&&item.getContext&&item.getContext("2d")||null}updateConfig(config){config.options.animation=!1}}const EVENT_TYPES={touchstart:"mousedown",touchmove:"mousemove",touchend:"mouseup",pointerenter:"mouseenter",pointerdown:"mousedown",pointermove:"mousemove",pointerup:"mouseup",pointerleave:"mouseout",pointerout:"mouseout"},isNullOrEmpty=value=>null===value||""===value,eventListenerOptions=!!supportsEventListenerOptions&&{passive:!0};function removeListener(chart,type,listener){chart&&chart.canvas&&chart.canvas.removeEventListener(type,listener,eventListenerOptions)}function nodeListContains(nodeList,canvas){for(const node of nodeList)if(node===canvas||node.contains(canvas))return!0}function createAttachObserver(chart,type,listener){const canvas=chart.canvas,observer=new MutationObserver((entries=>{let trigger=!1;for(const entry of entries)trigger=trigger||nodeListContains(entry.addedNodes,canvas),trigger=trigger&&!nodeListContains(entry.removedNodes,canvas);trigger&&listener()}));return observer.observe(document,{childList:!0,subtree:!0}),observer}function createDetachObserver(chart,type,listener){const canvas=chart.canvas,observer=new MutationObserver((entries=>{let trigger=!1;for(const entry of entries)trigger=trigger||nodeListContains(entry.removedNodes,canvas),trigger=trigger&&!nodeListContains(entry.addedNodes,canvas);trigger&&listener()}));return observer.observe(document,{childList:!0,subtree:!0}),observer}const drpListeningCharts=new Map;let oldDevicePixelRatio=0;function onWindowResize(){const dpr=window.devicePixelRatio;dpr!==oldDevicePixelRatio&&(oldDevicePixelRatio=dpr,drpListeningCharts.forEach(((resize,chart)=>{chart.currentDevicePixelRatio!==dpr&&resize()})))}function createResizeObserver(chart,type,listener){const canvas=chart.canvas,container=canvas&&_getParentNode(canvas);if(!container)return;const resize=throttled(((width,height)=>{const w=container.clientWidth;listener(width,height),w<container.clientWidth&&listener()}),window),observer=new ResizeObserver((entries=>{const entry=entries[0],width=entry.contentRect.width,height=entry.contentRect.height;0===width&&0===height||resize(width,height)}));return observer.observe(container),function(chart,resize){drpListeningCharts.size||window.addEventListener("resize",onWindowResize),drpListeningCharts.set(chart,resize)}(chart,resize),observer}function releaseObserver(chart,type,observer){observer&&observer.disconnect(),"resize"===type&&function(chart){drpListeningCharts.delete(chart),drpListeningCharts.size||window.removeEventListener("resize",onWindowResize)}(chart)}function createProxyAndListen(chart,type,listener){const canvas=chart.canvas,proxy=throttled((event=>{null!==chart.ctx&&listener(function(event,chart){const type=EVENT_TYPES[event.type]||event.type,{x:x,y:y}=getRelativePosition(event,chart);return{type:type,chart:chart,native:event,x:void 0!==x?x:null,y:void 0!==y?y:null}}(event,chart))}),chart);return function(node,type,listener){node&&node.addEventListener(type,listener,eventListenerOptions)}(canvas,type,proxy),proxy}class DomPlatform extends BasePlatform{acquireContext(canvas,aspectRatio){const context=canvas&&canvas.getContext&&canvas.getContext("2d");return context&&context.canvas===canvas?(function(canvas,aspectRatio){const style=canvas.style,renderHeight=canvas.getAttribute("height"),renderWidth=canvas.getAttribute("width");if(canvas.$chartjs={initial:{height:renderHeight,width:renderWidth,style:{display:style.display,height:style.height,width:style.width}}},style.display=style.display||"block",style.boxSizing=style.boxSizing||"border-box",isNullOrEmpty(renderWidth)){const displayWidth=readUsedSize(canvas,"width");void 0!==displayWidth&&(canvas.width=displayWidth)}if(isNullOrEmpty(renderHeight))if(""===canvas.style.height)canvas.height=canvas.width/(aspectRatio||2);else{const displayHeight=readUsedSize(canvas,"height");void 0!==displayHeight&&(canvas.height=displayHeight)}}(canvas,aspectRatio),context):null}releaseContext(context){const canvas=context.canvas;if(!canvas.$chartjs)return!1;const initial=canvas.$chartjs.initial;["height","width"].forEach((prop=>{const value=initial[prop];isNullOrUndef(value)?canvas.removeAttribute(prop):canvas.setAttribute(prop,value)}));const style=initial.style||{};return Object.keys(style).forEach((key=>{canvas.style[key]=style[key]})),canvas.width=canvas.width,delete canvas.$chartjs,!0}addEventListener(chart,type,listener){this.removeEventListener(chart,type);const proxies=chart.$proxies||(chart.$proxies={}),handler={attach:createAttachObserver,detach:createDetachObserver,resize:createResizeObserver}[type]||createProxyAndListen;proxies[type]=handler(chart,type,listener)}removeEventListener(chart,type){const proxies=chart.$proxies||(chart.$proxies={}),proxy=proxies[type];proxy&&(({attach:releaseObserver,detach:releaseObserver,resize:releaseObserver}[type]||removeListener)(chart,type,proxy),proxies[type]=void 0)}getDevicePixelRatio(){return window.devicePixelRatio}getMaximumSize(canvas,width,height,aspectRatio){return getMaximumSize(canvas,width,height,aspectRatio)}isAttached(canvas){const container=_getParentNode(canvas);return!(!container||!container.isConnected)}}function _detectPlatform(canvas){return!_isDomSupported()||"undefined"!=typeof OffscreenCanvas&&canvas instanceof OffscreenCanvas?BasicPlatform:DomPlatform}var platforms=Object.freeze({__proto__:null,BasePlatform:BasePlatform,BasicPlatform:BasicPlatform,DomPlatform:DomPlatform,_detectPlatform:_detectPlatform});const interpolators={boolean:(from,to,factor)=>factor>.5?to:from,color(from,to,factor){const c0=color(from||"transparent"),c1=c0.valid&&color(to||"transparent");return c1&&c1.valid?c1.mix(c0,factor).hexString():to},number:(from,to,factor)=>from+(to-from)*factor};class Animation{constructor(cfg,target,prop,to){const currentValue=target[prop];to=resolve([cfg.to,to,currentValue,cfg.from]);const from=resolve([cfg.from,currentValue,to]);this._active=!0,this._fn=cfg.fn||interpolators[cfg.type||typeof from],this._easing=effects[cfg.easing]||effects.linear,this._start=Math.floor(Date.now()+(cfg.delay||0)),this._duration=this._total=Math.floor(cfg.duration),this._loop=!!cfg.loop,this._target=target,this._prop=prop,this._from=from,this._to=to,this._promises=void 0}active(){return this._active}update(cfg,to,date){if(this._active){this._notify(!1);const currentValue=this._target[this._prop],elapsed=date-this._start,remain=this._duration-elapsed;this._start=date,this._duration=Math.floor(Math.max(remain,cfg.duration)),this._total+=elapsed,this._loop=!!cfg.loop,this._to=resolve([cfg.to,to,currentValue,cfg.from]),this._from=resolve([cfg.from,currentValue,to])}}cancel(){this._active&&(this.tick(Date.now()),this._active=!1,this._notify(!1))}tick(date){const elapsed=date-this._start,duration=this._duration,prop=this._prop,from=this._from,loop=this._loop,to=this._to;let factor;if(this._active=from!==to&&(loop||elapsed<duration),!this._active)return this._target[prop]=to,void this._notify(!0);elapsed<0?this._target[prop]=from:(factor=elapsed/duration%2,factor=loop&&factor>1?2-factor:factor,factor=this._easing(Math.min(1,Math.max(0,factor))),this._target[prop]=this._fn(from,to,factor))}wait(){const promises=this._promises||(this._promises=[]);return new Promise(((res,rej)=>{promises.push({res:res,rej:rej})}))}_notify(resolved){const method=resolved?"res":"rej",promises=this._promises||[];for(let i=0;i<promises.length;i++)promises[i][method]()}}class Animations{constructor(chart,config){this._chart=chart,this._properties=new Map,this.configure(config)}configure(config){if(!isObject(config))return;const animationOptions=Object.keys(defaults.animation),animatedProps=this._properties;Object.getOwnPropertyNames(config).forEach((key=>{const cfg=config[key];if(!isObject(cfg))return;const resolved={};for(const option of animationOptions)resolved[option]=cfg[option];(isArray(cfg.properties)&&cfg.properties||[key]).forEach((prop=>{prop!==key&&animatedProps.has(prop)||animatedProps.set(prop,resolved)}))}))}_animateOptions(target,values){const newOptions=values.options,options=function(target,newOptions){if(!newOptions)return;let options=target.options;if(options)return options.$shared&&(target.options=options=Object.assign({},options,{$shared:!1,$animations:{}})),options;target.options=newOptions}(target,newOptions);if(!options)return[];const animations=this._createAnimations(options,newOptions);return newOptions.$shared&&function(animations,properties){const running=[],keys=Object.keys(properties);for(let i=0;i<keys.length;i++){const anim=animations[keys[i]];anim&&anim.active()&&running.push(anim.wait())}return Promise.all(running)}(target.options.$animations,newOptions).then((()=>{target.options=newOptions}),(()=>{})),animations}_createAnimations(target,values){const animatedProps=this._properties,animations=[],running=target.$animations||(target.$animations={}),props=Object.keys(values),date=Date.now();let i;for(i=props.length-1;i>=0;--i){const prop=props[i];if("$"===prop.charAt(0))continue;if("options"===prop){animations.push(...this._animateOptions(target,values));continue}const value=values[prop];let animation=running[prop];const cfg=animatedProps.get(prop);if(animation){if(cfg&&animation.active()){animation.update(cfg,value,date);continue}animation.cancel()}cfg&&cfg.duration?(running[prop]=animation=new Animation(cfg,target,prop,value),animations.push(animation)):target[prop]=value}return animations}update(target,values){if(0===this._properties.size)return void Object.assign(target,values);const animations=this._createAnimations(target,values);return animations.length?(animator.add(this._chart,animations),!0):void 0}}function scaleClip(scale,allowedOverflow){const opts=scale&&scale.options||{},reverse=opts.reverse,min=void 0===opts.min?allowedOverflow:0,max=void 0===opts.max?allowedOverflow:0;return{start:reverse?max:min,end:reverse?min:max}}function getSortedDatasetIndices(chart,filterVisible){const keys=[],metasets=chart._getSortedDatasetMetas(filterVisible);let i,ilen;for(i=0,ilen=metasets.length;i<ilen;++i)keys.push(metasets[i].index);return keys}function applyStack(stack,value,dsIndex){let options=arguments.length>3&&void 0!==arguments[3]?arguments[3]:{};const keys=stack.keys,singleMode="single"===options.mode;let i,ilen,datasetIndex,otherValue;if(null!==value){for(i=0,ilen=keys.length;i<ilen;++i){if(datasetIndex=+keys[i],datasetIndex===dsIndex){if(options.all)continue;break}otherValue=stack.values[datasetIndex],isNumberFinite(otherValue)&&(singleMode||0===value||sign(value)===sign(otherValue))&&(value+=otherValue)}return value}}function isStacked(scale,meta){const stacked=scale&&scale.options.stacked;return stacked||void 0===stacked&&void 0!==meta.stack}function getOrCreateStack(stacks,stackKey,indexValue){const subStack=stacks[stackKey]||(stacks[stackKey]={});return subStack[indexValue]||(subStack[indexValue]={})}function getLastIndexInStack(stack,vScale,positive,type){for(const meta of vScale.getMatchingVisibleMetas(type).reverse()){const value=stack[meta.index];if(positive&&value>0||!positive&&value<0)return meta.index}return null}function updateStacks(controller,parsed){const{chart:chart,_cachedMeta:meta}=controller,stacks=chart._stacks||(chart._stacks={}),{iScale:iScale,vScale:vScale,index:datasetIndex}=meta,iAxis=iScale.axis,vAxis=vScale.axis,key=function(indexScale,valueScale,meta){return"".concat(indexScale.id,".").concat(valueScale.id,".").concat(meta.stack||meta.type)}(iScale,vScale,meta),ilen=parsed.length;let stack;for(let i=0;i<ilen;++i){const item=parsed[i],{[iAxis]:index,[vAxis]:value}=item;stack=(item._stacks||(item._stacks={}))[vAxis]=getOrCreateStack(stacks,key,index),stack[datasetIndex]=value,stack._top=getLastIndexInStack(stack,vScale,!0,meta.type),stack._bottom=getLastIndexInStack(stack,vScale,!1,meta.type),(stack._visualValues||(stack._visualValues={}))[datasetIndex]=value}}function getFirstScaleId(chart,axis){const scales=chart.scales;return Object.keys(scales).filter((key=>scales[key].axis===axis)).shift()}function clearStacks(meta,items){const datasetIndex=meta.controller.index,axis=meta.vScale&&meta.vScale.axis;if(axis){items=items||meta._parsed;for(const parsed of items){const stacks=parsed._stacks;if(!stacks||void 0===stacks[axis]||void 0===stacks[axis][datasetIndex])return;delete stacks[axis][datasetIndex],void 0!==stacks[axis]._visualValues&&void 0!==stacks[axis]._visualValues[datasetIndex]&&delete stacks[axis]._visualValues[datasetIndex]}}}const isDirectUpdateMode=mode=>"reset"===mode||"none"===mode,cloneIfNotShared=(cached,shared)=>shared?cached:Object.assign({},cached);class DatasetController{constructor(chart,datasetIndex){this.chart=chart,this._ctx=chart.ctx,this.index=datasetIndex,this._cachedDataOpts={},this._cachedMeta=this.getMeta(),this._type=this._cachedMeta.type,this.options=void 0,this._parsing=!1,this._data=void 0,this._objectData=void 0,this._sharedOptions=void 0,this._drawStart=void 0,this._drawCount=void 0,this.enableOptionSharing=!1,this.supportsDecimation=!1,this.$context=void 0,this._syncList=[],this.datasetElementType=new.target.datasetElementType,this.dataElementType=new.target.dataElementType,this.initialize()}initialize(){const meta=this._cachedMeta;this.configure(),this.linkScales(),meta._stacked=isStacked(meta.vScale,meta),this.addElements(),this.options.fill&&!this.chart.isPluginEnabled("filler")&&console.warn("Tried to use the 'fill' option without the 'Filler' plugin enabled. Please import and register the 'Filler' plugin and make sure it is not disabled in the options")}updateIndex(datasetIndex){this.index!==datasetIndex&&clearStacks(this._cachedMeta),this.index=datasetIndex}linkScales(){const chart=this.chart,meta=this._cachedMeta,dataset=this.getDataset(),chooseId=(axis,x,y,r)=>"x"===axis?x:"r"===axis?r:y,xid=meta.xAxisID=valueOrDefault(dataset.xAxisID,getFirstScaleId(chart,"x")),yid=meta.yAxisID=valueOrDefault(dataset.yAxisID,getFirstScaleId(chart,"y")),rid=meta.rAxisID=valueOrDefault(dataset.rAxisID,getFirstScaleId(chart,"r")),indexAxis=meta.indexAxis,iid=meta.iAxisID=chooseId(indexAxis,xid,yid,rid),vid=meta.vAxisID=chooseId(indexAxis,yid,xid,rid);meta.xScale=this.getScaleForId(xid),meta.yScale=this.getScaleForId(yid),meta.rScale=this.getScaleForId(rid),meta.iScale=this.getScaleForId(iid),meta.vScale=this.getScaleForId(vid)}getDataset(){return this.chart.data.datasets[this.index]}getMeta(){return this.chart.getDatasetMeta(this.index)}getScaleForId(scaleID){return this.chart.scales[scaleID]}_getOtherScale(scale){const meta=this._cachedMeta;return scale===meta.iScale?meta.vScale:meta.iScale}reset(){this._update("reset")}_destroy(){const meta=this._cachedMeta;this._data&&unlistenArrayEvents(this._data,this),meta._stacked&&clearStacks(meta)}_dataCheck(){const dataset=this.getDataset(),data=dataset.data||(dataset.data=[]),_data=this._data;if(isObject(data))this._data=function(data){const keys=Object.keys(data),adata=new Array(keys.length);let i,ilen,key;for(i=0,ilen=keys.length;i<ilen;++i)key=keys[i],adata[i]={x:key,y:data[key]};return adata}(data);else if(_data!==data){if(_data){unlistenArrayEvents(_data,this);const meta=this._cachedMeta;clearStacks(meta),meta._parsed=[]}data&&Object.isExtensible(data)&&listenArrayEvents(data,this),this._syncList=[],this._data=data}}addElements(){const meta=this._cachedMeta;this._dataCheck(),this.datasetElementType&&(meta.dataset=new this.datasetElementType)}buildOrUpdateElements(resetNewElements){const meta=this._cachedMeta,dataset=this.getDataset();let stackChanged=!1;this._dataCheck();const oldStacked=meta._stacked;meta._stacked=isStacked(meta.vScale,meta),meta.stack!==dataset.stack&&(stackChanged=!0,clearStacks(meta),meta.stack=dataset.stack),this._resyncElements(resetNewElements),(stackChanged||oldStacked!==meta._stacked)&&updateStacks(this,meta._parsed)}configure(){const config=this.chart.config,scopeKeys=config.datasetScopeKeys(this._type),scopes=config.getOptionScopes(this.getDataset(),scopeKeys,!0);this.options=config.createResolver(scopes,this.getContext()),this._parsing=this.options.parsing,this._cachedDataOpts={}}parse(start,count){const{_cachedMeta:meta,_data:data}=this,{iScale:iScale,_stacked:_stacked}=meta,iAxis=iScale.axis;let i,cur,parsed,sorted=0===start&&count===data.length||meta._sorted,prev=start>0&&meta._parsed[start-1];if(!1===this._parsing)meta._parsed=data,meta._sorted=!0,parsed=data;else{parsed=isArray(data[start])?this.parseArrayData(meta,data,start,count):isObject(data[start])?this.parseObjectData(meta,data,start,count):this.parsePrimitiveData(meta,data,start,count);const isNotInOrderComparedToPrev=()=>null===cur[iAxis]||prev&&cur[iAxis]<prev[iAxis];for(i=0;i<count;++i)meta._parsed[i+start]=cur=parsed[i],sorted&&(isNotInOrderComparedToPrev()&&(sorted=!1),prev=cur);meta._sorted=sorted}_stacked&&updateStacks(this,parsed)}parsePrimitiveData(meta,data,start,count){const{iScale:iScale,vScale:vScale}=meta,iAxis=iScale.axis,vAxis=vScale.axis,labels=iScale.getLabels(),singleScale=iScale===vScale,parsed=new Array(count);let i,ilen,index;for(i=0,ilen=count;i<ilen;++i)index=i+start,parsed[i]={[iAxis]:singleScale||iScale.parse(labels[index],index),[vAxis]:vScale.parse(data[index],index)};return parsed}parseArrayData(meta,data,start,count){const{xScale:xScale,yScale:yScale}=meta,parsed=new Array(count);let i,ilen,index,item;for(i=0,ilen=count;i<ilen;++i)index=i+start,item=data[index],parsed[i]={x:xScale.parse(item[0],index),y:yScale.parse(item[1],index)};return parsed}parseObjectData(meta,data,start,count){const{xScale:xScale,yScale:yScale}=meta,{xAxisKey:xAxisKey="x",yAxisKey:yAxisKey="y"}=this._parsing,parsed=new Array(count);let i,ilen,index,item;for(i=0,ilen=count;i<ilen;++i)index=i+start,item=data[index],parsed[i]={x:xScale.parse(resolveObjectKey(item,xAxisKey),index),y:yScale.parse(resolveObjectKey(item,yAxisKey),index)};return parsed}getParsed(index){return this._cachedMeta._parsed[index]}getDataElement(index){return this._cachedMeta.data[index]}applyStack(scale,parsed,mode){const chart=this.chart,meta=this._cachedMeta,value=parsed[scale.axis];return applyStack({keys:getSortedDatasetIndices(chart,!0),values:parsed._stacks[scale.axis]._visualValues},value,meta.index,{mode:mode})}updateRangeFromParsed(range,scale,parsed,stack){const parsedValue=parsed[scale.axis];let value=null===parsedValue?NaN:parsedValue;const values=stack&&parsed._stacks[scale.axis];stack&&values&&(stack.values=values,value=applyStack(stack,parsedValue,this._cachedMeta.index)),range.min=Math.min(range.min,value),range.max=Math.max(range.max,value)}getMinMax(scale,canStack){const meta=this._cachedMeta,_parsed=meta._parsed,sorted=meta._sorted&&scale===meta.iScale,ilen=_parsed.length,otherScale=this._getOtherScale(scale),stack=((canStack,meta,chart)=>canStack&&!meta.hidden&&meta._stacked&&{keys:getSortedDatasetIndices(chart,!0),values:null})(canStack,meta,this.chart),range={min:Number.POSITIVE_INFINITY,max:Number.NEGATIVE_INFINITY},{min:otherMin,max:otherMax}=function(scale){const{min:min,max:max,minDefined:minDefined,maxDefined:maxDefined}=scale.getUserBounds();return{min:minDefined?min:Number.NEGATIVE_INFINITY,max:maxDefined?max:Number.POSITIVE_INFINITY}}(otherScale);let i,parsed;function _skip(){parsed=_parsed[i];const otherValue=parsed[otherScale.axis];return!isNumberFinite(parsed[scale.axis])||otherMin>otherValue||otherMax<otherValue}for(i=0;i<ilen&&(_skip()||(this.updateRangeFromParsed(range,scale,parsed,stack),!sorted));++i);if(sorted)for(i=ilen-1;i>=0;--i)if(!_skip()){this.updateRangeFromParsed(range,scale,parsed,stack);break}return range}getAllParsedValues(scale){const parsed=this._cachedMeta._parsed,values=[];let i,ilen,value;for(i=0,ilen=parsed.length;i<ilen;++i)value=parsed[i][scale.axis],isNumberFinite(value)&&values.push(value);return values}getMaxOverflow(){return!1}getLabelAndValue(index){const meta=this._cachedMeta,iScale=meta.iScale,vScale=meta.vScale,parsed=this.getParsed(index);return{label:iScale?""+iScale.getLabelForValue(parsed[iScale.axis]):"",value:vScale?""+vScale.getLabelForValue(parsed[vScale.axis]):""}}_update(mode){const meta=this._cachedMeta;this.update(mode||"default"),meta._clip=function(value){let t,r,b,l;return isObject(value)?(t=value.top,r=value.right,b=value.bottom,l=value.left):t=r=b=l=value,{top:t,right:r,bottom:b,left:l,disabled:!1===value}}(valueOrDefault(this.options.clip,function(xScale,yScale,allowedOverflow){if(!1===allowedOverflow)return!1;const x=scaleClip(xScale,allowedOverflow),y=scaleClip(yScale,allowedOverflow);return{top:y.end,right:x.end,bottom:y.start,left:x.start}}(meta.xScale,meta.yScale,this.getMaxOverflow())))}update(mode){}draw(){const ctx=this._ctx,chart=this.chart,meta=this._cachedMeta,elements=meta.data||[],area=chart.chartArea,active=[],start=this._drawStart||0,count=this._drawCount||elements.length-start,drawActiveElementsOnTop=this.options.drawActiveElementsOnTop;let i;for(meta.dataset&&meta.dataset.draw(ctx,area,start,count),i=start;i<start+count;++i){const element=elements[i];element.hidden||(element.active&&drawActiveElementsOnTop?active.push(element):element.draw(ctx,area))}for(i=0;i<active.length;++i)active[i].draw(ctx,area)}getStyle(index,active){const mode=active?"active":"default";return void 0===index&&this._cachedMeta.dataset?this.resolveDatasetElementOptions(mode):this.resolveDataElementOptions(index||0,mode)}getContext(index,active,mode){const dataset=this.getDataset();let context;if(index>=0&&index<this._cachedMeta.data.length){const element=this._cachedMeta.data[index];context=element.$context||(element.$context=function(parent,index,element){return createContext(parent,{active:!1,dataIndex:index,parsed:void 0,raw:void 0,element:element,index:index,mode:"default",type:"data"})}(this.getContext(),index,element)),context.parsed=this.getParsed(index),context.raw=dataset.data[index],context.index=context.dataIndex=index}else context=this.$context||(this.$context=function(parent,index){return createContext(parent,{active:!1,dataset:void 0,datasetIndex:index,index:index,mode:"default",type:"dataset"})}(this.chart.getContext(),this.index)),context.dataset=dataset,context.index=context.datasetIndex=this.index;return context.active=!!active,context.mode=mode,context}resolveDatasetElementOptions(mode){return this._resolveElementOptions(this.datasetElementType.id,mode)}resolveDataElementOptions(index,mode){return this._resolveElementOptions(this.dataElementType.id,mode,index)}_resolveElementOptions(elementType){let mode=arguments.length>1&&void 0!==arguments[1]?arguments[1]:"default",index=arguments.length>2?arguments[2]:void 0;const active="active"===mode,cache=this._cachedDataOpts,cacheKey=elementType+"-"+mode,cached=cache[cacheKey],sharing=this.enableOptionSharing&&defined(index);if(cached)return cloneIfNotShared(cached,sharing);const config=this.chart.config,scopeKeys=config.datasetElementScopeKeys(this._type,elementType),prefixes=active?["".concat(elementType,"Hover"),"hover",elementType,""]:[elementType,""],scopes=config.getOptionScopes(this.getDataset(),scopeKeys),names=Object.keys(defaults.elements[elementType]),values=config.resolveNamedOptions(scopes,names,(()=>this.getContext(index,active,mode)),prefixes);return values.$shared&&(values.$shared=sharing,cache[cacheKey]=Object.freeze(cloneIfNotShared(values,sharing))),values}_resolveAnimations(index,transition,active){const chart=this.chart,cache=this._cachedDataOpts,cacheKey="animation-".concat(transition),cached=cache[cacheKey];if(cached)return cached;let options;if(!1!==chart.options.animation){const config=this.chart.config,scopeKeys=config.datasetAnimationScopeKeys(this._type,transition),scopes=config.getOptionScopes(this.getDataset(),scopeKeys);options=config.createResolver(scopes,this.getContext(index,active,transition))}const animations=new Animations(chart,options&&options.animations);return options&&options._cacheable&&(cache[cacheKey]=Object.freeze(animations)),animations}getSharedOptions(options){if(options.$shared)return this._sharedOptions||(this._sharedOptions=Object.assign({},options))}includeOptions(mode,sharedOptions){return!sharedOptions||isDirectUpdateMode(mode)||this.chart._animationsDisabled}_getSharedOptions(start,mode){const firstOpts=this.resolveDataElementOptions(start,mode),previouslySharedOptions=this._sharedOptions,sharedOptions=this.getSharedOptions(firstOpts),includeOptions=this.includeOptions(mode,sharedOptions)||sharedOptions!==previouslySharedOptions;return this.updateSharedOptions(sharedOptions,mode,firstOpts),{sharedOptions:sharedOptions,includeOptions:includeOptions}}updateElement(element,index,properties,mode){isDirectUpdateMode(mode)?Object.assign(element,properties):this._resolveAnimations(index,mode).update(element,properties)}updateSharedOptions(sharedOptions,mode,newOptions){sharedOptions&&!isDirectUpdateMode(mode)&&this._resolveAnimations(void 0,mode).update(sharedOptions,newOptions)}_setStyle(element,index,mode,active){element.active=active;const options=this.getStyle(index,active);this._resolveAnimations(index,mode,active).update(element,{options:!active&&this.getSharedOptions(options)||options})}removeHoverStyle(element,datasetIndex,index){this._setStyle(element,index,"active",!1)}setHoverStyle(element,datasetIndex,index){this._setStyle(element,index,"active",!0)}_removeDatasetHoverStyle(){const element=this._cachedMeta.dataset;element&&this._setStyle(element,void 0,"active",!1)}_setDatasetHoverStyle(){const element=this._cachedMeta.dataset;element&&this._setStyle(element,void 0,"active",!0)}_resyncElements(resetNewElements){const data=this._data,elements=this._cachedMeta.data;for(const[method,arg1,arg2]of this._syncList)this[method](arg1,arg2);this._syncList=[];const numMeta=elements.length,numData=data.length,count=Math.min(numData,numMeta);count&&this.parse(0,count),numData>numMeta?this._insertElements(numMeta,numData-numMeta,resetNewElements):numData<numMeta&&this._removeElements(numData,numMeta-numData)}_insertElements(start,count){let resetNewElements=!(arguments.length>2&&void 0!==arguments[2])||arguments[2];const meta=this._cachedMeta,data=meta.data,end=start+count;let i;const move=arr=>{for(arr.length+=count,i=arr.length-1;i>=end;i--)arr[i]=arr[i-count]};for(move(data),i=start;i<end;++i)data[i]=new this.dataElementType;this._parsing&&move(meta._parsed),this.parse(start,count),resetNewElements&&this.updateElements(data,start,count,"reset")}updateElements(element,start,count,mode){}_removeElements(start,count){const meta=this._cachedMeta;if(this._parsing){const removed=meta._parsed.splice(start,count);meta._stacked&&clearStacks(meta,removed)}meta.data.splice(start,count)}_sync(args){if(this._parsing)this._syncList.push(args);else{const[method,arg1,arg2]=args;this[method](arg1,arg2)}this.chart._dataChanges.push([this.index,...args])}_onDataPush(){const count=arguments.length;this._sync(["_insertElements",this.getDataset().data.length-count,count])}_onDataPop(){this._sync(["_removeElements",this._cachedMeta.data.length-1,1])}_onDataShift(){this._sync(["_removeElements",0,1])}_onDataSplice(start,count){count&&this._sync(["_removeElements",start,count]);const newCount=arguments.length-2;newCount&&this._sync(["_insertElements",start,newCount])}_onDataUnshift(){this._sync(["_insertElements",0,arguments.length])}}_defineProperty(DatasetController,"defaults",{}),_defineProperty(DatasetController,"datasetElementType",null),_defineProperty(DatasetController,"dataElementType",null);class Element{constructor(){_defineProperty(this,"x",void 0),_defineProperty(this,"y",void 0),_defineProperty(this,"active",!1),_defineProperty(this,"options",void 0),_defineProperty(this,"$animations",void 0)}tooltipPosition(useFinalPosition){const{x:x,y:y}=this.getProps(["x","y"],useFinalPosition);return{x:x,y:y}}hasValue(){return isNumber(this.x)&&isNumber(this.y)}getProps(props,final){const anims=this.$animations;if(!final||!anims)return this;const ret={};return props.forEach((prop=>{ret[prop]=anims[prop]&&anims[prop].active()?anims[prop]._to:this[prop]})),ret}}function autoSkip(scale,ticks){const tickOpts=scale.options.ticks,determinedMaxTicks=function(scale){const offset=scale.options.offset,tickLength=scale._tickSize(),maxScale=scale._length/tickLength+(offset?0:1),maxChart=scale._maxLength/tickLength;return Math.floor(Math.min(maxScale,maxChart))}(scale),ticksLimit=Math.min(tickOpts.maxTicksLimit||determinedMaxTicks,determinedMaxTicks),majorIndices=tickOpts.major.enabled?function(ticks){const result=[];let i,ilen;for(i=0,ilen=ticks.length;i<ilen;i++)ticks[i].major&&result.push(i);return result}(ticks):[],numMajorIndices=majorIndices.length,first=majorIndices[0],last=majorIndices[numMajorIndices-1],newTicks=[];if(numMajorIndices>ticksLimit)return function(ticks,newTicks,majorIndices,spacing){let i,count=0,next=majorIndices[0];for(spacing=Math.ceil(spacing),i=0;i<ticks.length;i++)i===next&&(newTicks.push(ticks[i]),count++,next=majorIndices[count*spacing])}(ticks,newTicks,majorIndices,numMajorIndices/ticksLimit),newTicks;const spacing=function(majorIndices,ticks,ticksLimit){const evenMajorSpacing=function(arr){const len=arr.length;let i,diff;if(len<2)return!1;for(diff=arr[0],i=1;i<len;++i)if(arr[i]-arr[i-1]!==diff)return!1;return diff}(majorIndices),spacing=ticks.length/ticksLimit;if(!evenMajorSpacing)return Math.max(spacing,1);const factors=_factorize(evenMajorSpacing);for(let i=0,ilen=factors.length-1;i<ilen;i++){const factor=factors[i];if(factor>spacing)return factor}return Math.max(spacing,1)}(majorIndices,ticks,ticksLimit);if(numMajorIndices>0){let i,ilen;const avgMajorSpacing=numMajorIndices>1?Math.round((last-first)/(numMajorIndices-1)):null;for(skip(ticks,newTicks,spacing,isNullOrUndef(avgMajorSpacing)?0:first-avgMajorSpacing,first),i=0,ilen=numMajorIndices-1;i<ilen;i++)skip(ticks,newTicks,spacing,majorIndices[i],majorIndices[i+1]);return skip(ticks,newTicks,spacing,last,isNullOrUndef(avgMajorSpacing)?ticks.length:last+avgMajorSpacing),newTicks}return skip(ticks,newTicks,spacing),newTicks}function skip(ticks,newTicks,spacing,majorStart,majorEnd){const start=valueOrDefault(majorStart,0),end=Math.min(valueOrDefault(majorEnd,ticks.length),ticks.length);let length,i,next,count=0;for(spacing=Math.ceil(spacing),majorEnd&&(length=majorEnd-majorStart,spacing=length/Math.floor(length/spacing)),next=start;next<0;)count++,next=Math.round(start+count*spacing);for(i=Math.max(start,0);i<end;i++)i===next&&(newTicks.push(ticks[i]),count++,next=Math.round(start+count*spacing))}_defineProperty(Element,"defaults",{}),_defineProperty(Element,"defaultRoutes",void 0);const offsetFromEdge=(scale,edge,offset)=>"top"===edge||"left"===edge?scale[edge]+offset:scale[edge]-offset,getTicksLimit=(ticksLength,maxTicksLimit)=>Math.min(maxTicksLimit||ticksLength,ticksLength);function sample(arr,numItems){const result=[],increment=arr.length/numItems,len=arr.length;let i=0;for(;i<len;i+=increment)result.push(arr[Math.floor(i)]);return result}function getPixelForGridLine(scale,index,offsetGridLines){const length=scale.ticks.length,validIndex=Math.min(index,length-1),start=scale._startPixel,end=scale._endPixel;let offset,lineValue=scale.getPixelForTick(validIndex);if(!(offsetGridLines&&(offset=1===length?Math.max(lineValue-start,end-lineValue):0===index?(scale.getPixelForTick(1)-lineValue)/2:(lineValue-scale.getPixelForTick(validIndex-1))/2,lineValue+=validIndex<index?offset:-offset,lineValue<start-1e-6||lineValue>end+1e-6)))return lineValue}function getTickMarkLength(options){return options.drawTicks?options.tickLength:0}function getTitleHeight(options,fallback){if(!options.display)return 0;const font=toFont(options.font,fallback),padding=toPadding(options.padding);return(isArray(options.text)?options.text.length:1)*font.lineHeight+padding.height}function titleAlign(align,position,reverse){let ret=_toLeftRightCenter(align);return(reverse&&"right"!==position||!reverse&&"right"===position)&&(ret=(align=>"left"===align?"right":"right"===align?"left":align)(ret)),ret}class Scale extends Element{constructor(cfg){super(),this.id=cfg.id,this.type=cfg.type,this.options=void 0,this.ctx=cfg.ctx,this.chart=cfg.chart,this.top=void 0,this.bottom=void 0,this.left=void 0,this.right=void 0,this.width=void 0,this.height=void 0,this._margins={left:0,right:0,top:0,bottom:0},this.maxWidth=void 0,this.maxHeight=void 0,this.paddingTop=void 0,this.paddingBottom=void 0,this.paddingLeft=void 0,this.paddingRight=void 0,this.axis=void 0,this.labelRotation=void 0,this.min=void 0,this.max=void 0,this._range=void 0,this.ticks=[],this._gridLineItems=null,this._labelItems=null,this._labelSizes=null,this._length=0,this._maxLength=0,this._longestTextCache={},this._startPixel=void 0,this._endPixel=void 0,this._reversePixels=!1,this._userMax=void 0,this._userMin=void 0,this._suggestedMax=void 0,this._suggestedMin=void 0,this._ticksLength=0,this._borderValue=0,this._cache={},this._dataLimitsCached=!1,this.$context=void 0}init(options){this.options=options.setContext(this.getContext()),this.axis=options.axis,this._userMin=this.parse(options.min),this._userMax=this.parse(options.max),this._suggestedMin=this.parse(options.suggestedMin),this._suggestedMax=this.parse(options.suggestedMax)}parse(raw,index){return raw}getUserBounds(){let{_userMin:_userMin,_userMax:_userMax,_suggestedMin:_suggestedMin,_suggestedMax:_suggestedMax}=this;return _userMin=finiteOrDefault(_userMin,Number.POSITIVE_INFINITY),_userMax=finiteOrDefault(_userMax,Number.NEGATIVE_INFINITY),_suggestedMin=finiteOrDefault(_suggestedMin,Number.POSITIVE_INFINITY),_suggestedMax=finiteOrDefault(_suggestedMax,Number.NEGATIVE_INFINITY),{min:finiteOrDefault(_userMin,_suggestedMin),max:finiteOrDefault(_userMax,_suggestedMax),minDefined:isNumberFinite(_userMin),maxDefined:isNumberFinite(_userMax)}}getMinMax(canStack){let range,{min:min,max:max,minDefined:minDefined,maxDefined:maxDefined}=this.getUserBounds();if(minDefined&&maxDefined)return{min:min,max:max};const metas=this.getMatchingVisibleMetas();for(let i=0,ilen=metas.length;i<ilen;++i)range=metas[i].controller.getMinMax(this,canStack),minDefined||(min=Math.min(min,range.min)),maxDefined||(max=Math.max(max,range.max));return min=maxDefined&&min>max?max:min,max=minDefined&&min>max?min:max,{min:finiteOrDefault(min,finiteOrDefault(max,min)),max:finiteOrDefault(max,finiteOrDefault(min,max))}}getPadding(){return{left:this.paddingLeft||0,top:this.paddingTop||0,right:this.paddingRight||0,bottom:this.paddingBottom||0}}getTicks(){return this.ticks}getLabels(){const data=this.chart.data;return this.options.labels||(this.isHorizontal()?data.xLabels:data.yLabels)||data.labels||[]}getLabelItems(){let chartArea=arguments.length>0&&void 0!==arguments[0]?arguments[0]:this.chart.chartArea;return this._labelItems||(this._labelItems=this._computeLabelItems(chartArea))}beforeLayout(){this._cache={},this._dataLimitsCached=!1}beforeUpdate(){callback(this.options.beforeUpdate,[this])}update(maxWidth,maxHeight,margins){const{beginAtZero:beginAtZero,grace:grace,ticks:tickOpts}=this.options,sampleSize=tickOpts.sampleSize;this.beforeUpdate(),this.maxWidth=maxWidth,this.maxHeight=maxHeight,this._margins=margins=Object.assign({left:0,right:0,top:0,bottom:0},margins),this.ticks=null,this._labelSizes=null,this._gridLineItems=null,this._labelItems=null,this.beforeSetDimensions(),this.setDimensions(),this.afterSetDimensions(),this._maxLength=this.isHorizontal()?this.width+margins.left+margins.right:this.height+margins.top+margins.bottom,this._dataLimitsCached||(this.beforeDataLimits(),this.determineDataLimits(),this.afterDataLimits(),this._range=_addGrace(this,grace,beginAtZero),this._dataLimitsCached=!0),this.beforeBuildTicks(),this.ticks=this.buildTicks()||[],this.afterBuildTicks();const samplingEnabled=sampleSize<this.ticks.length;this._convertTicksToLabels(samplingEnabled?sample(this.ticks,sampleSize):this.ticks),this.configure(),this.beforeCalculateLabelRotation(),this.calculateLabelRotation(),this.afterCalculateLabelRotation(),tickOpts.display&&(tickOpts.autoSkip||"auto"===tickOpts.source)&&(this.ticks=autoSkip(this,this.ticks),this._labelSizes=null,this.afterAutoSkip()),samplingEnabled&&this._convertTicksToLabels(this.ticks),this.beforeFit(),this.fit(),this.afterFit(),this.afterUpdate()}configure(){let startPixel,endPixel,reversePixels=this.options.reverse;this.isHorizontal()?(startPixel=this.left,endPixel=this.right):(startPixel=this.top,endPixel=this.bottom,reversePixels=!reversePixels),this._startPixel=startPixel,this._endPixel=endPixel,this._reversePixels=reversePixels,this._length=endPixel-startPixel,this._alignToPixels=this.options.alignToPixels}afterUpdate(){callback(this.options.afterUpdate,[this])}beforeSetDimensions(){callback(this.options.beforeSetDimensions,[this])}setDimensions(){this.isHorizontal()?(this.width=this.maxWidth,this.left=0,this.right=this.width):(this.height=this.maxHeight,this.top=0,this.bottom=this.height),this.paddingLeft=0,this.paddingTop=0,this.paddingRight=0,this.paddingBottom=0}afterSetDimensions(){callback(this.options.afterSetDimensions,[this])}_callHooks(name){this.chart.notifyPlugins(name,this.getContext()),callback(this.options[name],[this])}beforeDataLimits(){this._callHooks("beforeDataLimits")}determineDataLimits(){}afterDataLimits(){this._callHooks("afterDataLimits")}beforeBuildTicks(){this._callHooks("beforeBuildTicks")}buildTicks(){return[]}afterBuildTicks(){this._callHooks("afterBuildTicks")}beforeTickToLabelConversion(){callback(this.options.beforeTickToLabelConversion,[this])}generateTickLabels(ticks){const tickOpts=this.options.ticks;let i,ilen,tick;for(i=0,ilen=ticks.length;i<ilen;i++)tick=ticks[i],tick.label=callback(tickOpts.callback,[tick.value,i,ticks],this)}afterTickToLabelConversion(){callback(this.options.afterTickToLabelConversion,[this])}beforeCalculateLabelRotation(){callback(this.options.beforeCalculateLabelRotation,[this])}calculateLabelRotation(){const options=this.options,tickOpts=options.ticks,numTicks=getTicksLimit(this.ticks.length,options.ticks.maxTicksLimit),minRotation=tickOpts.minRotation||0,maxRotation=tickOpts.maxRotation;let tickWidth,maxHeight,maxLabelDiagonal,labelRotation=minRotation;if(!this._isVisible()||!tickOpts.display||minRotation>=maxRotation||numTicks<=1||!this.isHorizontal())return void(this.labelRotation=minRotation);const labelSizes=this._getLabelSizes(),maxLabelWidth=labelSizes.widest.width,maxLabelHeight=labelSizes.highest.height,maxWidth=_limitValue(this.chart.width-maxLabelWidth,0,this.maxWidth);tickWidth=options.offset?this.maxWidth/numTicks:maxWidth/(numTicks-1),maxLabelWidth+6>tickWidth&&(tickWidth=maxWidth/(numTicks-(options.offset?.5:1)),maxHeight=this.maxHeight-getTickMarkLength(options.grid)-tickOpts.padding-getTitleHeight(options.title,this.chart.options.font),maxLabelDiagonal=Math.sqrt(maxLabelWidth*maxLabelWidth+maxLabelHeight*maxLabelHeight),labelRotation=toDegrees(Math.min(Math.asin(_limitValue((labelSizes.highest.height+6)/tickWidth,-1,1)),Math.asin(_limitValue(maxHeight/maxLabelDiagonal,-1,1))-Math.asin(_limitValue(maxLabelHeight/maxLabelDiagonal,-1,1)))),labelRotation=Math.max(minRotation,Math.min(maxRotation,labelRotation))),this.labelRotation=labelRotation}afterCalculateLabelRotation(){callback(this.options.afterCalculateLabelRotation,[this])}afterAutoSkip(){}beforeFit(){callback(this.options.beforeFit,[this])}fit(){const minSize={width:0,height:0},{chart:chart,options:{ticks:tickOpts,title:titleOpts,grid:gridOpts}}=this,display=this._isVisible(),isHorizontal=this.isHorizontal();if(display){const titleHeight=getTitleHeight(titleOpts,chart.options.font);if(isHorizontal?(minSize.width=this.maxWidth,minSize.height=getTickMarkLength(gridOpts)+titleHeight):(minSize.height=this.maxHeight,minSize.width=getTickMarkLength(gridOpts)+titleHeight),tickOpts.display&&this.ticks.length){const{first:first,last:last,widest:widest,highest:highest}=this._getLabelSizes(),tickPadding=2*tickOpts.padding,angleRadians=toRadians(this.labelRotation),cos=Math.cos(angleRadians),sin=Math.sin(angleRadians);if(isHorizontal){const labelHeight=tickOpts.mirror?0:sin*widest.width+cos*highest.height;minSize.height=Math.min(this.maxHeight,minSize.height+labelHeight+tickPadding)}else{const labelWidth=tickOpts.mirror?0:cos*widest.width+sin*highest.height;minSize.width=Math.min(this.maxWidth,minSize.width+labelWidth+tickPadding)}this._calculatePadding(first,last,sin,cos)}}this._handleMargins(),isHorizontal?(this.width=this._length=chart.width-this._margins.left-this._margins.right,this.height=minSize.height):(this.width=minSize.width,this.height=this._length=chart.height-this._margins.top-this._margins.bottom)}_calculatePadding(first,last,sin,cos){const{ticks:{align:align,padding:padding},position:position}=this.options,isRotated=0!==this.labelRotation,labelsBelowTicks="top"!==position&&"x"===this.axis;if(this.isHorizontal()){const offsetLeft=this.getPixelForTick(0)-this.left,offsetRight=this.right-this.getPixelForTick(this.ticks.length-1);let paddingLeft=0,paddingRight=0;isRotated?labelsBelowTicks?(paddingLeft=cos*first.width,paddingRight=sin*last.height):(paddingLeft=sin*first.height,paddingRight=cos*last.width):"start"===align?paddingRight=last.width:"end"===align?paddingLeft=first.width:"inner"!==align&&(paddingLeft=first.width/2,paddingRight=last.width/2),this.paddingLeft=Math.max((paddingLeft-offsetLeft+padding)*this.width/(this.width-offsetLeft),0),this.paddingRight=Math.max((paddingRight-offsetRight+padding)*this.width/(this.width-offsetRight),0)}else{let paddingTop=last.height/2,paddingBottom=first.height/2;"start"===align?(paddingTop=0,paddingBottom=first.height):"end"===align&&(paddingTop=last.height,paddingBottom=0),this.paddingTop=paddingTop+padding,this.paddingBottom=paddingBottom+padding}}_handleMargins(){this._margins&&(this._margins.left=Math.max(this.paddingLeft,this._margins.left),this._margins.top=Math.max(this.paddingTop,this._margins.top),this._margins.right=Math.max(this.paddingRight,this._margins.right),this._margins.bottom=Math.max(this.paddingBottom,this._margins.bottom))}afterFit(){callback(this.options.afterFit,[this])}isHorizontal(){const{axis:axis,position:position}=this.options;return"top"===position||"bottom"===position||"x"===axis}isFullSize(){return this.options.fullSize}_convertTicksToLabels(ticks){let i,ilen;for(this.beforeTickToLabelConversion(),this.generateTickLabels(ticks),i=0,ilen=ticks.length;i<ilen;i++)isNullOrUndef(ticks[i].label)&&(ticks.splice(i,1),ilen--,i--);this.afterTickToLabelConversion()}_getLabelSizes(){let labelSizes=this._labelSizes;if(!labelSizes){const sampleSize=this.options.ticks.sampleSize;let ticks=this.ticks;sampleSize<ticks.length&&(ticks=sample(ticks,sampleSize)),this._labelSizes=labelSizes=this._computeLabelSizes(ticks,ticks.length,this.options.ticks.maxTicksLimit)}return labelSizes}_computeLabelSizes(ticks,length,maxTicksLimit){const{ctx:ctx,_longestTextCache:caches}=this,widths=[],heights=[],increment=Math.floor(length/getTicksLimit(length,maxTicksLimit));let i,j,jlen,label,tickFont,fontString,cache,lineHeight,width,height,nestedLabel,widestLabelSize=0,highestLabelSize=0;for(i=0;i<length;i+=increment){if(label=ticks[i].label,tickFont=this._resolveTickFontOptions(i),ctx.font=fontString=tickFont.string,cache=caches[fontString]=caches[fontString]||{data:{},gc:[]},lineHeight=tickFont.lineHeight,width=height=0,isNullOrUndef(label)||isArray(label)){if(isArray(label))for(j=0,jlen=label.length;j<jlen;++j)nestedLabel=label[j],isNullOrUndef(nestedLabel)||isArray(nestedLabel)||(width=_measureText(ctx,cache.data,cache.gc,width,nestedLabel),height+=lineHeight)}else width=_measureText(ctx,cache.data,cache.gc,width,label),height=lineHeight;widths.push(width),heights.push(height),widestLabelSize=Math.max(width,widestLabelSize),highestLabelSize=Math.max(height,highestLabelSize)}!function(caches,length){each(caches,(cache=>{const gc=cache.gc,gcLen=gc.length/2;let i;if(gcLen>length){for(i=0;i<gcLen;++i)delete cache.data[gc[i]];gc.splice(0,gcLen)}}))}(caches,length);const widest=widths.indexOf(widestLabelSize),highest=heights.indexOf(highestLabelSize),valueAt=idx=>({width:widths[idx]||0,height:heights[idx]||0});return{first:valueAt(0),last:valueAt(length-1),widest:valueAt(widest),highest:valueAt(highest),widths:widths,heights:heights}}getLabelForValue(value){return value}getPixelForValue(value,index){return NaN}getValueForPixel(pixel){}getPixelForTick(index){const ticks=this.ticks;return index<0||index>ticks.length-1?null:this.getPixelForValue(ticks[index].value)}getPixelForDecimal(decimal){this._reversePixels&&(decimal=1-decimal);const pixel=this._startPixel+decimal*this._length;return _int16Range(this._alignToPixels?_alignPixel(this.chart,pixel,0):pixel)}getDecimalForPixel(pixel){const decimal=(pixel-this._startPixel)/this._length;return this._reversePixels?1-decimal:decimal}getBasePixel(){return this.getPixelForValue(this.getBaseValue())}getBaseValue(){const{min:min,max:max}=this;return min<0&&max<0?max:min>0&&max>0?min:0}getContext(index){const ticks=this.ticks||[];if(index>=0&&index<ticks.length){const tick=ticks[index];return tick.$context||(tick.$context=function(parent,index,tick){return createContext(parent,{tick:tick,index:index,type:"tick"})}(this.getContext(),index,tick))}return this.$context||(this.$context=createContext(this.chart.getContext(),{scale:this,type:"scale"}))}_tickSize(){const optionTicks=this.options.ticks,rot=toRadians(this.labelRotation),cos=Math.abs(Math.cos(rot)),sin=Math.abs(Math.sin(rot)),labelSizes=this._getLabelSizes(),padding=optionTicks.autoSkipPadding||0,w=labelSizes?labelSizes.widest.width+padding:0,h=labelSizes?labelSizes.highest.height+padding:0;return this.isHorizontal()?h*cos>w*sin?w/cos:h/sin:h*sin<w*cos?h/cos:w/sin}_isVisible(){const display=this.options.display;return"auto"!==display?!!display:this.getMatchingVisibleMetas().length>0}_computeGridLineItems(chartArea){const axis=this.axis,chart=this.chart,options=this.options,{grid:grid,position:position,border:border}=options,offset=grid.offset,isHorizontal=this.isHorizontal(),ticksLength=this.ticks.length+(offset?1:0),tl=getTickMarkLength(grid),items=[],borderOpts=border.setContext(this.getContext()),axisWidth=borderOpts.display?borderOpts.width:0,axisHalfWidth=axisWidth/2,alignBorderValue=function(pixel){return _alignPixel(chart,pixel,axisWidth)};let borderValue,i,lineValue,alignedLineValue,tx1,ty1,tx2,ty2,x1,y1,x2,y2;if("top"===position)borderValue=alignBorderValue(this.bottom),ty1=this.bottom-tl,ty2=borderValue-axisHalfWidth,y1=alignBorderValue(chartArea.top)+axisHalfWidth,y2=chartArea.bottom;else if("bottom"===position)borderValue=alignBorderValue(this.top),y1=chartArea.top,y2=alignBorderValue(chartArea.bottom)-axisHalfWidth,ty1=borderValue+axisHalfWidth,ty2=this.top+tl;else if("left"===position)borderValue=alignBorderValue(this.right),tx1=this.right-tl,tx2=borderValue-axisHalfWidth,x1=alignBorderValue(chartArea.left)+axisHalfWidth,x2=chartArea.right;else if("right"===position)borderValue=alignBorderValue(this.left),x1=chartArea.left,x2=alignBorderValue(chartArea.right)-axisHalfWidth,tx1=borderValue+axisHalfWidth,tx2=this.left+tl;else if("x"===axis){if("center"===position)borderValue=alignBorderValue((chartArea.top+chartArea.bottom)/2+.5);else if(isObject(position)){const positionAxisID=Object.keys(position)[0],value=position[positionAxisID];borderValue=alignBorderValue(this.chart.scales[positionAxisID].getPixelForValue(value))}y1=chartArea.top,y2=chartArea.bottom,ty1=borderValue+axisHalfWidth,ty2=ty1+tl}else if("y"===axis){if("center"===position)borderValue=alignBorderValue((chartArea.left+chartArea.right)/2);else if(isObject(position)){const positionAxisID=Object.keys(position)[0],value=position[positionAxisID];borderValue=alignBorderValue(this.chart.scales[positionAxisID].getPixelForValue(value))}tx1=borderValue-axisHalfWidth,tx2=tx1-tl,x1=chartArea.left,x2=chartArea.right}const limit=valueOrDefault(options.ticks.maxTicksLimit,ticksLength),step=Math.max(1,Math.ceil(ticksLength/limit));for(i=0;i<ticksLength;i+=step){const context=this.getContext(i),optsAtIndex=grid.setContext(context),optsAtIndexBorder=border.setContext(context),lineWidth=optsAtIndex.lineWidth,lineColor=optsAtIndex.color,borderDash=optsAtIndexBorder.dash||[],borderDashOffset=optsAtIndexBorder.dashOffset,tickWidth=optsAtIndex.tickWidth,tickColor=optsAtIndex.tickColor,tickBorderDash=optsAtIndex.tickBorderDash||[],tickBorderDashOffset=optsAtIndex.tickBorderDashOffset;lineValue=getPixelForGridLine(this,i,offset),void 0!==lineValue&&(alignedLineValue=_alignPixel(chart,lineValue,lineWidth),isHorizontal?tx1=tx2=x1=x2=alignedLineValue:ty1=ty2=y1=y2=alignedLineValue,items.push({tx1:tx1,ty1:ty1,tx2:tx2,ty2:ty2,x1:x1,y1:y1,x2:x2,y2:y2,width:lineWidth,color:lineColor,borderDash:borderDash,borderDashOffset:borderDashOffset,tickWidth:tickWidth,tickColor:tickColor,tickBorderDash:tickBorderDash,tickBorderDashOffset:tickBorderDashOffset}))}return this._ticksLength=ticksLength,this._borderValue=borderValue,items}_computeLabelItems(chartArea){const axis=this.axis,options=this.options,{position:position,ticks:optionTicks}=options,isHorizontal=this.isHorizontal(),ticks=this.ticks,{align:align,crossAlign:crossAlign,padding:padding,mirror:mirror}=optionTicks,tl=getTickMarkLength(options.grid),tickAndPadding=tl+padding,hTickAndPadding=mirror?-padding:tickAndPadding,rotation=-toRadians(this.labelRotation),items=[];let i,ilen,tick,label,x,y,textAlign,pixel,font,lineHeight,lineCount,textOffset,textBaseline="middle";if("top"===position)y=this.bottom-hTickAndPadding,textAlign=this._getXAxisLabelAlignment();else if("bottom"===position)y=this.top+hTickAndPadding,textAlign=this._getXAxisLabelAlignment();else if("left"===position){const ret=this._getYAxisLabelAlignment(tl);textAlign=ret.textAlign,x=ret.x}else if("right"===position){const ret=this._getYAxisLabelAlignment(tl);textAlign=ret.textAlign,x=ret.x}else if("x"===axis){if("center"===position)y=(chartArea.top+chartArea.bottom)/2+tickAndPadding;else if(isObject(position)){const positionAxisID=Object.keys(position)[0],value=position[positionAxisID];y=this.chart.scales[positionAxisID].getPixelForValue(value)+tickAndPadding}textAlign=this._getXAxisLabelAlignment()}else if("y"===axis){if("center"===position)x=(chartArea.left+chartArea.right)/2-tickAndPadding;else if(isObject(position)){const positionAxisID=Object.keys(position)[0],value=position[positionAxisID];x=this.chart.scales[positionAxisID].getPixelForValue(value)}textAlign=this._getYAxisLabelAlignment(tl).textAlign}"y"===axis&&("start"===align?textBaseline="top":"end"===align&&(textBaseline="bottom"));const labelSizes=this._getLabelSizes();for(i=0,ilen=ticks.length;i<ilen;++i){tick=ticks[i],label=tick.label;const optsAtIndex=optionTicks.setContext(this.getContext(i));pixel=this.getPixelForTick(i)+optionTicks.labelOffset,font=this._resolveTickFontOptions(i),lineHeight=font.lineHeight,lineCount=isArray(label)?label.length:1;const halfCount=lineCount/2,color=optsAtIndex.color,strokeColor=optsAtIndex.textStrokeColor,strokeWidth=optsAtIndex.textStrokeWidth;let backdrop,tickTextAlign=textAlign;if(isHorizontal?(x=pixel,"inner"===textAlign&&(tickTextAlign=i===ilen-1?this.options.reverse?"left":"right":0===i?this.options.reverse?"right":"left":"center"),textOffset="top"===position?"near"===crossAlign||0!==rotation?-lineCount*lineHeight+lineHeight/2:"center"===crossAlign?-labelSizes.highest.height/2-halfCount*lineHeight+lineHeight:-labelSizes.highest.height+lineHeight/2:"near"===crossAlign||0!==rotation?lineHeight/2:"center"===crossAlign?labelSizes.highest.height/2-halfCount*lineHeight:labelSizes.highest.height-lineCount*lineHeight,mirror&&(textOffset*=-1),0===rotation||optsAtIndex.showLabelBackdrop||(x+=lineHeight/2*Math.sin(rotation))):(y=pixel,textOffset=(1-lineCount)*lineHeight/2),optsAtIndex.showLabelBackdrop){const labelPadding=toPadding(optsAtIndex.backdropPadding),height=labelSizes.heights[i],width=labelSizes.widths[i];let top=textOffset-labelPadding.top,left=0-labelPadding.left;switch(textBaseline){case"middle":top-=height/2;break;case"bottom":top-=height}switch(textAlign){case"center":left-=width/2;break;case"right":left-=width;break;case"inner":i===ilen-1?left-=width:i>0&&(left-=width/2)}backdrop={left:left,top:top,width:width+labelPadding.width,height:height+labelPadding.height,color:optsAtIndex.backdropColor}}items.push({label:label,font:font,textOffset:textOffset,options:{rotation:rotation,color:color,strokeColor:strokeColor,strokeWidth:strokeWidth,textAlign:tickTextAlign,textBaseline:textBaseline,translation:[x,y],backdrop:backdrop}})}return items}_getXAxisLabelAlignment(){const{position:position,ticks:ticks}=this.options;if(-toRadians(this.labelRotation))return"top"===position?"left":"right";let align="center";return"start"===ticks.align?align="left":"end"===ticks.align?align="right":"inner"===ticks.align&&(align="inner"),align}_getYAxisLabelAlignment(tl){const{position:position,ticks:{crossAlign:crossAlign,mirror:mirror,padding:padding}}=this.options,tickAndPadding=tl+padding,widest=this._getLabelSizes().widest.width;let textAlign,x;return"left"===position?mirror?(x=this.right+padding,"near"===crossAlign?textAlign="left":"center"===crossAlign?(textAlign="center",x+=widest/2):(textAlign="right",x+=widest)):(x=this.right-tickAndPadding,"near"===crossAlign?textAlign="right":"center"===crossAlign?(textAlign="center",x-=widest/2):(textAlign="left",x=this.left)):"right"===position?mirror?(x=this.left+padding,"near"===crossAlign?textAlign="right":"center"===crossAlign?(textAlign="center",x-=widest/2):(textAlign="left",x-=widest)):(x=this.left+tickAndPadding,"near"===crossAlign?textAlign="left":"center"===crossAlign?(textAlign="center",x+=widest/2):(textAlign="right",x=this.right)):textAlign="right",{textAlign:textAlign,x:x}}_computeLabelArea(){if(this.options.ticks.mirror)return;const chart=this.chart,position=this.options.position;return"left"===position||"right"===position?{top:0,left:this.left,bottom:chart.height,right:this.right}:"top"===position||"bottom"===position?{top:this.top,left:0,bottom:this.bottom,right:chart.width}:void 0}drawBackground(){const{ctx:ctx,options:{backgroundColor:backgroundColor},left:left,top:top,width:width,height:height}=this;backgroundColor&&(ctx.save(),ctx.fillStyle=backgroundColor,ctx.fillRect(left,top,width,height),ctx.restore())}getLineWidthForValue(value){const grid=this.options.grid;if(!this._isVisible()||!grid.display)return 0;const index=this.ticks.findIndex((t=>t.value===value));return index>=0?grid.setContext(this.getContext(index)).lineWidth:0}drawGrid(chartArea){const grid=this.options.grid,ctx=this.ctx,items=this._gridLineItems||(this._gridLineItems=this._computeGridLineItems(chartArea));let i,ilen;const drawLine=(p1,p2,style)=>{style.width&&style.color&&(ctx.save(),ctx.lineWidth=style.width,ctx.strokeStyle=style.color,ctx.setLineDash(style.borderDash||[]),ctx.lineDashOffset=style.borderDashOffset,ctx.beginPath(),ctx.moveTo(p1.x,p1.y),ctx.lineTo(p2.x,p2.y),ctx.stroke(),ctx.restore())};if(grid.display)for(i=0,ilen=items.length;i<ilen;++i){const item=items[i];grid.drawOnChartArea&&drawLine({x:item.x1,y:item.y1},{x:item.x2,y:item.y2},item),grid.drawTicks&&drawLine({x:item.tx1,y:item.ty1},{x:item.tx2,y:item.ty2},{color:item.tickColor,width:item.tickWidth,borderDash:item.tickBorderDash,borderDashOffset:item.tickBorderDashOffset})}}drawBorder(){const{chart:chart,ctx:ctx,options:{border:border,grid:grid}}=this,borderOpts=border.setContext(this.getContext()),axisWidth=border.display?borderOpts.width:0;if(!axisWidth)return;const lastLineWidth=grid.setContext(this.getContext(0)).lineWidth,borderValue=this._borderValue;let x1,x2,y1,y2;this.isHorizontal()?(x1=_alignPixel(chart,this.left,axisWidth)-axisWidth/2,x2=_alignPixel(chart,this.right,lastLineWidth)+lastLineWidth/2,y1=y2=borderValue):(y1=_alignPixel(chart,this.top,axisWidth)-axisWidth/2,y2=_alignPixel(chart,this.bottom,lastLineWidth)+lastLineWidth/2,x1=x2=borderValue),ctx.save(),ctx.lineWidth=borderOpts.width,ctx.strokeStyle=borderOpts.color,ctx.beginPath(),ctx.moveTo(x1,y1),ctx.lineTo(x2,y2),ctx.stroke(),ctx.restore()}drawLabels(chartArea){if(!this.options.ticks.display)return;const ctx=this.ctx,area=this._computeLabelArea();area&&clipArea(ctx,area);const items=this.getLabelItems(chartArea);for(const item of items){const renderTextOptions=item.options,tickFont=item.font;renderText(ctx,item.label,0,item.textOffset,tickFont,renderTextOptions)}area&&unclipArea(ctx)}drawTitle(){const{ctx:ctx,options:{position:position,title:title,reverse:reverse}}=this;if(!title.display)return;const font=toFont(title.font),padding=toPadding(title.padding),align=title.align;let offset=font.lineHeight/2;"bottom"===position||"center"===position||isObject(position)?(offset+=padding.bottom,isArray(title.text)&&(offset+=font.lineHeight*(title.text.length-1))):offset+=padding.top;const{titleX:titleX,titleY:titleY,maxWidth:maxWidth,rotation:rotation}=function(scale,offset,position,align){const{top:top,left:left,bottom:bottom,right:right,chart:chart}=scale,{chartArea:chartArea,scales:scales}=chart;let maxWidth,titleX,titleY,rotation=0;const height=bottom-top,width=right-left;if(scale.isHorizontal()){if(titleX=_alignStartEnd(align,left,right),isObject(position)){const positionAxisID=Object.keys(position)[0],value=position[positionAxisID];titleY=scales[positionAxisID].getPixelForValue(value)+height-offset}else titleY="center"===position?(chartArea.bottom+chartArea.top)/2+height-offset:offsetFromEdge(scale,position,offset);maxWidth=right-left}else{if(isObject(position)){const positionAxisID=Object.keys(position)[0],value=position[positionAxisID];titleX=scales[positionAxisID].getPixelForValue(value)-width+offset}else titleX="center"===position?(chartArea.left+chartArea.right)/2-width+offset:offsetFromEdge(scale,position,offset);titleY=_alignStartEnd(align,bottom,top),rotation="left"===position?-HALF_PI:HALF_PI}return{titleX:titleX,titleY:titleY,maxWidth:maxWidth,rotation:rotation}}(this,offset,position,align);renderText(ctx,title.text,0,0,font,{color:title.color,maxWidth:maxWidth,rotation:rotation,textAlign:titleAlign(align,position,reverse),textBaseline:"middle",translation:[titleX,titleY]})}draw(chartArea){this._isVisible()&&(this.drawBackground(),this.drawGrid(chartArea),this.drawBorder(),this.drawTitle(),this.drawLabels(chartArea))}_layers(){const opts=this.options,tz=opts.ticks&&opts.ticks.z||0,gz=valueOrDefault(opts.grid&&opts.grid.z,-1),bz=valueOrDefault(opts.border&&opts.border.z,0);return this._isVisible()&&this.draw===Scale.prototype.draw?[{z:gz,draw:chartArea=>{this.drawBackground(),this.drawGrid(chartArea),this.drawTitle()}},{z:bz,draw:()=>{this.drawBorder()}},{z:tz,draw:chartArea=>{this.drawLabels(chartArea)}}]:[{z:tz,draw:chartArea=>{this.draw(chartArea)}}]}getMatchingVisibleMetas(type){const metas=this.chart.getSortedVisibleDatasetMetas(),axisID=this.axis+"AxisID",result=[];let i,ilen;for(i=0,ilen=metas.length;i<ilen;++i){const meta=metas[i];meta[axisID]!==this.id||type&&meta.type!==type||result.push(meta)}return result}_resolveTickFontOptions(index){return toFont(this.options.ticks.setContext(this.getContext(index)).font)}_maxDigits(){const fontSize=this._resolveTickFontOptions(0).lineHeight;return(this.isHorizontal()?this.width:this.height)/fontSize}}class TypedRegistry{constructor(type,scope,override){this.type=type,this.scope=scope,this.override=override,this.items=Object.create(null)}isForType(type){return Object.prototype.isPrototypeOf.call(this.type.prototype,type.prototype)}register(item){const proto=Object.getPrototypeOf(item);let parentScope;(function(proto){return"id"in proto&&"defaults"in proto})(proto)&&(parentScope=this.register(proto));const items=this.items,id=item.id,scope=this.scope+"."+id;if(!id)throw new Error("class does not have id: "+item);return id in items||(items[id]=item,function(item,scope,parentScope){const itemDefaults=merge(Object.create(null),[parentScope?defaults.get(parentScope):{},defaults.get(scope),item.defaults]);defaults.set(scope,itemDefaults),item.defaultRoutes&&function(scope,routes){Object.keys(routes).forEach((property=>{const propertyParts=property.split("."),sourceName=propertyParts.pop(),sourceScope=[scope].concat(propertyParts).join("."),parts=routes[property].split("."),targetName=parts.pop(),targetScope=parts.join(".");defaults.route(sourceScope,sourceName,targetScope,targetName)}))}(scope,item.defaultRoutes),item.descriptors&&defaults.describe(scope,item.descriptors)}(item,scope,parentScope),this.override&&defaults.override(item.id,item.overrides)),scope}get(id){return this.items[id]}unregister(item){const items=this.items,id=item.id,scope=this.scope;id in items&&delete items[id],scope&&id in defaults[scope]&&(delete defaults[scope][id],this.override&&delete overrides[id])}}var registry=new class{constructor(){this.controllers=new TypedRegistry(DatasetController,"datasets",!0),this.elements=new TypedRegistry(Element,"elements"),this.plugins=new TypedRegistry(Object,"plugins"),this.scales=new TypedRegistry(Scale,"scales"),this._typedRegistries=[this.controllers,this.scales,this.elements]}add(){for(var _len4=arguments.length,args=new Array(_len4),_key4=0;_key4<_len4;_key4++)args[_key4]=arguments[_key4];this._each("register",args)}remove(){for(var _len5=arguments.length,args=new Array(_len5),_key5=0;_key5<_len5;_key5++)args[_key5]=arguments[_key5];this._each("unregister",args)}addControllers(){for(var _len6=arguments.length,args=new Array(_len6),_key6=0;_key6<_len6;_key6++)args[_key6]=arguments[_key6];this._each("register",args,this.controllers)}addElements(){for(var _len7=arguments.length,args=new Array(_len7),_key7=0;_key7<_len7;_key7++)args[_key7]=arguments[_key7];this._each("register",args,this.elements)}addPlugins(){for(var _len8=arguments.length,args=new Array(_len8),_key8=0;_key8<_len8;_key8++)args[_key8]=arguments[_key8];this._each("register",args,this.plugins)}addScales(){for(var _len9=arguments.length,args=new Array(_len9),_key9=0;_key9<_len9;_key9++)args[_key9]=arguments[_key9];this._each("register",args,this.scales)}getController(id){return this._get(id,this.controllers,"controller")}getElement(id){return this._get(id,this.elements,"element")}getPlugin(id){return this._get(id,this.plugins,"plugin")}getScale(id){return this._get(id,this.scales,"scale")}removeControllers(){for(var _len10=arguments.length,args=new Array(_len10),_key10=0;_key10<_len10;_key10++)args[_key10]=arguments[_key10];this._each("unregister",args,this.controllers)}removeElements(){for(var _len11=arguments.length,args=new Array(_len11),_key11=0;_key11<_len11;_key11++)args[_key11]=arguments[_key11];this._each("unregister",args,this.elements)}removePlugins(){for(var _len12=arguments.length,args=new Array(_len12),_key12=0;_key12<_len12;_key12++)args[_key12]=arguments[_key12];this._each("unregister",args,this.plugins)}removeScales(){for(var _len13=arguments.length,args=new Array(_len13),_key13=0;_key13<_len13;_key13++)args[_key13]=arguments[_key13];this._each("unregister",args,this.scales)}_each(method,args,typedRegistry){[...args].forEach((arg=>{const reg=typedRegistry||this._getRegistryForType(arg);typedRegistry||reg.isForType(arg)||reg===this.plugins&&arg.id?this._exec(method,reg,arg):each(arg,(item=>{const itemReg=typedRegistry||this._getRegistryForType(item);this._exec(method,itemReg,item)}))}))}_exec(method,registry,component){const camelMethod=_capitalize(method);callback(component["before"+camelMethod],[],component),registry[method](component),callback(component["after"+camelMethod],[],component)}_getRegistryForType(type){for(let i=0;i<this._typedRegistries.length;i++){const reg=this._typedRegistries[i];if(reg.isForType(type))return reg}return this.plugins}_get(id,typedRegistry,type){const item=typedRegistry.get(id);if(void 0===item)throw new Error('"'+id+'" is not a registered '+type+".");return item}};class PluginService{constructor(){this._init=[]}notify(chart,hook,args,filter){"beforeInit"===hook&&(this._init=this._createDescriptors(chart,!0),this._notify(this._init,chart,"install"));const descriptors=filter?this._descriptors(chart).filter(filter):this._descriptors(chart),result=this._notify(descriptors,chart,hook,args);return"afterDestroy"===hook&&(this._notify(descriptors,chart,"stop"),this._notify(this._init,chart,"uninstall")),result}_notify(descriptors,chart,hook,args){args=args||{};for(const descriptor of descriptors){const plugin=descriptor.plugin;if(!1===callback(plugin[hook],[chart,args,descriptor.options],plugin)&&args.cancelable)return!1}return!0}invalidate(){isNullOrUndef(this._cache)||(this._oldCache=this._cache,this._cache=void 0)}_descriptors(chart){if(this._cache)return this._cache;const descriptors=this._cache=this._createDescriptors(chart);return this._notifyStateChanges(chart),descriptors}_createDescriptors(chart,all){const config=chart&&chart.config,options=valueOrDefault(config.options&&config.options.plugins,{}),plugins=function(config){const localIds={},plugins=[],keys=Object.keys(registry.plugins.items);for(let i=0;i<keys.length;i++)plugins.push(registry.getPlugin(keys[i]));const local=config.plugins||[];for(let i=0;i<local.length;i++){const plugin=local[i];-1===plugins.indexOf(plugin)&&(plugins.push(plugin),localIds[plugin.id]=!0)}return{plugins:plugins,localIds:localIds}}(config);return!1!==options||all?function(chart,_ref2,options,all){let{plugins:plugins,localIds:localIds}=_ref2;const result=[],context=chart.getContext();for(const plugin of plugins){const id=plugin.id,opts=getOpts(options[id],all);null!==opts&&result.push({plugin:plugin,options:pluginOpts(chart.config,{plugin:plugin,local:localIds[id]},opts,context)})}return result}(chart,plugins,options,all):[]}_notifyStateChanges(chart){const previousDescriptors=this._oldCache||[],descriptors=this._cache,diff=(a,b)=>a.filter((x=>!b.some((y=>x.plugin.id===y.plugin.id))));this._notify(diff(previousDescriptors,descriptors),chart,"stop"),this._notify(diff(descriptors,previousDescriptors),chart,"start")}}function getOpts(options,all){return all||!1!==options?!0===options?{}:options:null}function pluginOpts(config,_ref3,opts,context){let{plugin:plugin,local:local}=_ref3;const keys=config.pluginScopeKeys(plugin),scopes=config.getOptionScopes(opts,keys);return local&&plugin.defaults&&scopes.push(plugin.defaults),config.createResolver(scopes,context,[""],{scriptable:!1,indexable:!1,allKeys:!0})}function getIndexAxis(type,options){const datasetDefaults=defaults.datasets[type]||{};return((options.datasets||{})[type]||{}).indexAxis||options.indexAxis||datasetDefaults.indexAxis||"x"}function idMatchesAxis(id){if("x"===id||"y"===id||"r"===id)return id}function axisFromPosition(position){return"top"===position||"bottom"===position?"x":"left"===position||"right"===position?"y":void 0}function determineAxis(id){if(idMatchesAxis(id))return id;for(var _len14=arguments.length,scaleOptions=new Array(_len14>1?_len14-1:0),_key14=1;_key14<_len14;_key14++)scaleOptions[_key14-1]=arguments[_key14];for(const opts of scaleOptions){const axis=opts.axis||axisFromPosition(opts.position)||id.length>1&&idMatchesAxis(id[0].toLowerCase());if(axis)return axis}throw new Error("Cannot determine type of '".concat(id,"' axis. Please provide 'axis' or 'position' option."))}function getAxisFromDataset(id,axis,dataset){if(dataset[axis+"AxisID"]===id)return{axis:axis}}function mergeScaleConfig(config,options){const chartDefaults=overrides[config.type]||{scales:{}},configScales=options.scales||{},chartIndexAxis=getIndexAxis(config.type,options),scales=Object.create(null);return Object.keys(configScales).forEach((id=>{const scaleConf=configScales[id];if(!isObject(scaleConf))return console.error("Invalid scale configuration for scale: ".concat(id));if(scaleConf._proxy)return console.warn("Ignoring resolver passed as options for scale: ".concat(id));const axis=determineAxis(id,scaleConf,function(id,config){if(config.data&&config.data.datasets){const boundDs=config.data.datasets.filter((d=>d.xAxisID===id||d.yAxisID===id));if(boundDs.length)return getAxisFromDataset(id,"x",boundDs[0])||getAxisFromDataset(id,"y",boundDs[0])}return{}}(id,config),defaults.scales[scaleConf.type]),defaultId=function(axis,indexAxis){return axis===indexAxis?"_index_":"_value_"}(axis,chartIndexAxis),defaultScaleOptions=chartDefaults.scales||{};scales[id]=mergeIf(Object.create(null),[{axis:axis},scaleConf,defaultScaleOptions[axis],defaultScaleOptions[defaultId]])})),config.data.datasets.forEach((dataset=>{const type=dataset.type||config.type,indexAxis=dataset.indexAxis||getIndexAxis(type,options),defaultScaleOptions=(overrides[type]||{}).scales||{};Object.keys(defaultScaleOptions).forEach((defaultID=>{const axis=function(id,indexAxis){let axis=id;return"_index_"===id?axis=indexAxis:"_value_"===id&&(axis="x"===indexAxis?"y":"x"),axis}(defaultID,indexAxis),id=dataset[axis+"AxisID"]||axis;scales[id]=scales[id]||Object.create(null),mergeIf(scales[id],[{axis:axis},configScales[id],defaultScaleOptions[defaultID]])}))})),Object.keys(scales).forEach((key=>{const scale=scales[key];mergeIf(scale,[defaults.scales[scale.type],defaults.scale])})),scales}function initOptions(config){const options=config.options||(config.options={});options.plugins=valueOrDefault(options.plugins,{}),options.scales=mergeScaleConfig(config,options)}function initData(data){return(data=data||{}).datasets=data.datasets||[],data.labels=data.labels||[],data}const keyCache=new Map,keysCached=new Set;function cachedKeys(cacheKey,generate){let keys=keyCache.get(cacheKey);return keys||(keys=generate(),keyCache.set(cacheKey,keys),keysCached.add(keys)),keys}const addIfFound=(set,obj,key)=>{const opts=resolveObjectKey(obj,key);void 0!==opts&&set.add(opts)};class Config{constructor(config){this._config=function(config){return(config=config||{}).data=initData(config.data),initOptions(config),config}(config),this._scopeCache=new Map,this._resolverCache=new Map}get platform(){return this._config.platform}get type(){return this._config.type}set type(type){this._config.type=type}get data(){return this._config.data}set data(data){this._config.data=initData(data)}get options(){return this._config.options}set options(options){this._config.options=options}get plugins(){return this._config.plugins}update(){const config=this._config;this.clearCache(),initOptions(config)}clearCache(){this._scopeCache.clear(),this._resolverCache.clear()}datasetScopeKeys(datasetType){return cachedKeys(datasetType,(()=>[["datasets.".concat(datasetType),""]]))}datasetAnimationScopeKeys(datasetType,transition){return cachedKeys("".concat(datasetType,".transition.").concat(transition),(()=>[["datasets.".concat(datasetType,".transitions.").concat(transition),"transitions.".concat(transition)],["datasets.".concat(datasetType),""]]))}datasetElementScopeKeys(datasetType,elementType){return cachedKeys("".concat(datasetType,"-").concat(elementType),(()=>[["datasets.".concat(datasetType,".elements.").concat(elementType),"datasets.".concat(datasetType),"elements.".concat(elementType),""]]))}pluginScopeKeys(plugin){const id=plugin.id,type=this.type;return cachedKeys("".concat(type,"-plugin-").concat(id),(()=>[["plugins.".concat(id),...plugin.additionalOptionScopes||[]]]))}_cachedScopes(mainScope,resetCache){const _scopeCache=this._scopeCache;let cache=_scopeCache.get(mainScope);return cache&&!resetCache||(cache=new Map,_scopeCache.set(mainScope,cache)),cache}getOptionScopes(mainScope,keyLists,resetCache){const{options:options,type:type}=this,cache=this._cachedScopes(mainScope,resetCache),cached=cache.get(keyLists);if(cached)return cached;const scopes=new Set;keyLists.forEach((keys=>{mainScope&&(scopes.add(mainScope),keys.forEach((key=>addIfFound(scopes,mainScope,key)))),keys.forEach((key=>addIfFound(scopes,options,key))),keys.forEach((key=>addIfFound(scopes,overrides[type]||{},key))),keys.forEach((key=>addIfFound(scopes,defaults,key))),keys.forEach((key=>addIfFound(scopes,descriptors,key)))}));const array=Array.from(scopes);return 0===array.length&&array.push(Object.create(null)),keysCached.has(keyLists)&&cache.set(keyLists,array),array}chartOptionScopes(){const{options:options,type:type}=this;return[options,overrides[type]||{},defaults.datasets[type]||{},{type:type},defaults,descriptors]}resolveNamedOptions(scopes,names,context){let prefixes=arguments.length>3&&void 0!==arguments[3]?arguments[3]:[""];const result={$shared:!0},{resolver:resolver,subPrefixes:subPrefixes}=getResolver(this._resolverCache,scopes,prefixes);let options=resolver;(function(proxy,names){const{isScriptable:isScriptable,isIndexable:isIndexable}=_descriptors(proxy);for(const prop of names){const scriptable=isScriptable(prop),indexable=isIndexable(prop),value=(indexable||scriptable)&&proxy[prop];if(scriptable&&(isFunction(value)||hasFunction(value))||indexable&&isArray(value))return!0}return!1})(resolver,names)&&(result.$shared=!1,options=_attachContext(resolver,context=isFunction(context)?context():context,this.createResolver(scopes,context,subPrefixes)));for(const prop of names)result[prop]=options[prop];return result}createResolver(scopes,context){let prefixes=arguments.length>2&&void 0!==arguments[2]?arguments[2]:[""],descriptorDefaults=arguments.length>3?arguments[3]:void 0;const{resolver:resolver}=getResolver(this._resolverCache,scopes,prefixes);return isObject(context)?_attachContext(resolver,context,void 0,descriptorDefaults):resolver}}function getResolver(resolverCache,scopes,prefixes){let cache=resolverCache.get(scopes);cache||(cache=new Map,resolverCache.set(scopes,cache));const cacheKey=prefixes.join();let cached=cache.get(cacheKey);return cached||(cached={resolver:_createResolver(scopes,prefixes),subPrefixes:prefixes.filter((p=>!p.toLowerCase().includes("hover")))},cache.set(cacheKey,cached)),cached}const hasFunction=value=>isObject(value)&&Object.getOwnPropertyNames(value).some((key=>isFunction(value[key]))),KNOWN_POSITIONS=["top","bottom","left","right","chartArea"];function positionIsHorizontal(position,axis){return"top"===position||"bottom"===position||-1===KNOWN_POSITIONS.indexOf(position)&&"x"===axis}function compare2Level(l1,l2){return function(a,b){return a[l1]===b[l1]?a[l2]-b[l2]:a[l1]-b[l1]}}function onAnimationsComplete(context){const chart=context.chart,animationOptions=chart.options.animation;chart.notifyPlugins("afterRender"),callback(animationOptions&&animationOptions.onComplete,[context],chart)}function onAnimationProgress(context){const chart=context.chart,animationOptions=chart.options.animation;callback(animationOptions&&animationOptions.onProgress,[context],chart)}function getCanvas(item){return _isDomSupported()&&"string"==typeof item?item=document.getElementById(item):item&&item.length&&(item=item[0]),item&&item.canvas&&(item=item.canvas),item}const instances={},getChart=key=>{const canvas=getCanvas(key);return Object.values(instances).filter((c=>c.canvas===canvas)).pop()};function moveNumericKeys(obj,start,move){const keys=Object.keys(obj);for(const key of keys){const intKey=+key;if(intKey>=start){const value=obj[key];delete obj[key],(move>0||intKey>start)&&(obj[intKey+move]=value)}}}function getSizeForArea(scale,chartArea,field){return scale.options.clip?scale[field]:chartArea[field]}class Chart{static register(){registry.add(...arguments),invalidatePlugins()}static unregister(){registry.remove(...arguments),invalidatePlugins()}constructor(item,userConfig){const config=this.config=new Config(userConfig),initialCanvas=getCanvas(item),existingChart=getChart(initialCanvas);if(existingChart)throw new Error("Canvas is already in use. Chart with ID '"+existingChart.id+"' must be destroyed before the canvas with ID '"+existingChart.canvas.id+"' can be reused.");const options=config.createResolver(config.chartOptionScopes(),this.getContext());this.platform=new(config.platform||_detectPlatform(initialCanvas)),this.platform.updateConfig(config);const context=this.platform.acquireContext(initialCanvas,options.aspectRatio),canvas=context&&context.canvas,height=canvas&&canvas.height,width=canvas&&canvas.width;this.id=uid(),this.ctx=context,this.canvas=canvas,this.width=width,this.height=height,this._options=options,this._aspectRatio=this.aspectRatio,this._layers=[],this._metasets=[],this._stacks=void 0,this.boxes=[],this.currentDevicePixelRatio=void 0,this.chartArea=void 0,this._active=[],this._lastEvent=void 0,this._listeners={},this._responsiveListeners=void 0,this._sortedMetasets=[],this.scales={},this._plugins=new PluginService,this.$proxies={},this._hiddenIndices={},this.attached=!1,this._animationsDisabled=void 0,this.$context=void 0,this._doResize=debounce((mode=>this.update(mode)),options.resizeDelay||0),this._dataChanges=[],instances[this.id]=this,context&&canvas?(animator.listen(this,"complete",onAnimationsComplete),animator.listen(this,"progress",onAnimationProgress),this._initialize(),this.attached&&this.update()):console.error("Failed to create chart: can't acquire context from the given item")}get aspectRatio(){const{options:{aspectRatio:aspectRatio,maintainAspectRatio:maintainAspectRatio},width:width,height:height,_aspectRatio:_aspectRatio}=this;return isNullOrUndef(aspectRatio)?maintainAspectRatio&&_aspectRatio?_aspectRatio:height?width/height:null:aspectRatio}get data(){return this.config.data}set data(data){this.config.data=data}get options(){return this._options}set options(options){this.config.options=options}get registry(){return registry}_initialize(){return this.notifyPlugins("beforeInit"),this.options.responsive?this.resize():retinaScale(this,this.options.devicePixelRatio),this.bindEvents(),this.notifyPlugins("afterInit"),this}clear(){return clearCanvas(this.canvas,this.ctx),this}stop(){return animator.stop(this),this}resize(width,height){animator.running(this)?this._resizeBeforeDraw={width:width,height:height}:this._resize(width,height)}_resize(width,height){const options=this.options,canvas=this.canvas,aspectRatio=options.maintainAspectRatio&&this.aspectRatio,newSize=this.platform.getMaximumSize(canvas,width,height,aspectRatio),newRatio=options.devicePixelRatio||this.platform.getDevicePixelRatio(),mode=this.width?"resize":"attach";this.width=newSize.width,this.height=newSize.height,this._aspectRatio=this.aspectRatio,retinaScale(this,newRatio,!0)&&(this.notifyPlugins("resize",{size:newSize}),callback(options.onResize,[this,newSize],this),this.attached&&this._doResize(mode)&&this.render())}ensureScalesHaveIDs(){each(this.options.scales||{},((axisOptions,axisID)=>{axisOptions.id=axisID}))}buildOrUpdateScales(){const options=this.options,scaleOpts=options.scales,scales=this.scales,updated=Object.keys(scales).reduce(((obj,id)=>(obj[id]=!1,obj)),{});let items=[];scaleOpts&&(items=items.concat(Object.keys(scaleOpts).map((id=>{const scaleOptions=scaleOpts[id],axis=determineAxis(id,scaleOptions),isRadial="r"===axis,isHorizontal="x"===axis;return{options:scaleOptions,dposition:isRadial?"chartArea":isHorizontal?"bottom":"left",dtype:isRadial?"radialLinear":isHorizontal?"category":"linear"}})))),each(items,(item=>{const scaleOptions=item.options,id=scaleOptions.id,axis=determineAxis(id,scaleOptions),scaleType=valueOrDefault(scaleOptions.type,item.dtype);void 0!==scaleOptions.position&&positionIsHorizontal(scaleOptions.position,axis)===positionIsHorizontal(item.dposition)||(scaleOptions.position=item.dposition),updated[id]=!0;let scale=null;id in scales&&scales[id].type===scaleType?scale=scales[id]:(scale=new(registry.getScale(scaleType))({id:id,type:scaleType,ctx:this.ctx,chart:this}),scales[scale.id]=scale),scale.init(scaleOptions,options)})),each(updated,((hasUpdated,id)=>{hasUpdated||delete scales[id]})),each(scales,(scale=>{layouts.configure(this,scale,scale.options),layouts.addBox(this,scale)}))}_updateMetasets(){const metasets=this._metasets,numData=this.data.datasets.length,numMeta=metasets.length;if(metasets.sort(((a,b)=>a.index-b.index)),numMeta>numData){for(let i=numData;i<numMeta;++i)this._destroyDatasetMeta(i);metasets.splice(numData,numMeta-numData)}this._sortedMetasets=metasets.slice(0).sort(compare2Level("order","index"))}_removeUnreferencedMetasets(){const{_metasets:metasets,data:{datasets:datasets}}=this;metasets.length>datasets.length&&delete this._stacks,metasets.forEach(((meta,index)=>{0===datasets.filter((x=>x===meta._dataset)).length&&this._destroyDatasetMeta(index)}))}buildOrUpdateControllers(){const newControllers=[],datasets=this.data.datasets;let i,ilen;for(this._removeUnreferencedMetasets(),i=0,ilen=datasets.length;i<ilen;i++){const dataset=datasets[i];let meta=this.getDatasetMeta(i);const type=dataset.type||this.config.type;if(meta.type&&meta.type!==type&&(this._destroyDatasetMeta(i),meta=this.getDatasetMeta(i)),meta.type=type,meta.indexAxis=dataset.indexAxis||getIndexAxis(type,this.options),meta.order=dataset.order||0,meta.index=i,meta.label=""+dataset.label,meta.visible=this.isDatasetVisible(i),meta.controller)meta.controller.updateIndex(i),meta.controller.linkScales();else{const ControllerClass=registry.getController(type),{datasetElementType:datasetElementType,dataElementType:dataElementType}=defaults.datasets[type];Object.assign(ControllerClass,{dataElementType:registry.getElement(dataElementType),datasetElementType:datasetElementType&&registry.getElement(datasetElementType)}),meta.controller=new ControllerClass(this,i),newControllers.push(meta.controller)}}return this._updateMetasets(),newControllers}_resetElements(){each(this.data.datasets,((dataset,datasetIndex)=>{this.getDatasetMeta(datasetIndex).controller.reset()}),this)}reset(){this._resetElements(),this.notifyPlugins("reset")}update(mode){const config=this.config;config.update();const options=this._options=config.createResolver(config.chartOptionScopes(),this.getContext()),animsDisabled=this._animationsDisabled=!options.animation;if(this._updateScales(),this._checkEventBindings(),this._updateHiddenIndices(),this._plugins.invalidate(),!1===this.notifyPlugins("beforeUpdate",{mode:mode,cancelable:!0}))return;const newControllers=this.buildOrUpdateControllers();this.notifyPlugins("beforeElementsUpdate");let minPadding=0;for(let i=0,ilen=this.data.datasets.length;i<ilen;i++){const{controller:controller}=this.getDatasetMeta(i),reset=!animsDisabled&&-1===newControllers.indexOf(controller);controller.buildOrUpdateElements(reset),minPadding=Math.max(+controller.getMaxOverflow(),minPadding)}minPadding=this._minPadding=options.layout.autoPadding?minPadding:0,this._updateLayout(minPadding),animsDisabled||each(newControllers,(controller=>{controller.reset()})),this._updateDatasets(mode),this.notifyPlugins("afterUpdate",{mode:mode}),this._layers.sort(compare2Level("z","_idx"));const{_active:_active,_lastEvent:_lastEvent}=this;_lastEvent?this._eventHandler(_lastEvent,!0):_active.length&&this._updateHoverStyles(_active,_active,!0),this.render()}_updateScales(){each(this.scales,(scale=>{layouts.removeBox(this,scale)})),this.ensureScalesHaveIDs(),this.buildOrUpdateScales()}_checkEventBindings(){const options=this.options,existingEvents=new Set(Object.keys(this._listeners)),newEvents=new Set(options.events);setsEqual(existingEvents,newEvents)&&!!this._responsiveListeners===options.responsive||(this.unbindEvents(),this.bindEvents())}_updateHiddenIndices(){const{_hiddenIndices:_hiddenIndices}=this,changes=this._getUniformDataChanges()||[];for(const{method:method,start:start,count:count}of changes)moveNumericKeys(_hiddenIndices,start,"_removeElements"===method?-count:count)}_getUniformDataChanges(){const _dataChanges=this._dataChanges;if(!_dataChanges||!_dataChanges.length)return;this._dataChanges=[];const datasetCount=this.data.datasets.length,makeSet=idx=>new Set(_dataChanges.filter((c=>c[0]===idx)).map(((c,i)=>i+","+c.splice(1).join(",")))),changeSet=makeSet(0);for(let i=1;i<datasetCount;i++)if(!setsEqual(changeSet,makeSet(i)))return;return Array.from(changeSet).map((c=>c.split(","))).map((a=>({method:a[1],start:+a[2],count:+a[3]})))}_updateLayout(minPadding){if(!1===this.notifyPlugins("beforeLayout",{cancelable:!0}))return;layouts.update(this,this.width,this.height,minPadding);const area=this.chartArea,noArea=area.width<=0||area.height<=0;this._layers=[],each(this.boxes,(box=>{noArea&&"chartArea"===box.position||(box.configure&&box.configure(),this._layers.push(...box._layers()))}),this),this._layers.forEach(((item,index)=>{item._idx=index})),this.notifyPlugins("afterLayout")}_updateDatasets(mode){if(!1!==this.notifyPlugins("beforeDatasetsUpdate",{mode:mode,cancelable:!0})){for(let i=0,ilen=this.data.datasets.length;i<ilen;++i)this.getDatasetMeta(i).controller.configure();for(let i=0,ilen=this.data.datasets.length;i<ilen;++i)this._updateDataset(i,isFunction(mode)?mode({datasetIndex:i}):mode);this.notifyPlugins("afterDatasetsUpdate",{mode:mode})}}_updateDataset(index,mode){const meta=this.getDatasetMeta(index),args={meta:meta,index:index,mode:mode,cancelable:!0};!1!==this.notifyPlugins("beforeDatasetUpdate",args)&&(meta.controller._update(mode),args.cancelable=!1,this.notifyPlugins("afterDatasetUpdate",args))}render(){!1!==this.notifyPlugins("beforeRender",{cancelable:!0})&&(animator.has(this)?this.attached&&!animator.running(this)&&animator.start(this):(this.draw(),onAnimationsComplete({chart:this})))}draw(){let i;if(this._resizeBeforeDraw){const{width:width,height:height}=this._resizeBeforeDraw;this._resize(width,height),this._resizeBeforeDraw=null}if(this.clear(),this.width<=0||this.height<=0)return;if(!1===this.notifyPlugins("beforeDraw",{cancelable:!0}))return;const layers=this._layers;for(i=0;i<layers.length&&layers[i].z<=0;++i)layers[i].draw(this.chartArea);for(this._drawDatasets();i<layers.length;++i)layers[i].draw(this.chartArea);this.notifyPlugins("afterDraw")}_getSortedDatasetMetas(filterVisible){const metasets=this._sortedMetasets,result=[];let i,ilen;for(i=0,ilen=metasets.length;i<ilen;++i){const meta=metasets[i];filterVisible&&!meta.visible||result.push(meta)}return result}getSortedVisibleDatasetMetas(){return this._getSortedDatasetMetas(!0)}_drawDatasets(){if(!1===this.notifyPlugins("beforeDatasetsDraw",{cancelable:!0}))return;const metasets=this.getSortedVisibleDatasetMetas();for(let i=metasets.length-1;i>=0;--i)this._drawDataset(metasets[i]);this.notifyPlugins("afterDatasetsDraw")}_drawDataset(meta){const ctx=this.ctx,clip=meta._clip,useClip=!clip.disabled,area=function(meta,chartArea){const{xScale:xScale,yScale:yScale}=meta;return xScale&&yScale?{left:getSizeForArea(xScale,chartArea,"left"),right:getSizeForArea(xScale,chartArea,"right"),top:getSizeForArea(yScale,chartArea,"top"),bottom:getSizeForArea(yScale,chartArea,"bottom")}:chartArea}(meta,this.chartArea),args={meta:meta,index:meta.index,cancelable:!0};!1!==this.notifyPlugins("beforeDatasetDraw",args)&&(useClip&&clipArea(ctx,{left:!1===clip.left?0:area.left-clip.left,right:!1===clip.right?this.width:area.right+clip.right,top:!1===clip.top?0:area.top-clip.top,bottom:!1===clip.bottom?this.height:area.bottom+clip.bottom}),meta.controller.draw(),useClip&&unclipArea(ctx),args.cancelable=!1,this.notifyPlugins("afterDatasetDraw",args))}isPointInArea(point){return _isPointInArea(point,this.chartArea,this._minPadding)}getElementsAtEventForMode(e,mode,options,useFinalPosition){const method=Interaction.modes[mode];return"function"==typeof method?method(this,e,options,useFinalPosition):[]}getDatasetMeta(datasetIndex){const dataset=this.data.datasets[datasetIndex],metasets=this._metasets;let meta=metasets.filter((x=>x&&x._dataset===dataset)).pop();return meta||(meta={type:null,data:[],dataset:null,controller:null,hidden:null,xAxisID:null,yAxisID:null,order:dataset&&dataset.order||0,index:datasetIndex,_dataset:dataset,_parsed:[],_sorted:!1},metasets.push(meta)),meta}getContext(){return this.$context||(this.$context=createContext(null,{chart:this,type:"chart"}))}getVisibleDatasetCount(){return this.getSortedVisibleDatasetMetas().length}isDatasetVisible(datasetIndex){const dataset=this.data.datasets[datasetIndex];if(!dataset)return!1;const meta=this.getDatasetMeta(datasetIndex);return"boolean"==typeof meta.hidden?!meta.hidden:!dataset.hidden}setDatasetVisibility(datasetIndex,visible){this.getDatasetMeta(datasetIndex).hidden=!visible}toggleDataVisibility(index){this._hiddenIndices[index]=!this._hiddenIndices[index]}getDataVisibility(index){return!this._hiddenIndices[index]}_updateVisibility(datasetIndex,dataIndex,visible){const mode=visible?"show":"hide",meta=this.getDatasetMeta(datasetIndex),anims=meta.controller._resolveAnimations(void 0,mode);defined(dataIndex)?(meta.data[dataIndex].hidden=!visible,this.update()):(this.setDatasetVisibility(datasetIndex,visible),anims.update(meta,{visible:visible}),this.update((ctx=>ctx.datasetIndex===datasetIndex?mode:void 0)))}hide(datasetIndex,dataIndex){this._updateVisibility(datasetIndex,dataIndex,!1)}show(datasetIndex,dataIndex){this._updateVisibility(datasetIndex,dataIndex,!0)}_destroyDatasetMeta(datasetIndex){const meta=this._metasets[datasetIndex];meta&&meta.controller&&meta.controller._destroy(),delete this._metasets[datasetIndex]}_stop(){let i,ilen;for(this.stop(),animator.remove(this),i=0,ilen=this.data.datasets.length;i<ilen;++i)this._destroyDatasetMeta(i)}destroy(){this.notifyPlugins("beforeDestroy");const{canvas:canvas,ctx:ctx}=this;this._stop(),this.config.clearCache(),canvas&&(this.unbindEvents(),clearCanvas(canvas,ctx),this.platform.releaseContext(ctx),this.canvas=null,this.ctx=null),delete instances[this.id],this.notifyPlugins("afterDestroy")}toBase64Image(){return this.canvas.toDataURL(...arguments)}bindEvents(){this.bindUserEvents(),this.options.responsive?this.bindResponsiveEvents():this.attached=!0}bindUserEvents(){const listeners=this._listeners,platform=this.platform,_add=(type,listener)=>{platform.addEventListener(this,type,listener),listeners[type]=listener},listener=(e,x,y)=>{e.offsetX=x,e.offsetY=y,this._eventHandler(e)};each(this.options.events,(type=>_add(type,listener)))}bindResponsiveEvents(){this._responsiveListeners||(this._responsiveListeners={});const listeners=this._responsiveListeners,platform=this.platform,_add=(type,listener)=>{platform.addEventListener(this,type,listener),listeners[type]=listener},_remove=(type,listener)=>{listeners[type]&&(platform.removeEventListener(this,type,listener),delete listeners[type])},listener=(width,height)=>{this.canvas&&this.resize(width,height)};let detached;const attached=()=>{_remove("attach",attached),this.attached=!0,this.resize(),_add("resize",listener),_add("detach",detached)};detached=()=>{this.attached=!1,_remove("resize",listener),this._stop(),this._resize(0,0),_add("attach",attached)},platform.isAttached(this.canvas)?attached():detached()}unbindEvents(){each(this._listeners,((listener,type)=>{this.platform.removeEventListener(this,type,listener)})),this._listeners={},each(this._responsiveListeners,((listener,type)=>{this.platform.removeEventListener(this,type,listener)})),this._responsiveListeners=void 0}updateHoverStyle(items,mode,enabled){const prefix=enabled?"set":"remove";let meta,item,i,ilen;for("dataset"===mode&&(meta=this.getDatasetMeta(items[0].datasetIndex),meta.controller["_"+prefix+"DatasetHoverStyle"]()),i=0,ilen=items.length;i<ilen;++i){item=items[i];const controller=item&&this.getDatasetMeta(item.datasetIndex).controller;controller&&controller[prefix+"HoverStyle"](item.element,item.datasetIndex,item.index)}}getActiveElements(){return this._active||[]}setActiveElements(activeElements){const lastActive=this._active||[],active=activeElements.map((_ref4=>{let{datasetIndex:datasetIndex,index:index}=_ref4;const meta=this.getDatasetMeta(datasetIndex);if(!meta)throw new Error("No dataset found at index "+datasetIndex);return{datasetIndex:datasetIndex,element:meta.data[index],index:index}}));!_elementsEqual(active,lastActive)&&(this._active=active,this._lastEvent=null,this._updateHoverStyles(active,lastActive))}notifyPlugins(hook,args,filter){return this._plugins.notify(this,hook,args,filter)}isPluginEnabled(pluginId){return 1===this._plugins._cache.filter((p=>p.plugin.id===pluginId)).length}_updateHoverStyles(active,lastActive,replay){const hoverOptions=this.options.hover,diff=(a,b)=>a.filter((x=>!b.some((y=>x.datasetIndex===y.datasetIndex&&x.index===y.index)))),deactivated=diff(lastActive,active),activated=replay?active:diff(active,lastActive);deactivated.length&&this.updateHoverStyle(deactivated,hoverOptions.mode,!1),activated.length&&hoverOptions.mode&&this.updateHoverStyle(activated,hoverOptions.mode,!0)}_eventHandler(e,replay){const args={event:e,replay:replay,cancelable:!0,inChartArea:this.isPointInArea(e)},eventFilter=plugin=>(plugin.options.events||this.options.events).includes(e.native.type);if(!1===this.notifyPlugins("beforeEvent",args,eventFilter))return;const changed=this._handleEvent(e,replay,args.inChartArea);return args.cancelable=!1,this.notifyPlugins("afterEvent",args,eventFilter),(changed||args.changed)&&this.render(),this}_handleEvent(e,replay,inChartArea){const{_active:lastActive=[],options:options}=this,useFinalPosition=replay,active=this._getActiveElements(e,lastActive,inChartArea,useFinalPosition),isClick=_isClickEvent(e),lastEvent=function(e,lastEvent,inChartArea,isClick){return inChartArea&&"mouseout"!==e.type?isClick?lastEvent:e:null}(e,this._lastEvent,inChartArea,isClick);inChartArea&&(this._lastEvent=null,callback(options.onHover,[e,active,this],this),isClick&&callback(options.onClick,[e,active,this],this));const changed=!_elementsEqual(active,lastActive);return(changed||replay)&&(this._active=active,this._updateHoverStyles(active,lastActive,replay)),this._lastEvent=lastEvent,changed}_getActiveElements(e,lastActive,inChartArea,useFinalPosition){if("mouseout"===e.type)return[];if(!inChartArea)return lastActive;const hoverOptions=this.options.hover;return this.getElementsAtEventForMode(e,hoverOptions.mode,hoverOptions,useFinalPosition)}}function invalidatePlugins(){return each(Chart.instances,(chart=>chart._plugins.invalidate()))}function abstract(){throw new Error("This method is not implemented: Check that a complete date adapter is provided.")}_defineProperty(Chart,"defaults",defaults),_defineProperty(Chart,"instances",instances),_defineProperty(Chart,"overrides",overrides),_defineProperty(Chart,"registry",registry),_defineProperty(Chart,"version","4.4.2"),_defineProperty(Chart,"getChart",getChart);class DateAdapterBase{static override(members){Object.assign(DateAdapterBase.prototype,members)}constructor(options){_defineProperty(this,"options",void 0),this.options=options||{}}init(){}formats(){return abstract()}parse(){return abstract()}format(){return abstract()}add(){return abstract()}diff(){return abstract()}startOf(){return abstract()}endOf(){return abstract()}}var _adapters={_date:DateAdapterBase};function computeMinSampleSize(meta){const scale=meta.iScale,values=function(scale,type){if(!scale._cache.$bar){const visibleMetas=scale.getMatchingVisibleMetas(type);let values=[];for(let i=0,ilen=visibleMetas.length;i<ilen;i++)values=values.concat(visibleMetas[i].controller.getAllParsedValues(scale));scale._cache.$bar=_arrayUnique(values.sort(((a,b)=>a-b)))}return scale._cache.$bar}(scale,meta.type);let i,ilen,curr,prev,min=scale._length;const updateMinAndPrev=()=>{32767!==curr&&-32768!==curr&&(defined(prev)&&(min=Math.min(min,Math.abs(curr-prev)||min)),prev=curr)};for(i=0,ilen=values.length;i<ilen;++i)curr=scale.getPixelForValue(values[i]),updateMinAndPrev();for(prev=void 0,i=0,ilen=scale.ticks.length;i<ilen;++i)curr=scale.getPixelForTick(i),updateMinAndPrev();return min}function parseValue(entry,item,vScale,i){return isArray(entry)?function(entry,item,vScale,i){const startValue=vScale.parse(entry[0],i),endValue=vScale.parse(entry[1],i),min=Math.min(startValue,endValue),max=Math.max(startValue,endValue);let barStart=min,barEnd=max;Math.abs(min)>Math.abs(max)&&(barStart=max,barEnd=min),item[vScale.axis]=barEnd,item._custom={barStart:barStart,barEnd:barEnd,start:startValue,end:endValue,min:min,max:max}}(entry,item,vScale,i):item[vScale.axis]=vScale.parse(entry,i),item}function parseArrayOrPrimitive(meta,data,start,count){const iScale=meta.iScale,vScale=meta.vScale,labels=iScale.getLabels(),singleScale=iScale===vScale,parsed=[];let i,ilen,item,entry;for(i=start,ilen=start+count;i<ilen;++i)entry=data[i],item={},item[iScale.axis]=singleScale||iScale.parse(labels[i],i),parsed.push(parseValue(entry,item,vScale,i));return parsed}function isFloatBar(custom){return custom&&void 0!==custom.barStart&&void 0!==custom.barEnd}function setBorderSkipped(properties,options,stack,index){let edge=options.borderSkipped;const res={};if(!edge)return void(properties.borderSkipped=res);if(!0===edge)return void(properties.borderSkipped={top:!0,right:!0,bottom:!0,left:!0});const{start:start,end:end,reverse:reverse,top:top,bottom:bottom}=function(properties){let reverse,start,end,top,bottom;return properties.horizontal?(reverse=properties.base>properties.x,start="left",end="right"):(reverse=properties.base<properties.y,start="bottom",end="top"),reverse?(top="end",bottom="start"):(top="start",bottom="end"),{start:start,end:end,reverse:reverse,top:top,bottom:bottom}}(properties);"middle"===edge&&stack&&(properties.enableBorderRadius=!0,(stack._top||0)===index?edge=top:(stack._bottom||0)===index?edge=bottom:(res[parseEdge(bottom,start,end,reverse)]=!0,edge=top)),res[parseEdge(edge,start,end,reverse)]=!0,properties.borderSkipped=res}function parseEdge(edge,a,b,reverse){var orig,v1,v2;return reverse?(v2=b,edge=startEnd(edge=(orig=edge)===(v1=a)?v2:orig===v2?v1:orig,b,a)):edge=startEnd(edge,a,b),edge}function startEnd(v,start,end){return"start"===v?start:"end"===v?end:v}function setInflateAmount(properties,_ref5,ratio){let{inflateAmount:inflateAmount}=_ref5;properties.inflateAmount="auto"===inflateAmount?1===ratio?.33:0:inflateAmount}class BarController extends DatasetController{parsePrimitiveData(meta,data,start,count){return parseArrayOrPrimitive(meta,data,start,count)}parseArrayData(meta,data,start,count){return parseArrayOrPrimitive(meta,data,start,count)}parseObjectData(meta,data,start,count){const{iScale:iScale,vScale:vScale}=meta,{xAxisKey:xAxisKey="x",yAxisKey:yAxisKey="y"}=this._parsing,iAxisKey="x"===iScale.axis?xAxisKey:yAxisKey,vAxisKey="x"===vScale.axis?xAxisKey:yAxisKey,parsed=[];let i,ilen,item,obj;for(i=start,ilen=start+count;i<ilen;++i)obj=data[i],item={},item[iScale.axis]=iScale.parse(resolveObjectKey(obj,iAxisKey),i),parsed.push(parseValue(resolveObjectKey(obj,vAxisKey),item,vScale,i));return parsed}updateRangeFromParsed(range,scale,parsed,stack){super.updateRangeFromParsed(range,scale,parsed,stack);const custom=parsed._custom;custom&&scale===this._cachedMeta.vScale&&(range.min=Math.min(range.min,custom.min),range.max=Math.max(range.max,custom.max))}getMaxOverflow(){return 0}getLabelAndValue(index){const meta=this._cachedMeta,{iScale:iScale,vScale:vScale}=meta,parsed=this.getParsed(index),custom=parsed._custom,value=isFloatBar(custom)?"["+custom.start+", "+custom.end+"]":""+vScale.getLabelForValue(parsed[vScale.axis]);return{label:""+iScale.getLabelForValue(parsed[iScale.axis]),value:value}}initialize(){this.enableOptionSharing=!0,super.initialize(),this._cachedMeta.stack=this.getDataset().stack}update(mode){const meta=this._cachedMeta;this.updateElements(meta.data,0,meta.data.length,mode)}updateElements(bars,start,count,mode){const reset="reset"===mode,{index:index,_cachedMeta:{vScale:vScale}}=this,base=vScale.getBasePixel(),horizontal=vScale.isHorizontal(),ruler=this._getRuler(),{sharedOptions:sharedOptions,includeOptions:includeOptions}=this._getSharedOptions(start,mode);for(let i=start;i<start+count;i++){const parsed=this.getParsed(i),vpixels=reset||isNullOrUndef(parsed[vScale.axis])?{base:base,head:base}:this._calculateBarValuePixels(i),ipixels=this._calculateBarIndexPixels(i,ruler),stack=(parsed._stacks||{})[vScale.axis],properties={horizontal:horizontal,base:vpixels.base,enableBorderRadius:!stack||isFloatBar(parsed._custom)||index===stack._top||index===stack._bottom,x:horizontal?vpixels.head:ipixels.center,y:horizontal?ipixels.center:vpixels.head,height:horizontal?ipixels.size:Math.abs(vpixels.size),width:horizontal?Math.abs(vpixels.size):ipixels.size};includeOptions&&(properties.options=sharedOptions||this.resolveDataElementOptions(i,bars[i].active?"active":mode));const options=properties.options||bars[i].options;setBorderSkipped(properties,options,stack,index),setInflateAmount(properties,options,ruler.ratio),this.updateElement(bars[i],i,properties,mode)}}_getStacks(last,dataIndex){const{iScale:iScale}=this._cachedMeta,metasets=iScale.getMatchingVisibleMetas(this._type).filter((meta=>meta.controller.options.grouped)),stacked=iScale.options.stacked,stacks=[],skipNull=meta=>{const parsed=meta.controller.getParsed(dataIndex),val=parsed&&parsed[meta.vScale.axis];if(isNullOrUndef(val)||isNaN(val))return!0};for(const meta of metasets)if((void 0===dataIndex||!skipNull(meta))&&((!1===stacked||-1===stacks.indexOf(meta.stack)||void 0===stacked&&void 0===meta.stack)&&stacks.push(meta.stack),meta.index===last))break;return stacks.length||stacks.push(void 0),stacks}_getStackCount(index){return this._getStacks(void 0,index).length}_getStackIndex(datasetIndex,name,dataIndex){const stacks=this._getStacks(datasetIndex,dataIndex),index=void 0!==name?stacks.indexOf(name):-1;return-1===index?stacks.length-1:index}_getRuler(){const opts=this.options,meta=this._cachedMeta,iScale=meta.iScale,pixels=[];let i,ilen;for(i=0,ilen=meta.data.length;i<ilen;++i)pixels.push(iScale.getPixelForValue(this.getParsed(i)[iScale.axis],i));const barThickness=opts.barThickness;return{min:barThickness||computeMinSampleSize(meta),pixels:pixels,start:iScale._startPixel,end:iScale._endPixel,stackCount:this._getStackCount(),scale:iScale,grouped:opts.grouped,ratio:barThickness?1:opts.categoryPercentage*opts.barPercentage}}_calculateBarValuePixels(index){const{_cachedMeta:{vScale:vScale,_stacked:_stacked,index:datasetIndex},options:{base:baseValue,minBarLength:minBarLength}}=this,actualBase=baseValue||0,parsed=this.getParsed(index),custom=parsed._custom,floating=isFloatBar(custom);let head,size,value=parsed[vScale.axis],start=0,length=_stacked?this.applyStack(vScale,parsed,_stacked):value;length!==value&&(start=length-value,length=value),floating&&(value=custom.barStart,length=custom.barEnd-custom.barStart,0!==value&&sign(value)!==sign(custom.barEnd)&&(start=0),start+=value);const startValue=isNullOrUndef(baseValue)||floating?start:baseValue;let base=vScale.getPixelForValue(startValue);if(head=this.chart.getDataVisibility(index)?vScale.getPixelForValue(start+length):base,size=head-base,Math.abs(size)<minBarLength){size=function(size,vScale,actualBase){return 0!==size?sign(size):(vScale.isHorizontal()?1:-1)*(vScale.min>=actualBase?1:-1)}(size,vScale,actualBase)*minBarLength,value===actualBase&&(base-=size/2);const startPixel=vScale.getPixelForDecimal(0),endPixel=vScale.getPixelForDecimal(1),min=Math.min(startPixel,endPixel),max=Math.max(startPixel,endPixel);base=Math.max(Math.min(base,max),min),head=base+size,_stacked&&!floating&&(parsed._stacks[vScale.axis]._visualValues[datasetIndex]=vScale.getValueForPixel(head)-vScale.getValueForPixel(base))}if(base===vScale.getPixelForValue(actualBase)){const halfGrid=sign(size)*vScale.getLineWidthForValue(actualBase)/2;base+=halfGrid,size-=halfGrid}return{size:size,base:base,head:head,center:head+size/2}}_calculateBarIndexPixels(index,ruler){const scale=ruler.scale,options=this.options,skipNull=options.skipNull,maxBarThickness=valueOrDefault(options.maxBarThickness,1/0);let center,size;if(ruler.grouped){const stackCount=skipNull?this._getStackCount(index):ruler.stackCount,range="flex"===options.barThickness?function(index,ruler,options,stackCount){const pixels=ruler.pixels,curr=pixels[index];let prev=index>0?pixels[index-1]:null,next=index<pixels.length-1?pixels[index+1]:null;const percent=options.categoryPercentage;null===prev&&(prev=curr-(null===next?ruler.end-ruler.start:next-curr)),null===next&&(next=curr+curr-prev);const start=curr-(curr-Math.min(prev,next))/2*percent;return{chunk:Math.abs(next-prev)/2*percent/stackCount,ratio:options.barPercentage,start:start}}(index,ruler,options,stackCount):function(index,ruler,options,stackCount){const thickness=options.barThickness;let size,ratio;return isNullOrUndef(thickness)?(size=ruler.min*options.categoryPercentage,ratio=options.barPercentage):(size=thickness*stackCount,ratio=1),{chunk:size/stackCount,ratio:ratio,start:ruler.pixels[index]-size/2}}(index,ruler,options,stackCount),stackIndex=this._getStackIndex(this.index,this._cachedMeta.stack,skipNull?index:void 0);center=range.start+range.chunk*stackIndex+range.chunk/2,size=Math.min(maxBarThickness,range.chunk*range.ratio)}else center=scale.getPixelForValue(this.getParsed(index)[scale.axis],index),size=Math.min(maxBarThickness,ruler.min*ruler.ratio);return{base:center-size/2,head:center+size/2,center:center,size:size}}draw(){const meta=this._cachedMeta,vScale=meta.vScale,rects=meta.data,ilen=rects.length;let i=0;for(;i<ilen;++i)null!==this.getParsed(i)[vScale.axis]&&rects[i].draw(this._ctx)}}_defineProperty(BarController,"id","bar"),_defineProperty(BarController,"defaults",{datasetElementType:!1,dataElementType:"bar",categoryPercentage:.8,barPercentage:.9,grouped:!0,animations:{numbers:{type:"number",properties:["x","y","base","width","height"]}}}),_defineProperty(BarController,"overrides",{scales:{_index_:{type:"category",offset:!0,grid:{offset:!0}},_value_:{type:"linear",beginAtZero:!0}}});class BubbleController extends DatasetController{initialize(){this.enableOptionSharing=!0,super.initialize()}parsePrimitiveData(meta,data,start,count){const parsed=super.parsePrimitiveData(meta,data,start,count);for(let i=0;i<parsed.length;i++)parsed[i]._custom=this.resolveDataElementOptions(i+start).radius;return parsed}parseArrayData(meta,data,start,count){const parsed=super.parseArrayData(meta,data,start,count);for(let i=0;i<parsed.length;i++){const item=data[start+i];parsed[i]._custom=valueOrDefault(item[2],this.resolveDataElementOptions(i+start).radius)}return parsed}parseObjectData(meta,data,start,count){const parsed=super.parseObjectData(meta,data,start,count);for(let i=0;i<parsed.length;i++){const item=data[start+i];parsed[i]._custom=valueOrDefault(item&&item.r&&+item.r,this.resolveDataElementOptions(i+start).radius)}return parsed}getMaxOverflow(){const data=this._cachedMeta.data;let max=0;for(let i=data.length-1;i>=0;--i)max=Math.max(max,data[i].size(this.resolveDataElementOptions(i))/2);return max>0&&max}getLabelAndValue(index){const meta=this._cachedMeta,labels=this.chart.data.labels||[],{xScale:xScale,yScale:yScale}=meta,parsed=this.getParsed(index),x=xScale.getLabelForValue(parsed.x),y=yScale.getLabelForValue(parsed.y),r=parsed._custom;return{label:labels[index]||"",value:"("+x+", "+y+(r?", "+r:"")+")"}}update(mode){const points=this._cachedMeta.data;this.updateElements(points,0,points.length,mode)}updateElements(points,start,count,mode){const reset="reset"===mode,{iScale:iScale,vScale:vScale}=this._cachedMeta,{sharedOptions:sharedOptions,includeOptions:includeOptions}=this._getSharedOptions(start,mode),iAxis=iScale.axis,vAxis=vScale.axis;for(let i=start;i<start+count;i++){const point=points[i],parsed=!reset&&this.getParsed(i),properties={},iPixel=properties[iAxis]=reset?iScale.getPixelForDecimal(.5):iScale.getPixelForValue(parsed[iAxis]),vPixel=properties[vAxis]=reset?vScale.getBasePixel():vScale.getPixelForValue(parsed[vAxis]);properties.skip=isNaN(iPixel)||isNaN(vPixel),includeOptions&&(properties.options=sharedOptions||this.resolveDataElementOptions(i,point.active?"active":mode),reset&&(properties.options.radius=0)),this.updateElement(point,i,properties,mode)}}resolveDataElementOptions(index,mode){const parsed=this.getParsed(index);let values=super.resolveDataElementOptions(index,mode);values.$shared&&(values=Object.assign({},values,{$shared:!1}));const radius=values.radius;return"active"!==mode&&(values.radius=0),values.radius+=valueOrDefault(parsed&&parsed._custom,radius),values}}_defineProperty(BubbleController,"id","bubble"),_defineProperty(BubbleController,"defaults",{datasetElementType:!1,dataElementType:"point",animations:{numbers:{type:"number",properties:["x","y","borderWidth","radius"]}}}),_defineProperty(BubbleController,"overrides",{scales:{x:{type:"linear"},y:{type:"linear"}}});class DoughnutController extends DatasetController{constructor(chart,datasetIndex){super(chart,datasetIndex),this.enableOptionSharing=!0,this.innerRadius=void 0,this.outerRadius=void 0,this.offsetX=void 0,this.offsetY=void 0}linkScales(){}parse(start,count){const data=this.getDataset().data,meta=this._cachedMeta;if(!1===this._parsing)meta._parsed=data;else{let i,ilen,getter=i=>+data[i];if(isObject(data[start])){const{key:key="value"}=this._parsing;getter=i=>+resolveObjectKey(data[i],key)}for(i=start,ilen=start+count;i<ilen;++i)meta._parsed[i]=getter(i)}}_getRotation(){return toRadians(this.options.rotation-90)}_getCircumference(){return toRadians(this.options.circumference)}_getRotationExtents(){let min=TAU,max=-TAU;for(let i=0;i<this.chart.data.datasets.length;++i)if(this.chart.isDatasetVisible(i)&&this.chart.getDatasetMeta(i).type===this._type){const controller=this.chart.getDatasetMeta(i).controller,rotation=controller._getRotation(),circumference=controller._getCircumference();min=Math.min(min,rotation),max=Math.max(max,rotation+circumference)}return{rotation:min,circumference:max-min}}update(mode){const chart=this.chart,{chartArea:chartArea}=chart,meta=this._cachedMeta,arcs=meta.data,spacing=this.getMaxBorderWidth()+this.getMaxOffset(arcs)+this.options.spacing,maxSize=Math.max((Math.min(chartArea.width,chartArea.height)-spacing)/2,0),cutout=Math.min(toPercentage(this.options.cutout,maxSize),1),chartWeight=this._getRingWeight(this.index),{circumference:circumference,rotation:rotation}=this._getRotationExtents(),{ratioX:ratioX,ratioY:ratioY,offsetX:offsetX,offsetY:offsetY}=function(rotation,circumference,cutout){let ratioX=1,ratioY=1,offsetX=0,offsetY=0;if(circumference<TAU){const startAngle=rotation,endAngle=startAngle+circumference,startX=Math.cos(startAngle),startY=Math.sin(startAngle),endX=Math.cos(endAngle),endY=Math.sin(endAngle),calcMax=(angle,a,b)=>_angleBetween(angle,startAngle,endAngle,!0)?1:Math.max(a,a*cutout,b,b*cutout),calcMin=(angle,a,b)=>_angleBetween(angle,startAngle,endAngle,!0)?-1:Math.min(a,a*cutout,b,b*cutout),maxX=calcMax(0,startX,endX),maxY=calcMax(HALF_PI,startY,endY),minX=calcMin(PI,startX,endX),minY=calcMin(PI+HALF_PI,startY,endY);ratioX=(maxX-minX)/2,ratioY=(maxY-minY)/2,offsetX=-(maxX+minX)/2,offsetY=-(maxY+minY)/2}return{ratioX:ratioX,ratioY:ratioY,offsetX:offsetX,offsetY:offsetY}}(rotation,circumference,cutout),maxWidth=(chartArea.width-spacing)/ratioX,maxHeight=(chartArea.height-spacing)/ratioY,maxRadius=Math.max(Math.min(maxWidth,maxHeight)/2,0),outerRadius=toDimension(this.options.radius,maxRadius),radiusLength=(outerRadius-Math.max(outerRadius*cutout,0))/this._getVisibleDatasetWeightTotal();this.offsetX=offsetX*outerRadius,this.offsetY=offsetY*outerRadius,meta.total=this.calculateTotal(),this.outerRadius=outerRadius-radiusLength*this._getRingWeightOffset(this.index),this.innerRadius=Math.max(this.outerRadius-radiusLength*chartWeight,0),this.updateElements(arcs,0,arcs.length,mode)}_circumference(i,reset){const opts=this.options,meta=this._cachedMeta,circumference=this._getCircumference();return reset&&opts.animation.animateRotate||!this.chart.getDataVisibility(i)||null===meta._parsed[i]||meta.data[i].hidden?0:this.calculateCircumference(meta._parsed[i]*circumference/TAU)}updateElements(arcs,start,count,mode){const reset="reset"===mode,chart=this.chart,chartArea=chart.chartArea,animationOpts=chart.options.animation,centerX=(chartArea.left+chartArea.right)/2,centerY=(chartArea.top+chartArea.bottom)/2,animateScale=reset&&animationOpts.animateScale,innerRadius=animateScale?0:this.innerRadius,outerRadius=animateScale?0:this.outerRadius,{sharedOptions:sharedOptions,includeOptions:includeOptions}=this._getSharedOptions(start,mode);let i,startAngle=this._getRotation();for(i=0;i<start;++i)startAngle+=this._circumference(i,reset);for(i=start;i<start+count;++i){const circumference=this._circumference(i,reset),arc=arcs[i],properties={x:centerX+this.offsetX,y:centerY+this.offsetY,startAngle:startAngle,endAngle:startAngle+circumference,circumference:circumference,outerRadius:outerRadius,innerRadius:innerRadius};includeOptions&&(properties.options=sharedOptions||this.resolveDataElementOptions(i,arc.active?"active":mode)),startAngle+=circumference,this.updateElement(arc,i,properties,mode)}}calculateTotal(){const meta=this._cachedMeta,metaData=meta.data;let i,total=0;for(i=0;i<metaData.length;i++){const value=meta._parsed[i];null===value||isNaN(value)||!this.chart.getDataVisibility(i)||metaData[i].hidden||(total+=Math.abs(value))}return total}calculateCircumference(value){const total=this._cachedMeta.total;return total>0&&!isNaN(value)?TAU*(Math.abs(value)/total):0}getLabelAndValue(index){const meta=this._cachedMeta,chart=this.chart,labels=chart.data.labels||[],value=formatNumber(meta._parsed[index],chart.options.locale);return{label:labels[index]||"",value:value}}getMaxBorderWidth(arcs){let max=0;const chart=this.chart;let i,ilen,meta,controller,options;if(!arcs)for(i=0,ilen=chart.data.datasets.length;i<ilen;++i)if(chart.isDatasetVisible(i)){meta=chart.getDatasetMeta(i),arcs=meta.data,controller=meta.controller;break}if(!arcs)return 0;for(i=0,ilen=arcs.length;i<ilen;++i)options=controller.resolveDataElementOptions(i),"inner"!==options.borderAlign&&(max=Math.max(max,options.borderWidth||0,options.hoverBorderWidth||0));return max}getMaxOffset(arcs){let max=0;for(let i=0,ilen=arcs.length;i<ilen;++i){const options=this.resolveDataElementOptions(i);max=Math.max(max,options.offset||0,options.hoverOffset||0)}return max}_getRingWeightOffset(datasetIndex){let ringWeightOffset=0;for(let i=0;i<datasetIndex;++i)this.chart.isDatasetVisible(i)&&(ringWeightOffset+=this._getRingWeight(i));return ringWeightOffset}_getRingWeight(datasetIndex){return Math.max(valueOrDefault(this.chart.data.datasets[datasetIndex].weight,1),0)}_getVisibleDatasetWeightTotal(){return this._getRingWeightOffset(this.chart.data.datasets.length)||1}}_defineProperty(DoughnutController,"id","doughnut"),_defineProperty(DoughnutController,"defaults",{datasetElementType:!1,dataElementType:"arc",animation:{animateRotate:!0,animateScale:!1},animations:{numbers:{type:"number",properties:["circumference","endAngle","innerRadius","outerRadius","startAngle","x","y","offset","borderWidth","spacing"]}},cutout:"50%",rotation:0,circumference:360,radius:"100%",spacing:0,indexAxis:"r"}),_defineProperty(DoughnutController,"descriptors",{_scriptable:name=>"spacing"!==name,_indexable:name=>"spacing"!==name&&!name.startsWith("borderDash")&&!name.startsWith("hoverBorderDash")}),_defineProperty(DoughnutController,"overrides",{aspectRatio:1,plugins:{legend:{labels:{generateLabels(chart){const data=chart.data;if(data.labels.length&&data.datasets.length){const{labels:{pointStyle:pointStyle,color:color}}=chart.legend.options;return data.labels.map(((label,i)=>{const style=chart.getDatasetMeta(0).controller.getStyle(i);return{text:label,fillStyle:style.backgroundColor,strokeStyle:style.borderColor,fontColor:color,lineWidth:style.borderWidth,pointStyle:pointStyle,hidden:!chart.getDataVisibility(i),index:i}}))}return[]}},onClick(e,legendItem,legend){legend.chart.toggleDataVisibility(legendItem.index),legend.chart.update()}}}});class LineController extends DatasetController{initialize(){this.enableOptionSharing=!0,this.supportsDecimation=!0,super.initialize()}update(mode){const meta=this._cachedMeta,{dataset:line,data:points=[],_dataset:_dataset}=meta,animationsDisabled=this.chart._animationsDisabled;let{start:start,count:count}=_getStartAndCountOfVisiblePoints(meta,points,animationsDisabled);this._drawStart=start,this._drawCount=count,_scaleRangesChanged(meta)&&(start=0,count=points.length),line._chart=this.chart,line._datasetIndex=this.index,line._decimated=!!_dataset._decimated,line.points=points;const options=this.resolveDatasetElementOptions(mode);this.options.showLine||(options.borderWidth=0),options.segment=this.options.segment,this.updateElement(line,void 0,{animated:!animationsDisabled,options:options},mode),this.updateElements(points,start,count,mode)}updateElements(points,start,count,mode){const reset="reset"===mode,{iScale:iScale,vScale:vScale,_stacked:_stacked,_dataset:_dataset}=this._cachedMeta,{sharedOptions:sharedOptions,includeOptions:includeOptions}=this._getSharedOptions(start,mode),iAxis=iScale.axis,vAxis=vScale.axis,{spanGaps:spanGaps,segment:segment}=this.options,maxGapLength=isNumber(spanGaps)?spanGaps:Number.POSITIVE_INFINITY,directUpdate=this.chart._animationsDisabled||reset||"none"===mode,end=start+count,pointsCount=points.length;let prevParsed=start>0&&this.getParsed(start-1);for(let i=0;i<pointsCount;++i){const point=points[i],properties=directUpdate?point:{};if(i<start||i>=end){properties.skip=!0;continue}const parsed=this.getParsed(i),nullData=isNullOrUndef(parsed[vAxis]),iPixel=properties[iAxis]=iScale.getPixelForValue(parsed[iAxis],i),vPixel=properties[vAxis]=reset||nullData?vScale.getBasePixel():vScale.getPixelForValue(_stacked?this.applyStack(vScale,parsed,_stacked):parsed[vAxis],i);properties.skip=isNaN(iPixel)||isNaN(vPixel)||nullData,properties.stop=i>0&&Math.abs(parsed[iAxis]-prevParsed[iAxis])>maxGapLength,segment&&(properties.parsed=parsed,properties.raw=_dataset.data[i]),includeOptions&&(properties.options=sharedOptions||this.resolveDataElementOptions(i,point.active?"active":mode)),directUpdate||this.updateElement(point,i,properties,mode),prevParsed=parsed}}getMaxOverflow(){const meta=this._cachedMeta,dataset=meta.dataset,border=dataset.options&&dataset.options.borderWidth||0,data=meta.data||[];if(!data.length)return border;const firstPoint=data[0].size(this.resolveDataElementOptions(0)),lastPoint=data[data.length-1].size(this.resolveDataElementOptions(data.length-1));return Math.max(border,firstPoint,lastPoint)/2}draw(){const meta=this._cachedMeta;meta.dataset.updateControlPoints(this.chart.chartArea,meta.iScale.axis),super.draw()}}_defineProperty(LineController,"id","line"),_defineProperty(LineController,"defaults",{datasetElementType:"line",dataElementType:"point",showLine:!0,spanGaps:!1}),_defineProperty(LineController,"overrides",{scales:{_index_:{type:"category"},_value_:{type:"linear"}}});class PolarAreaController extends DatasetController{constructor(chart,datasetIndex){super(chart,datasetIndex),this.innerRadius=void 0,this.outerRadius=void 0}getLabelAndValue(index){const meta=this._cachedMeta,chart=this.chart,labels=chart.data.labels||[],value=formatNumber(meta._parsed[index].r,chart.options.locale);return{label:labels[index]||"",value:value}}parseObjectData(meta,data,start,count){return _parseObjectDataRadialScale.bind(this)(meta,data,start,count)}update(mode){const arcs=this._cachedMeta.data;this._updateRadius(),this.updateElements(arcs,0,arcs.length,mode)}getMinMax(){const meta=this._cachedMeta,range={min:Number.POSITIVE_INFINITY,max:Number.NEGATIVE_INFINITY};return meta.data.forEach(((element,index)=>{const parsed=this.getParsed(index).r;!isNaN(parsed)&&this.chart.getDataVisibility(index)&&(parsed<range.min&&(range.min=parsed),parsed>range.max&&(range.max=parsed))})),range}_updateRadius(){const chart=this.chart,chartArea=chart.chartArea,opts=chart.options,minSize=Math.min(chartArea.right-chartArea.left,chartArea.bottom-chartArea.top),outerRadius=Math.max(minSize/2,0),radiusLength=(outerRadius-Math.max(opts.cutoutPercentage?outerRadius/100*opts.cutoutPercentage:1,0))/chart.getVisibleDatasetCount();this.outerRadius=outerRadius-radiusLength*this.index,this.innerRadius=this.outerRadius-radiusLength}updateElements(arcs,start,count,mode){const reset="reset"===mode,chart=this.chart,animationOpts=chart.options.animation,scale=this._cachedMeta.rScale,centerX=scale.xCenter,centerY=scale.yCenter,datasetStartAngle=scale.getIndexAngle(0)-.5*PI;let i,angle=datasetStartAngle;const defaultAngle=360/this.countVisibleElements();for(i=0;i<start;++i)angle+=this._computeAngle(i,mode,defaultAngle);for(i=start;i<start+count;i++){const arc=arcs[i];let startAngle=angle,endAngle=angle+this._computeAngle(i,mode,defaultAngle),outerRadius=chart.getDataVisibility(i)?scale.getDistanceFromCenterForValue(this.getParsed(i).r):0;angle=endAngle,reset&&(animationOpts.animateScale&&(outerRadius=0),animationOpts.animateRotate&&(startAngle=endAngle=datasetStartAngle));const properties={x:centerX,y:centerY,innerRadius:0,outerRadius:outerRadius,startAngle:startAngle,endAngle:endAngle,options:this.resolveDataElementOptions(i,arc.active?"active":mode)};this.updateElement(arc,i,properties,mode)}}countVisibleElements(){const meta=this._cachedMeta;let count=0;return meta.data.forEach(((element,index)=>{!isNaN(this.getParsed(index).r)&&this.chart.getDataVisibility(index)&&count++})),count}_computeAngle(index,mode,defaultAngle){return this.chart.getDataVisibility(index)?toRadians(this.resolveDataElementOptions(index,mode).angle||defaultAngle):0}}_defineProperty(PolarAreaController,"id","polarArea"),_defineProperty(PolarAreaController,"defaults",{dataElementType:"arc",animation:{animateRotate:!0,animateScale:!0},animations:{numbers:{type:"number",properties:["x","y","startAngle","endAngle","innerRadius","outerRadius"]}},indexAxis:"r",startAngle:0}),_defineProperty(PolarAreaController,"overrides",{aspectRatio:1,plugins:{legend:{labels:{generateLabels(chart){const data=chart.data;if(data.labels.length&&data.datasets.length){const{labels:{pointStyle:pointStyle,color:color}}=chart.legend.options;return data.labels.map(((label,i)=>{const style=chart.getDatasetMeta(0).controller.getStyle(i);return{text:label,fillStyle:style.backgroundColor,strokeStyle:style.borderColor,fontColor:color,lineWidth:style.borderWidth,pointStyle:pointStyle,hidden:!chart.getDataVisibility(i),index:i}}))}return[]}},onClick(e,legendItem,legend){legend.chart.toggleDataVisibility(legendItem.index),legend.chart.update()}}},scales:{r:{type:"radialLinear",angleLines:{display:!1},beginAtZero:!0,grid:{circular:!0},pointLabels:{display:!1},startAngle:0}}});class PieController extends DoughnutController{}_defineProperty(PieController,"id","pie"),_defineProperty(PieController,"defaults",{cutout:0,rotation:0,circumference:360,radius:"100%"});class RadarController extends DatasetController{getLabelAndValue(index){const vScale=this._cachedMeta.vScale,parsed=this.getParsed(index);return{label:vScale.getLabels()[index],value:""+vScale.getLabelForValue(parsed[vScale.axis])}}parseObjectData(meta,data,start,count){return _parseObjectDataRadialScale.bind(this)(meta,data,start,count)}update(mode){const meta=this._cachedMeta,line=meta.dataset,points=meta.data||[],labels=meta.iScale.getLabels();if(line.points=points,"resize"!==mode){const options=this.resolveDatasetElementOptions(mode);this.options.showLine||(options.borderWidth=0);const properties={_loop:!0,_fullLoop:labels.length===points.length,options:options};this.updateElement(line,void 0,properties,mode)}this.updateElements(points,0,points.length,mode)}updateElements(points,start,count,mode){const scale=this._cachedMeta.rScale,reset="reset"===mode;for(let i=start;i<start+count;i++){const point=points[i],options=this.resolveDataElementOptions(i,point.active?"active":mode),pointPosition=scale.getPointPositionForValue(i,this.getParsed(i).r),x=reset?scale.xCenter:pointPosition.x,y=reset?scale.yCenter:pointPosition.y,properties={x:x,y:y,angle:pointPosition.angle,skip:isNaN(x)||isNaN(y),options:options};this.updateElement(point,i,properties,mode)}}}_defineProperty(RadarController,"id","radar"),_defineProperty(RadarController,"defaults",{datasetElementType:"line",dataElementType:"point",indexAxis:"r",showLine:!0,elements:{line:{fill:"start"}}}),_defineProperty(RadarController,"overrides",{aspectRatio:1,scales:{r:{type:"radialLinear"}}});class ScatterController extends DatasetController{getLabelAndValue(index){const meta=this._cachedMeta,labels=this.chart.data.labels||[],{xScale:xScale,yScale:yScale}=meta,parsed=this.getParsed(index),x=xScale.getLabelForValue(parsed.x),y=yScale.getLabelForValue(parsed.y);return{label:labels[index]||"",value:"("+x+", "+y+")"}}update(mode){const meta=this._cachedMeta,{data:points=[]}=meta,animationsDisabled=this.chart._animationsDisabled;let{start:start,count:count}=_getStartAndCountOfVisiblePoints(meta,points,animationsDisabled);if(this._drawStart=start,this._drawCount=count,_scaleRangesChanged(meta)&&(start=0,count=points.length),this.options.showLine){this.datasetElementType||this.addElements();const{dataset:line,_dataset:_dataset}=meta;line._chart=this.chart,line._datasetIndex=this.index,line._decimated=!!_dataset._decimated,line.points=points;const options=this.resolveDatasetElementOptions(mode);options.segment=this.options.segment,this.updateElement(line,void 0,{animated:!animationsDisabled,options:options},mode)}else this.datasetElementType&&(delete meta.dataset,this.datasetElementType=!1);this.updateElements(points,start,count,mode)}addElements(){const{showLine:showLine}=this.options;!this.datasetElementType&&showLine&&(this.datasetElementType=this.chart.registry.getElement("line")),super.addElements()}updateElements(points,start,count,mode){const reset="reset"===mode,{iScale:iScale,vScale:vScale,_stacked:_stacked,_dataset:_dataset}=this._cachedMeta,firstOpts=this.resolveDataElementOptions(start,mode),sharedOptions=this.getSharedOptions(firstOpts),includeOptions=this.includeOptions(mode,sharedOptions),iAxis=iScale.axis,vAxis=vScale.axis,{spanGaps:spanGaps,segment:segment}=this.options,maxGapLength=isNumber(spanGaps)?spanGaps:Number.POSITIVE_INFINITY,directUpdate=this.chart._animationsDisabled||reset||"none"===mode;let prevParsed=start>0&&this.getParsed(start-1);for(let i=start;i<start+count;++i){const point=points[i],parsed=this.getParsed(i),properties=directUpdate?point:{},nullData=isNullOrUndef(parsed[vAxis]),iPixel=properties[iAxis]=iScale.getPixelForValue(parsed[iAxis],i),vPixel=properties[vAxis]=reset||nullData?vScale.getBasePixel():vScale.getPixelForValue(_stacked?this.applyStack(vScale,parsed,_stacked):parsed[vAxis],i);properties.skip=isNaN(iPixel)||isNaN(vPixel)||nullData,properties.stop=i>0&&Math.abs(parsed[iAxis]-prevParsed[iAxis])>maxGapLength,segment&&(properties.parsed=parsed,properties.raw=_dataset.data[i]),includeOptions&&(properties.options=sharedOptions||this.resolveDataElementOptions(i,point.active?"active":mode)),directUpdate||this.updateElement(point,i,properties,mode),prevParsed=parsed}this.updateSharedOptions(sharedOptions,mode,firstOpts)}getMaxOverflow(){const meta=this._cachedMeta,data=meta.data||[];if(!this.options.showLine){let max=0;for(let i=data.length-1;i>=0;--i)max=Math.max(max,data[i].size(this.resolveDataElementOptions(i))/2);return max>0&&max}const dataset=meta.dataset,border=dataset.options&&dataset.options.borderWidth||0;if(!data.length)return border;const firstPoint=data[0].size(this.resolveDataElementOptions(0)),lastPoint=data[data.length-1].size(this.resolveDataElementOptions(data.length-1));return Math.max(border,firstPoint,lastPoint)/2}}_defineProperty(ScatterController,"id","scatter"),_defineProperty(ScatterController,"defaults",{datasetElementType:!1,dataElementType:"point",showLine:!1,fill:!1}),_defineProperty(ScatterController,"overrides",{interaction:{mode:"point"},scales:{x:{type:"linear"},y:{type:"linear"}}});var controllers=Object.freeze({__proto__:null,BarController:BarController,BubbleController:BubbleController,DoughnutController:DoughnutController,LineController:LineController,PieController:PieController,PolarAreaController:PolarAreaController,RadarController:RadarController,ScatterController:ScatterController});function parseBorderRadius$1(arc,innerRadius,outerRadius,angleDelta){const o=_readValueToProps(arc.options.borderRadius,["outerStart","outerEnd","innerStart","innerEnd"]),halfThickness=(outerRadius-innerRadius)/2,innerLimit=Math.min(halfThickness,angleDelta*innerRadius/2),computeOuterLimit=val=>{const outerArcLimit=(outerRadius-Math.min(halfThickness,val))*angleDelta/2;return _limitValue(val,0,Math.min(halfThickness,outerArcLimit))};return{outerStart:computeOuterLimit(o.outerStart),outerEnd:computeOuterLimit(o.outerEnd),innerStart:_limitValue(o.innerStart,0,innerLimit),innerEnd:_limitValue(o.innerEnd,0,innerLimit)}}function rThetaToXY(r,theta,x,y){return{x:x+r*Math.cos(theta),y:y+r*Math.sin(theta)}}function pathArc(ctx,element,offset,spacing,end,circular){const{x:x,y:y,startAngle:start,pixelMargin:pixelMargin,innerRadius:innerR}=element,outerRadius=Math.max(element.outerRadius+spacing+offset-pixelMargin,0),innerRadius=innerR>0?innerR+spacing+offset+pixelMargin:0;let spacingOffset=0;const alpha=end-start;if(spacing){const avNogSpacingRadius=((innerR>0?innerR-spacing:0)+(outerRadius>0?outerRadius-spacing:0))/2;spacingOffset=(alpha-(0!==avNogSpacingRadius?alpha*avNogSpacingRadius/(avNogSpacingRadius+spacing):alpha))/2}const angleOffset=(alpha-Math.max(.001,alpha*outerRadius-offset/PI)/outerRadius)/2,startAngle=start+angleOffset+spacingOffset,endAngle=end-angleOffset-spacingOffset,{outerStart:outerStart,outerEnd:outerEnd,innerStart:innerStart,innerEnd:innerEnd}=parseBorderRadius$1(element,innerRadius,outerRadius,endAngle-startAngle),outerStartAdjustedRadius=outerRadius-outerStart,outerEndAdjustedRadius=outerRadius-outerEnd,outerStartAdjustedAngle=startAngle+outerStart/outerStartAdjustedRadius,outerEndAdjustedAngle=endAngle-outerEnd/outerEndAdjustedRadius,innerStartAdjustedRadius=innerRadius+innerStart,innerEndAdjustedRadius=innerRadius+innerEnd,innerStartAdjustedAngle=startAngle+innerStart/innerStartAdjustedRadius,innerEndAdjustedAngle=endAngle-innerEnd/innerEndAdjustedRadius;if(ctx.beginPath(),circular){const outerMidAdjustedAngle=(outerStartAdjustedAngle+outerEndAdjustedAngle)/2;if(ctx.arc(x,y,outerRadius,outerStartAdjustedAngle,outerMidAdjustedAngle),ctx.arc(x,y,outerRadius,outerMidAdjustedAngle,outerEndAdjustedAngle),outerEnd>0){const pCenter=rThetaToXY(outerEndAdjustedRadius,outerEndAdjustedAngle,x,y);ctx.arc(pCenter.x,pCenter.y,outerEnd,outerEndAdjustedAngle,endAngle+HALF_PI)}const p4=rThetaToXY(innerEndAdjustedRadius,endAngle,x,y);if(ctx.lineTo(p4.x,p4.y),innerEnd>0){const pCenter=rThetaToXY(innerEndAdjustedRadius,innerEndAdjustedAngle,x,y);ctx.arc(pCenter.x,pCenter.y,innerEnd,endAngle+HALF_PI,innerEndAdjustedAngle+Math.PI)}const innerMidAdjustedAngle=(endAngle-innerEnd/innerRadius+(startAngle+innerStart/innerRadius))/2;if(ctx.arc(x,y,innerRadius,endAngle-innerEnd/innerRadius,innerMidAdjustedAngle,!0),ctx.arc(x,y,innerRadius,innerMidAdjustedAngle,startAngle+innerStart/innerRadius,!0),innerStart>0){const pCenter=rThetaToXY(innerStartAdjustedRadius,innerStartAdjustedAngle,x,y);ctx.arc(pCenter.x,pCenter.y,innerStart,innerStartAdjustedAngle+Math.PI,startAngle-HALF_PI)}const p8=rThetaToXY(outerStartAdjustedRadius,startAngle,x,y);if(ctx.lineTo(p8.x,p8.y),outerStart>0){const pCenter=rThetaToXY(outerStartAdjustedRadius,outerStartAdjustedAngle,x,y);ctx.arc(pCenter.x,pCenter.y,outerStart,startAngle-HALF_PI,outerStartAdjustedAngle)}}else{ctx.moveTo(x,y);const outerStartX=Math.cos(outerStartAdjustedAngle)*outerRadius+x,outerStartY=Math.sin(outerStartAdjustedAngle)*outerRadius+y;ctx.lineTo(outerStartX,outerStartY);const outerEndX=Math.cos(outerEndAdjustedAngle)*outerRadius+x,outerEndY=Math.sin(outerEndAdjustedAngle)*outerRadius+y;ctx.lineTo(outerEndX,outerEndY)}ctx.closePath()}function drawBorder(ctx,element,offset,spacing,circular){const{fullCircles:fullCircles,startAngle:startAngle,circumference:circumference,options:options}=element,{borderWidth:borderWidth,borderJoinStyle:borderJoinStyle,borderDash:borderDash,borderDashOffset:borderDashOffset}=options,inner="inner"===options.borderAlign;if(!borderWidth)return;ctx.setLineDash(borderDash||[]),ctx.lineDashOffset=borderDashOffset,inner?(ctx.lineWidth=2*borderWidth,ctx.lineJoin=borderJoinStyle||"round"):(ctx.lineWidth=borderWidth,ctx.lineJoin=borderJoinStyle||"bevel");let endAngle=element.endAngle;if(fullCircles){pathArc(ctx,element,offset,spacing,endAngle,circular);for(let i=0;i<fullCircles;++i)ctx.stroke();isNaN(circumference)||(endAngle=startAngle+(circumference%TAU||TAU))}inner&&function(ctx,element,endAngle){const{startAngle:startAngle,pixelMargin:pixelMargin,x:x,y:y,outerRadius:outerRadius,innerRadius:innerRadius}=element;let angleMargin=pixelMargin/outerRadius;ctx.beginPath(),ctx.arc(x,y,outerRadius,startAngle-angleMargin,endAngle+angleMargin),innerRadius>pixelMargin?(angleMargin=pixelMargin/innerRadius,ctx.arc(x,y,innerRadius,endAngle+angleMargin,startAngle-angleMargin,!0)):ctx.arc(x,y,pixelMargin,endAngle+HALF_PI,startAngle-HALF_PI),ctx.closePath(),ctx.clip()}(ctx,element,endAngle),fullCircles||(pathArc(ctx,element,offset,spacing,endAngle,circular),ctx.stroke())}class ArcElement extends Element{constructor(cfg){super(),_defineProperty(this,"circumference",void 0),_defineProperty(this,"endAngle",void 0),_defineProperty(this,"fullCircles",void 0),_defineProperty(this,"innerRadius",void 0),_defineProperty(this,"outerRadius",void 0),_defineProperty(this,"pixelMargin",void 0),_defineProperty(this,"startAngle",void 0),this.options=void 0,this.circumference=void 0,this.startAngle=void 0,this.endAngle=void 0,this.innerRadius=void 0,this.outerRadius=void 0,this.pixelMargin=0,this.fullCircles=0,cfg&&Object.assign(this,cfg)}inRange(chartX,chartY,useFinalPosition){const point=this.getProps(["x","y"],useFinalPosition),{angle:angle,distance:distance}=getAngleFromPoint(point,{x:chartX,y:chartY}),{startAngle:startAngle,endAngle:endAngle,innerRadius:innerRadius,outerRadius:outerRadius,circumference:circumference}=this.getProps(["startAngle","endAngle","innerRadius","outerRadius","circumference"],useFinalPosition),rAdjust=(this.options.spacing+this.options.borderWidth)/2,betweenAngles=valueOrDefault(circumference,endAngle-startAngle)>=TAU||_angleBetween(angle,startAngle,endAngle),withinRadius=_isBetween(distance,innerRadius+rAdjust,outerRadius+rAdjust);return betweenAngles&&withinRadius}getCenterPoint(useFinalPosition){const{x:x,y:y,startAngle:startAngle,endAngle:endAngle,innerRadius:innerRadius,outerRadius:outerRadius}=this.getProps(["x","y","startAngle","endAngle","innerRadius","outerRadius"],useFinalPosition),{offset:offset,spacing:spacing}=this.options,halfAngle=(startAngle+endAngle)/2,halfRadius=(innerRadius+outerRadius+spacing+offset)/2;return{x:x+Math.cos(halfAngle)*halfRadius,y:y+Math.sin(halfAngle)*halfRadius}}tooltipPosition(useFinalPosition){return this.getCenterPoint(useFinalPosition)}draw(ctx){const{options:options,circumference:circumference}=this,offset=(options.offset||0)/4,spacing=(options.spacing||0)/2,circular=options.circular;if(this.pixelMargin="inner"===options.borderAlign?.33:0,this.fullCircles=circumference>TAU?Math.floor(circumference/TAU):0,0===circumference||this.innerRadius<0||this.outerRadius<0)return;ctx.save();const halfAngle=(this.startAngle+this.endAngle)/2;ctx.translate(Math.cos(halfAngle)*offset,Math.sin(halfAngle)*offset);const radiusOffset=offset*(1-Math.sin(Math.min(PI,circumference||0)));ctx.fillStyle=options.backgroundColor,ctx.strokeStyle=options.borderColor,function(ctx,element,offset,spacing,circular){const{fullCircles:fullCircles,startAngle:startAngle,circumference:circumference}=element;let endAngle=element.endAngle;if(fullCircles){pathArc(ctx,element,offset,spacing,endAngle,circular);for(let i=0;i<fullCircles;++i)ctx.fill();isNaN(circumference)||(endAngle=startAngle+(circumference%TAU||TAU))}pathArc(ctx,element,offset,spacing,endAngle,circular),ctx.fill()}(ctx,this,radiusOffset,spacing,circular),drawBorder(ctx,this,radiusOffset,spacing,circular),ctx.restore()}}function setStyle(ctx,options){let style=arguments.length>2&&void 0!==arguments[2]?arguments[2]:options;ctx.lineCap=valueOrDefault(style.borderCapStyle,options.borderCapStyle),ctx.setLineDash(valueOrDefault(style.borderDash,options.borderDash)),ctx.lineDashOffset=valueOrDefault(style.borderDashOffset,options.borderDashOffset),ctx.lineJoin=valueOrDefault(style.borderJoinStyle,options.borderJoinStyle),ctx.lineWidth=valueOrDefault(style.borderWidth,options.borderWidth),ctx.strokeStyle=valueOrDefault(style.borderColor,options.borderColor)}function lineTo(ctx,previous,target){ctx.lineTo(target.x,target.y)}function pathVars(points,segment){let params=arguments.length>2&&void 0!==arguments[2]?arguments[2]:{};const count=points.length,{start:paramsStart=0,end:paramsEnd=count-1}=params,{start:segmentStart,end:segmentEnd}=segment,start=Math.max(paramsStart,segmentStart),end=Math.min(paramsEnd,segmentEnd),outside=paramsStart<segmentStart&&paramsEnd<segmentStart||paramsStart>segmentEnd&&paramsEnd>segmentEnd;return{count:count,start:start,loop:segment.loop,ilen:end<start&&!outside?count+end-start:end-start}}function pathSegment(ctx,line,segment,params){const{points:points,options:options}=line,{count:count,start:start,loop:loop,ilen:ilen}=pathVars(points,segment,params),lineMethod=function(options){return options.stepped?_steppedLineTo:options.tension||"monotone"===options.cubicInterpolationMode?_bezierCurveTo:lineTo}(options);let i,point,prev,{move:move=!0,reverse:reverse}=params||{};for(i=0;i<=ilen;++i)point=points[(start+(reverse?ilen-i:i))%count],point.skip||(move?(ctx.moveTo(point.x,point.y),move=!1):lineMethod(ctx,prev,point,reverse,options.stepped),prev=point);return loop&&(point=points[(start+(reverse?ilen:0))%count],lineMethod(ctx,prev,point,reverse,options.stepped)),!!loop}function fastPathSegment(ctx,line,segment,params){const points=line.points,{count:count,start:start,ilen:ilen}=pathVars(points,segment,params),{move:move=!0,reverse:reverse}=params||{};let i,point,prevX,minY,maxY,lastY,avgX=0,countX=0;const pointIndex=index=>(start+(reverse?ilen-index:index))%count,drawX=()=>{minY!==maxY&&(ctx.lineTo(avgX,maxY),ctx.lineTo(avgX,minY),ctx.lineTo(avgX,lastY))};for(move&&(point=points[pointIndex(0)],ctx.moveTo(point.x,point.y)),i=0;i<=ilen;++i){if(point=points[pointIndex(i)],point.skip)continue;const x=point.x,y=point.y,truncX=0|x;truncX===prevX?(y<minY?minY=y:y>maxY&&(maxY=y),avgX=(countX*avgX+x)/++countX):(drawX(),ctx.lineTo(x,y),prevX=truncX,countX=0,minY=maxY=y),lastY=y}drawX()}function _getSegmentMethod(line){const opts=line.options,borderDash=opts.borderDash&&opts.borderDash.length;return line._decimated||line._loop||opts.tension||"monotone"===opts.cubicInterpolationMode||opts.stepped||borderDash?pathSegment:fastPathSegment}_defineProperty(ArcElement,"id","arc"),_defineProperty(ArcElement,"defaults",{borderAlign:"center",borderColor:"#fff",borderDash:[],borderDashOffset:0,borderJoinStyle:void 0,borderRadius:0,borderWidth:2,offset:0,spacing:0,angle:void 0,circular:!0}),_defineProperty(ArcElement,"defaultRoutes",{backgroundColor:"backgroundColor"}),_defineProperty(ArcElement,"descriptors",{_scriptable:!0,_indexable:name=>"borderDash"!==name});const usePath2D="function"==typeof Path2D;function draw(ctx,line,start,count){usePath2D&&!line.options.segment?function(ctx,line,start,count){let path=line._path;path||(path=line._path=new Path2D,line.path(path,start,count)&&path.closePath()),setStyle(ctx,line.options),ctx.stroke(path)}(ctx,line,start,count):function(ctx,line,start,count){const{segments:segments,options:options}=line,segmentMethod=_getSegmentMethod(line);for(const segment of segments)setStyle(ctx,options,segment.style),ctx.beginPath(),segmentMethod(ctx,line,segment,{start:start,end:start+count-1})&&ctx.closePath(),ctx.stroke()}(ctx,line,start,count)}class LineElement extends Element{constructor(cfg){super(),this.animated=!0,this.options=void 0,this._chart=void 0,this._loop=void 0,this._fullLoop=void 0,this._path=void 0,this._points=void 0,this._segments=void 0,this._decimated=!1,this._pointsUpdated=!1,this._datasetIndex=void 0,cfg&&Object.assign(this,cfg)}updateControlPoints(chartArea,indexAxis){const options=this.options;if((options.tension||"monotone"===options.cubicInterpolationMode)&&!options.stepped&&!this._pointsUpdated){const loop=options.spanGaps?this._loop:this._fullLoop;_updateBezierControlPoints(this._points,options,chartArea,loop,indexAxis),this._pointsUpdated=!0}}set points(points){this._points=points,delete this._segments,delete this._path,this._pointsUpdated=!1}get points(){return this._points}get segments(){return this._segments||(this._segments=_computeSegments(this,this.options.segment))}first(){const segments=this.segments,points=this.points;return segments.length&&points[segments[0].start]}last(){const segments=this.segments,points=this.points,count=segments.length;return count&&points[segments[count-1].end]}interpolate(point,property){const options=this.options,value=point[property],points=this.points,segments=_boundSegments(this,{property:property,start:value,end:value});if(!segments.length)return;const result=[],_interpolate=function(options){return options.stepped?_steppedInterpolation:options.tension||"monotone"===options.cubicInterpolationMode?_bezierInterpolation:_pointInLine}(options);let i,ilen;for(i=0,ilen=segments.length;i<ilen;++i){const{start:start,end:end}=segments[i],p1=points[start],p2=points[end];if(p1===p2){result.push(p1);continue}const interpolated=_interpolate(p1,p2,Math.abs((value-p1[property])/(p2[property]-p1[property])),options.stepped);interpolated[property]=point[property],result.push(interpolated)}return 1===result.length?result[0]:result}pathSegment(ctx,segment,params){return _getSegmentMethod(this)(ctx,this,segment,params)}path(ctx,start,count){const segments=this.segments,segmentMethod=_getSegmentMethod(this);let loop=this._loop;start=start||0,count=count||this.points.length-start;for(const segment of segments)loop&=segmentMethod(ctx,this,segment,{start:start,end:start+count-1});return!!loop}draw(ctx,chartArea,start,count){const options=this.options||{};(this.points||[]).length&&options.borderWidth&&(ctx.save(),draw(ctx,this,start,count),ctx.restore()),this.animated&&(this._pointsUpdated=!1,this._path=void 0)}}function inRange$1(el,pos,axis,useFinalPosition){const options=el.options,{[axis]:value}=el.getProps([axis],useFinalPosition);return Math.abs(pos-value)<options.radius+options.hitRadius}_defineProperty(LineElement,"id","line"),_defineProperty(LineElement,"defaults",{borderCapStyle:"butt",borderDash:[],borderDashOffset:0,borderJoinStyle:"miter",borderWidth:3,capBezierPoints:!0,cubicInterpolationMode:"default",fill:!1,spanGaps:!1,stepped:!1,tension:0}),_defineProperty(LineElement,"defaultRoutes",{backgroundColor:"backgroundColor",borderColor:"borderColor"}),_defineProperty(LineElement,"descriptors",{_scriptable:!0,_indexable:name=>"borderDash"!==name&&"fill"!==name});class PointElement extends Element{constructor(cfg){super(),_defineProperty(this,"parsed",void 0),_defineProperty(this,"skip",void 0),_defineProperty(this,"stop",void 0),this.options=void 0,this.parsed=void 0,this.skip=void 0,this.stop=void 0,cfg&&Object.assign(this,cfg)}inRange(mouseX,mouseY,useFinalPosition){const options=this.options,{x:x,y:y}=this.getProps(["x","y"],useFinalPosition);return Math.pow(mouseX-x,2)+Math.pow(mouseY-y,2)<Math.pow(options.hitRadius+options.radius,2)}inXRange(mouseX,useFinalPosition){return inRange$1(this,mouseX,"x",useFinalPosition)}inYRange(mouseY,useFinalPosition){return inRange$1(this,mouseY,"y",useFinalPosition)}getCenterPoint(useFinalPosition){const{x:x,y:y}=this.getProps(["x","y"],useFinalPosition);return{x:x,y:y}}size(options){let radius=(options=options||this.options||{}).radius||0;return radius=Math.max(radius,radius&&options.hoverRadius||0),2*(radius+(radius&&options.borderWidth||0))}draw(ctx,area){const options=this.options;this.skip||options.radius<.1||!_isPointInArea(this,area,this.size(options)/2)||(ctx.strokeStyle=options.borderColor,ctx.lineWidth=options.borderWidth,ctx.fillStyle=options.backgroundColor,drawPoint(ctx,options,this.x,this.y))}getRange(){const options=this.options||{};return options.radius+options.hitRadius}}function getBarBounds(bar,useFinalPosition){const{x:x,y:y,base:base,width:width,height:height}=bar.getProps(["x","y","base","width","height"],useFinalPosition);let left,right,top,bottom,half;return bar.horizontal?(half=height/2,left=Math.min(x,base),right=Math.max(x,base),top=y-half,bottom=y+half):(half=width/2,left=x-half,right=x+half,top=Math.min(y,base),bottom=Math.max(y,base)),{left:left,top:top,right:right,bottom:bottom}}function skipOrLimit(skip,value,min,max){return skip?0:_limitValue(value,min,max)}function boundingRects(bar){const bounds=getBarBounds(bar),width=bounds.right-bounds.left,height=bounds.bottom-bounds.top,border=function(bar,maxW,maxH){const value=bar.options.borderWidth,skip=bar.borderSkipped,o=toTRBL(value);return{t:skipOrLimit(skip.top,o.top,0,maxH),r:skipOrLimit(skip.right,o.right,0,maxW),b:skipOrLimit(skip.bottom,o.bottom,0,maxH),l:skipOrLimit(skip.left,o.left,0,maxW)}}(bar,width/2,height/2),radius=function(bar,maxW,maxH){const{enableBorderRadius:enableBorderRadius}=bar.getProps(["enableBorderRadius"]),value=bar.options.borderRadius,o=toTRBLCorners(value),maxR=Math.min(maxW,maxH),skip=bar.borderSkipped,enableBorder=enableBorderRadius||isObject(value);return{topLeft:skipOrLimit(!enableBorder||skip.top||skip.left,o.topLeft,0,maxR),topRight:skipOrLimit(!enableBorder||skip.top||skip.right,o.topRight,0,maxR),bottomLeft:skipOrLimit(!enableBorder||skip.bottom||skip.left,o.bottomLeft,0,maxR),bottomRight:skipOrLimit(!enableBorder||skip.bottom||skip.right,o.bottomRight,0,maxR)}}(bar,width/2,height/2);return{outer:{x:bounds.left,y:bounds.top,w:width,h:height,radius:radius},inner:{x:bounds.left+border.l,y:bounds.top+border.t,w:width-border.l-border.r,h:height-border.t-border.b,radius:{topLeft:Math.max(0,radius.topLeft-Math.max(border.t,border.l)),topRight:Math.max(0,radius.topRight-Math.max(border.t,border.r)),bottomLeft:Math.max(0,radius.bottomLeft-Math.max(border.b,border.l)),bottomRight:Math.max(0,radius.bottomRight-Math.max(border.b,border.r))}}}}function inRange(bar,x,y,useFinalPosition){const skipX=null===x,skipY=null===y,bounds=bar&&!(skipX&&skipY)&&getBarBounds(bar,useFinalPosition);return bounds&&(skipX||_isBetween(x,bounds.left,bounds.right))&&(skipY||_isBetween(y,bounds.top,bounds.bottom))}function addNormalRectPath(ctx,rect){ctx.rect(rect.x,rect.y,rect.w,rect.h)}function inflateRect(rect,amount){let refRect=arguments.length>2&&void 0!==arguments[2]?arguments[2]:{};const x=rect.x!==refRect.x?-amount:0,y=rect.y!==refRect.y?-amount:0,w=(rect.x+rect.w!==refRect.x+refRect.w?amount:0)-x,h=(rect.y+rect.h!==refRect.y+refRect.h?amount:0)-y;return{x:rect.x+x,y:rect.y+y,w:rect.w+w,h:rect.h+h,radius:rect.radius}}_defineProperty(PointElement,"id","point"),_defineProperty(PointElement,"defaults",{borderWidth:1,hitRadius:1,hoverBorderWidth:1,hoverRadius:4,pointStyle:"circle",radius:3,rotation:0}),_defineProperty(PointElement,"defaultRoutes",{backgroundColor:"backgroundColor",borderColor:"borderColor"});class BarElement extends Element{constructor(cfg){super(),this.options=void 0,this.horizontal=void 0,this.base=void 0,this.width=void 0,this.height=void 0,this.inflateAmount=void 0,cfg&&Object.assign(this,cfg)}draw(ctx){const{inflateAmount:inflateAmount,options:{borderColor:borderColor,backgroundColor:backgroundColor}}=this,{inner:inner,outer:outer}=boundingRects(this),addRectPath=(radius=outer.radius).topLeft||radius.topRight||radius.bottomLeft||radius.bottomRight?addRoundedRectPath:addNormalRectPath;var radius;ctx.save(),outer.w===inner.w&&outer.h===inner.h||(ctx.beginPath(),addRectPath(ctx,inflateRect(outer,inflateAmount,inner)),ctx.clip(),addRectPath(ctx,inflateRect(inner,-inflateAmount,outer)),ctx.fillStyle=borderColor,ctx.fill("evenodd")),ctx.beginPath(),addRectPath(ctx,inflateRect(inner,inflateAmount)),ctx.fillStyle=backgroundColor,ctx.fill(),ctx.restore()}inRange(mouseX,mouseY,useFinalPosition){return inRange(this,mouseX,mouseY,useFinalPosition)}inXRange(mouseX,useFinalPosition){return inRange(this,mouseX,null,useFinalPosition)}inYRange(mouseY,useFinalPosition){return inRange(this,null,mouseY,useFinalPosition)}getCenterPoint(useFinalPosition){const{x:x,y:y,base:base,horizontal:horizontal}=this.getProps(["x","y","base","horizontal"],useFinalPosition);return{x:horizontal?(x+base)/2:x,y:horizontal?y:(y+base)/2}}getRange(axis){return"x"===axis?this.width/2:this.height/2}}_defineProperty(BarElement,"id","bar"),_defineProperty(BarElement,"defaults",{borderSkipped:"start",borderWidth:0,borderRadius:0,inflateAmount:"auto",pointStyle:void 0}),_defineProperty(BarElement,"defaultRoutes",{backgroundColor:"backgroundColor",borderColor:"borderColor"});var elements=Object.freeze({__proto__:null,ArcElement:ArcElement,BarElement:BarElement,LineElement:LineElement,PointElement:PointElement});function findOrAddLabel(labels,raw,index,addedLabels){const first=labels.indexOf(raw);return-1===first?((labels,raw,index,addedLabels)=>("string"==typeof raw?(index=labels.push(raw)-1,addedLabels.unshift({index:index,label:raw})):isNaN(raw)&&(index=null),index))(labels,raw,index,addedLabels):first!==labels.lastIndexOf(raw)?index:first}function _getLabelForValue(value){const labels=this.getLabels();return value>=0&&value<labels.length?labels[value]:value}class CategoryScale extends Scale{constructor(cfg){super(cfg),this._startValue=void 0,this._valueRange=0,this._addedLabels=[]}init(scaleOptions){const added=this._addedLabels;if(added.length){const labels=this.getLabels();for(const{index:index,label:label}of added)labels[index]===label&&labels.splice(index,1);this._addedLabels=[]}super.init(scaleOptions)}parse(raw,index){if(isNullOrUndef(raw))return null;const labels=this.getLabels();return((index,max)=>null===index?null:_limitValue(Math.round(index),0,max))(index=isFinite(index)&&labels[index]===raw?index:findOrAddLabel(labels,raw,valueOrDefault(index,raw),this._addedLabels),labels.length-1)}determineDataLimits(){const{minDefined:minDefined,maxDefined:maxDefined}=this.getUserBounds();let{min:min,max:max}=this.getMinMax(!0);"ticks"===this.options.bounds&&(minDefined||(min=0),maxDefined||(max=this.getLabels().length-1)),this.min=min,this.max=max}buildTicks(){const min=this.min,max=this.max,offset=this.options.offset,ticks=[];let labels=this.getLabels();labels=0===min&&max===labels.length-1?labels:labels.slice(min,max+1),this._valueRange=Math.max(labels.length-(offset?0:1),1),this._startValue=this.min-(offset?.5:0);for(let value=min;value<=max;value++)ticks.push({value:value});return ticks}getLabelForValue(value){return _getLabelForValue.call(this,value)}configure(){super.configure(),this.isHorizontal()||(this._reversePixels=!this._reversePixels)}getPixelForValue(value){return"number"!=typeof value&&(value=this.parse(value)),null===value?NaN:this.getPixelForDecimal((value-this._startValue)/this._valueRange)}getPixelForTick(index){const ticks=this.ticks;return index<0||index>ticks.length-1?null:this.getPixelForValue(ticks[index].value)}getValueForPixel(pixel){return Math.round(this._startValue+this.getDecimalForPixel(pixel)*this._valueRange)}getBasePixel(){return this.bottom}}function relativeLabelSize(value,minSpacing,_ref6){let{horizontal:horizontal,minRotation:minRotation}=_ref6;const rad=toRadians(minRotation),ratio=(horizontal?Math.sin(rad):Math.cos(rad))||.001,length=.75*minSpacing*(""+value).length;return Math.min(minSpacing/ratio,length)}_defineProperty(CategoryScale,"id","category"),_defineProperty(CategoryScale,"defaults",{ticks:{callback:_getLabelForValue}});class LinearScaleBase extends Scale{constructor(cfg){super(cfg),this.start=void 0,this.end=void 0,this._startValue=void 0,this._endValue=void 0,this._valueRange=0}parse(raw,index){return isNullOrUndef(raw)||("number"==typeof raw||raw instanceof Number)&&!isFinite(+raw)?null:+raw}handleTickRangeOptions(){const{beginAtZero:beginAtZero}=this.options,{minDefined:minDefined,maxDefined:maxDefined}=this.getUserBounds();let{min:min,max:max}=this;const setMin=v=>min=minDefined?min:v,setMax=v=>max=maxDefined?max:v;if(beginAtZero){const minSign=sign(min),maxSign=sign(max);minSign<0&&maxSign<0?setMax(0):minSign>0&&maxSign>0&&setMin(0)}if(min===max){let offset=0===max?1:Math.abs(.05*max);setMax(max+offset),beginAtZero||setMin(min-offset)}this.min=min,this.max=max}getTickLimit(){const tickOpts=this.options.ticks;let maxTicks,{maxTicksLimit:maxTicksLimit,stepSize:stepSize}=tickOpts;return stepSize?(maxTicks=Math.ceil(this.max/stepSize)-Math.floor(this.min/stepSize)+1,maxTicks>1e3&&(console.warn("scales.".concat(this.id,".ticks.stepSize: ").concat(stepSize," would result generating up to ").concat(maxTicks," ticks. Limiting to 1000.")),maxTicks=1e3)):(maxTicks=this.computeTickLimit(),maxTicksLimit=maxTicksLimit||11),maxTicksLimit&&(maxTicks=Math.min(maxTicksLimit,maxTicks)),maxTicks}computeTickLimit(){return Number.POSITIVE_INFINITY}buildTicks(){const opts=this.options,tickOpts=opts.ticks;let maxTicks=this.getTickLimit();maxTicks=Math.max(2,maxTicks);const ticks=function(generationOptions,dataRange){const ticks=[],{bounds:bounds,step:step,min:min,max:max,precision:precision,count:count,maxTicks:maxTicks,maxDigits:maxDigits,includeBounds:includeBounds}=generationOptions,unit=step||1,maxSpaces=maxTicks-1,{min:rmin,max:rmax}=dataRange,minDefined=!isNullOrUndef(min),maxDefined=!isNullOrUndef(max),countDefined=!isNullOrUndef(count),minSpacing=(rmax-rmin)/(maxDigits+1);let factor,niceMin,niceMax,numSpaces,spacing=niceNum((rmax-rmin)/maxSpaces/unit)*unit;if(spacing<1e-14&&!minDefined&&!maxDefined)return[{value:rmin},{value:rmax}];numSpaces=Math.ceil(rmax/spacing)-Math.floor(rmin/spacing),numSpaces>maxSpaces&&(spacing=niceNum(numSpaces*spacing/maxSpaces/unit)*unit),isNullOrUndef(precision)||(factor=Math.pow(10,precision),spacing=Math.ceil(spacing*factor)/factor),"ticks"===bounds?(niceMin=Math.floor(rmin/spacing)*spacing,niceMax=Math.ceil(rmax/spacing)*spacing):(niceMin=rmin,niceMax=rmax),minDefined&&maxDefined&&step&&almostWhole((max-min)/step,spacing/1e3)?(numSpaces=Math.round(Math.min((max-min)/spacing,maxTicks)),spacing=(max-min)/numSpaces,niceMin=min,niceMax=max):countDefined?(niceMin=minDefined?min:niceMin,niceMax=maxDefined?max:niceMax,numSpaces=count-1,spacing=(niceMax-niceMin)/numSpaces):(numSpaces=(niceMax-niceMin)/spacing,numSpaces=almostEquals(numSpaces,Math.round(numSpaces),spacing/1e3)?Math.round(numSpaces):Math.ceil(numSpaces));const decimalPlaces=Math.max(_decimalPlaces(spacing),_decimalPlaces(niceMin));factor=Math.pow(10,isNullOrUndef(precision)?decimalPlaces:precision),niceMin=Math.round(niceMin*factor)/factor,niceMax=Math.round(niceMax*factor)/factor;let j=0;for(minDefined&&(includeBounds&&niceMin!==min?(ticks.push({value:min}),niceMin<min&&j++,almostEquals(Math.round((niceMin+j*spacing)*factor)/factor,min,relativeLabelSize(min,minSpacing,generationOptions))&&j++):niceMin<min&&j++);j<numSpaces;++j){const tickValue=Math.round((niceMin+j*spacing)*factor)/factor;if(maxDefined&&tickValue>max)break;ticks.push({value:tickValue})}return maxDefined&&includeBounds&&niceMax!==max?ticks.length&&almostEquals(ticks[ticks.length-1].value,max,relativeLabelSize(max,minSpacing,generationOptions))?ticks[ticks.length-1].value=max:ticks.push({value:max}):maxDefined&&niceMax!==max||ticks.push({value:niceMax}),ticks}({maxTicks:maxTicks,bounds:opts.bounds,min:opts.min,max:opts.max,precision:tickOpts.precision,step:tickOpts.stepSize,count:tickOpts.count,maxDigits:this._maxDigits(),horizontal:this.isHorizontal(),minRotation:tickOpts.minRotation||0,includeBounds:!1!==tickOpts.includeBounds},this._range||this);return"ticks"===opts.bounds&&_setMinAndMaxByKey(ticks,this,"value"),opts.reverse?(ticks.reverse(),this.start=this.max,this.end=this.min):(this.start=this.min,this.end=this.max),ticks}configure(){const ticks=this.ticks;let start=this.min,end=this.max;if(super.configure(),this.options.offset&&ticks.length){const offset=(end-start)/Math.max(ticks.length-1,1)/2;start-=offset,end+=offset}this._startValue=start,this._endValue=end,this._valueRange=end-start}getLabelForValue(value){return formatNumber(value,this.chart.options.locale,this.options.ticks.format)}}class LinearScale extends LinearScaleBase{determineDataLimits(){const{min:min,max:max}=this.getMinMax(!0);this.min=isNumberFinite(min)?min:0,this.max=isNumberFinite(max)?max:1,this.handleTickRangeOptions()}computeTickLimit(){const horizontal=this.isHorizontal(),length=horizontal?this.width:this.height,minRotation=toRadians(this.options.ticks.minRotation),ratio=(horizontal?Math.sin(minRotation):Math.cos(minRotation))||.001,tickFont=this._resolveTickFontOptions(0);return Math.ceil(length/Math.min(40,tickFont.lineHeight/ratio))}getPixelForValue(value){return null===value?NaN:this.getPixelForDecimal((value-this._startValue)/this._valueRange)}getValueForPixel(pixel){return this._startValue+this.getDecimalForPixel(pixel)*this._valueRange}}_defineProperty(LinearScale,"id","linear"),_defineProperty(LinearScale,"defaults",{ticks:{callback:Ticks.formatters.numeric}});const log10Floor=v=>Math.floor(log10(v)),changeExponent=(v,m)=>Math.pow(10,log10Floor(v)+m);function isMajor(tickVal){return 1==tickVal/Math.pow(10,log10Floor(tickVal))}function steps(min,max,rangeExp){const rangeStep=Math.pow(10,rangeExp),start=Math.floor(min/rangeStep);return Math.ceil(max/rangeStep)-start}function generateTicks(generationOptions,_ref7){let{min:min,max:max}=_ref7;min=finiteOrDefault(generationOptions.min,min);const ticks=[],minExp=log10Floor(min);let exp=function(min,max){let rangeExp=log10Floor(max-min);for(;steps(min,max,rangeExp)>10;)rangeExp++;for(;steps(min,max,rangeExp)<10;)rangeExp--;return Math.min(rangeExp,log10Floor(min))}(min,max),precision=exp<0?Math.pow(10,Math.abs(exp)):1;const stepSize=Math.pow(10,exp),base=minExp>exp?Math.pow(10,minExp):0,start=Math.round((min-base)*precision)/precision,offset=Math.floor((min-base)/stepSize/10)*stepSize*10;let significand=Math.floor((start-offset)/Math.pow(10,exp)),value=finiteOrDefault(generationOptions.min,Math.round((base+offset+significand*Math.pow(10,exp))*precision)/precision);for(;value<max;)ticks.push({value:value,major:isMajor(value),significand:significand}),significand>=10?significand=significand<15?15:20:significand++,significand>=20&&(exp++,significand=2,precision=exp>=0?1:precision),value=Math.round((base+offset+significand*Math.pow(10,exp))*precision)/precision;const lastTick=finiteOrDefault(generationOptions.max,value);return ticks.push({value:lastTick,major:isMajor(lastTick),significand:significand}),ticks}class LogarithmicScale extends Scale{constructor(cfg){super(cfg),this.start=void 0,this.end=void 0,this._startValue=void 0,this._valueRange=0}parse(raw,index){const value=LinearScaleBase.prototype.parse.apply(this,[raw,index]);if(0!==value)return isNumberFinite(value)&&value>0?value:null;this._zero=!0}determineDataLimits(){const{min:min,max:max}=this.getMinMax(!0);this.min=isNumberFinite(min)?Math.max(0,min):null,this.max=isNumberFinite(max)?Math.max(0,max):null,this.options.beginAtZero&&(this._zero=!0),this._zero&&this.min!==this._suggestedMin&&!isNumberFinite(this._userMin)&&(this.min=min===changeExponent(this.min,0)?changeExponent(this.min,-1):changeExponent(this.min,0)),this.handleTickRangeOptions()}handleTickRangeOptions(){const{minDefined:minDefined,maxDefined:maxDefined}=this.getUserBounds();let min=this.min,max=this.max;const setMin=v=>min=minDefined?min:v,setMax=v=>max=maxDefined?max:v;min===max&&(min<=0?(setMin(1),setMax(10)):(setMin(changeExponent(min,-1)),setMax(changeExponent(max,1)))),min<=0&&setMin(changeExponent(max,-1)),max<=0&&setMax(changeExponent(min,1)),this.min=min,this.max=max}buildTicks(){const opts=this.options,ticks=generateTicks({min:this._userMin,max:this._userMax},this);return"ticks"===opts.bounds&&_setMinAndMaxByKey(ticks,this,"value"),opts.reverse?(ticks.reverse(),this.start=this.max,this.end=this.min):(this.start=this.min,this.end=this.max),ticks}getLabelForValue(value){return void 0===value?"0":formatNumber(value,this.chart.options.locale,this.options.ticks.format)}configure(){const start=this.min;super.configure(),this._startValue=log10(start),this._valueRange=log10(this.max)-log10(start)}getPixelForValue(value){return void 0!==value&&0!==value||(value=this.min),null===value||isNaN(value)?NaN:this.getPixelForDecimal(value===this.min?0:(log10(value)-this._startValue)/this._valueRange)}getValueForPixel(pixel){const decimal=this.getDecimalForPixel(pixel);return Math.pow(10,this._startValue+decimal*this._valueRange)}}function getTickBackdropHeight(opts){const tickOpts=opts.ticks;if(tickOpts.display&&opts.display){const padding=toPadding(tickOpts.backdropPadding);return valueOrDefault(tickOpts.font&&tickOpts.font.size,defaults.font.size)+padding.height}return 0}function determineLimits(angle,pos,size,min,max){return angle===min||angle===max?{start:pos-size/2,end:pos+size/2}:angle<min||angle>max?{start:pos-size,end:pos}:{start:pos,end:pos+size}}function fitWithPointLabels(scale){const orig={l:scale.left+scale._padding.left,r:scale.right-scale._padding.right,t:scale.top+scale._padding.top,b:scale.bottom-scale._padding.bottom},limits=Object.assign({},orig),labelSizes=[],padding=[],valueCount=scale._pointLabels.length,pointLabelOpts=scale.options.pointLabels,additionalAngle=pointLabelOpts.centerPointLabels?PI/valueCount:0;for(let i=0;i<valueCount;i++){const opts=pointLabelOpts.setContext(scale.getPointLabelContext(i));padding[i]=opts.padding;const pointPosition=scale.getPointPosition(i,scale.drawingArea+padding[i],additionalAngle),plFont=toFont(opts.font),textSize=(ctx=scale.ctx,font=plFont,label=isArray(label=scale._pointLabels[i])?label:[label],{w:_longestText(ctx,font.string,label),h:label.length*font.lineHeight});labelSizes[i]=textSize;const angleRadians=_normalizeAngle(scale.getIndexAngle(i)+additionalAngle),angle=Math.round(toDegrees(angleRadians));updateLimits(limits,orig,angleRadians,determineLimits(angle,pointPosition.x,textSize.w,0,180),determineLimits(angle,pointPosition.y,textSize.h,90,270))}var ctx,font,label;scale.setCenterPoint(orig.l-limits.l,limits.r-orig.r,orig.t-limits.t,limits.b-orig.b),scale._pointLabelItems=function(scale,labelSizes,padding){const items=[],valueCount=scale._pointLabels.length,opts=scale.options,{centerPointLabels:centerPointLabels,display:display}=opts.pointLabels,itemOpts={extra:getTickBackdropHeight(opts)/2,additionalAngle:centerPointLabels?PI/valueCount:0};let area;for(let i=0;i<valueCount;i++){itemOpts.padding=padding[i],itemOpts.size=labelSizes[i];const item=createPointLabelItem(scale,i,itemOpts);items.push(item),"auto"===display&&(item.visible=isNotOverlapped(item,area),item.visible&&(area=item))}return items}(scale,labelSizes,padding)}function updateLimits(limits,orig,angle,hLimits,vLimits){const sin=Math.abs(Math.sin(angle)),cos=Math.abs(Math.cos(angle));let x=0,y=0;hLimits.start<orig.l?(x=(orig.l-hLimits.start)/sin,limits.l=Math.min(limits.l,orig.l-x)):hLimits.end>orig.r&&(x=(hLimits.end-orig.r)/sin,limits.r=Math.max(limits.r,orig.r+x)),vLimits.start<orig.t?(y=(orig.t-vLimits.start)/cos,limits.t=Math.min(limits.t,orig.t-y)):vLimits.end>orig.b&&(y=(vLimits.end-orig.b)/cos,limits.b=Math.max(limits.b,orig.b+y))}function createPointLabelItem(scale,index,itemOpts){const outerDistance=scale.drawingArea,{extra:extra,additionalAngle:additionalAngle,padding:padding,size:size}=itemOpts,pointLabelPosition=scale.getPointPosition(index,outerDistance+extra+padding,additionalAngle),angle=Math.round(toDegrees(_normalizeAngle(pointLabelPosition.angle+HALF_PI))),y=function(y,h,angle){return 90===angle||270===angle?y-=h/2:(angle>270||angle<90)&&(y-=h),y}(pointLabelPosition.y,size.h,angle),textAlign=function(angle){return 0===angle||180===angle?"center":angle<180?"left":"right"}(angle),left=(x=pointLabelPosition.x,w=size.w,"right"===(align=textAlign)?x-=w:"center"===align&&(x-=w/2),x);var x,w,align;return{visible:!0,x:pointLabelPosition.x,y:y,textAlign:textAlign,left:left,top:y,right:left+size.w,bottom:y+size.h}}function isNotOverlapped(item,area){if(!area)return!0;const{left:left,top:top,right:right,bottom:bottom}=item;return!(_isPointInArea({x:left,y:top},area)||_isPointInArea({x:left,y:bottom},area)||_isPointInArea({x:right,y:top},area)||_isPointInArea({x:right,y:bottom},area))}function drawPointLabelBox(ctx,opts,item){const{left:left,top:top,right:right,bottom:bottom}=item,{backdropColor:backdropColor}=opts;if(!isNullOrUndef(backdropColor)){const borderRadius=toTRBLCorners(opts.borderRadius),padding=toPadding(opts.backdropPadding);ctx.fillStyle=backdropColor;const backdropLeft=left-padding.left,backdropTop=top-padding.top,backdropWidth=right-left+padding.width,backdropHeight=bottom-top+padding.height;Object.values(borderRadius).some((v=>0!==v))?(ctx.beginPath(),addRoundedRectPath(ctx,{x:backdropLeft,y:backdropTop,w:backdropWidth,h:backdropHeight,radius:borderRadius}),ctx.fill()):ctx.fillRect(backdropLeft,backdropTop,backdropWidth,backdropHeight)}}function pathRadiusLine(scale,radius,circular,labelCount){const{ctx:ctx}=scale;if(circular)ctx.arc(scale.xCenter,scale.yCenter,radius,0,TAU);else{let pointPosition=scale.getPointPosition(0,radius);ctx.moveTo(pointPosition.x,pointPosition.y);for(let i=1;i<labelCount;i++)pointPosition=scale.getPointPosition(i,radius),ctx.lineTo(pointPosition.x,pointPosition.y)}}_defineProperty(LogarithmicScale,"id","logarithmic"),_defineProperty(LogarithmicScale,"defaults",{ticks:{callback:Ticks.formatters.logarithmic,major:{enabled:!0}}});class RadialLinearScale extends LinearScaleBase{constructor(cfg){super(cfg),this.xCenter=void 0,this.yCenter=void 0,this.drawingArea=void 0,this._pointLabels=[],this._pointLabelItems=[]}setDimensions(){const padding=this._padding=toPadding(getTickBackdropHeight(this.options)/2),w=this.width=this.maxWidth-padding.width,h=this.height=this.maxHeight-padding.height;this.xCenter=Math.floor(this.left+w/2+padding.left),this.yCenter=Math.floor(this.top+h/2+padding.top),this.drawingArea=Math.floor(Math.min(w,h)/2)}determineDataLimits(){const{min:min,max:max}=this.getMinMax(!1);this.min=isNumberFinite(min)&&!isNaN(min)?min:0,this.max=isNumberFinite(max)&&!isNaN(max)?max:0,this.handleTickRangeOptions()}computeTickLimit(){return Math.ceil(this.drawingArea/getTickBackdropHeight(this.options))}generateTickLabels(ticks){LinearScaleBase.prototype.generateTickLabels.call(this,ticks),this._pointLabels=this.getLabels().map(((value,index)=>{const label=callback(this.options.pointLabels.callback,[value,index],this);return label||0===label?label:""})).filter(((v,i)=>this.chart.getDataVisibility(i)))}fit(){const opts=this.options;opts.display&&opts.pointLabels.display?fitWithPointLabels(this):this.setCenterPoint(0,0,0,0)}setCenterPoint(leftMovement,rightMovement,topMovement,bottomMovement){this.xCenter+=Math.floor((leftMovement-rightMovement)/2),this.yCenter+=Math.floor((topMovement-bottomMovement)/2),this.drawingArea-=Math.min(this.drawingArea/2,Math.max(leftMovement,rightMovement,topMovement,bottomMovement))}getIndexAngle(index){return _normalizeAngle(index*(TAU/(this._pointLabels.length||1))+toRadians(this.options.startAngle||0))}getDistanceFromCenterForValue(value){if(isNullOrUndef(value))return NaN;const scalingFactor=this.drawingArea/(this.max-this.min);return this.options.reverse?(this.max-value)*scalingFactor:(value-this.min)*scalingFactor}getValueForDistanceFromCenter(distance){if(isNullOrUndef(distance))return NaN;const scaledDistance=distance/(this.drawingArea/(this.max-this.min));return this.options.reverse?this.max-scaledDistance:this.min+scaledDistance}getPointLabelContext(index){const pointLabels=this._pointLabels||[];if(index>=0&&index<pointLabels.length){const pointLabel=pointLabels[index];return function(parent,index,label){return createContext(parent,{label:label,index:index,type:"pointLabel"})}(this.getContext(),index,pointLabel)}}getPointPosition(index,distanceFromCenter){let additionalAngle=arguments.length>2&&void 0!==arguments[2]?arguments[2]:0;const angle=this.getIndexAngle(index)-HALF_PI+additionalAngle;return{x:Math.cos(angle)*distanceFromCenter+this.xCenter,y:Math.sin(angle)*distanceFromCenter+this.yCenter,angle:angle}}getPointPositionForValue(index,value){return this.getPointPosition(index,this.getDistanceFromCenterForValue(value))}getBasePosition(index){return this.getPointPositionForValue(index||0,this.getBaseValue())}getPointLabelPosition(index){const{left:left,top:top,right:right,bottom:bottom}=this._pointLabelItems[index];return{left:left,top:top,right:right,bottom:bottom}}drawBackground(){const{backgroundColor:backgroundColor,grid:{circular:circular}}=this.options;if(backgroundColor){const ctx=this.ctx;ctx.save(),ctx.beginPath(),pathRadiusLine(this,this.getDistanceFromCenterForValue(this._endValue),circular,this._pointLabels.length),ctx.closePath(),ctx.fillStyle=backgroundColor,ctx.fill(),ctx.restore()}}drawGrid(){const ctx=this.ctx,opts=this.options,{angleLines:angleLines,grid:grid,border:border}=opts,labelCount=this._pointLabels.length;let i,offset,position;if(opts.pointLabels.display&&function(scale,labelCount){const{ctx:ctx,options:{pointLabels:pointLabels}}=scale;for(let i=labelCount-1;i>=0;i--){const item=scale._pointLabelItems[i];if(!item.visible)continue;const optsAtIndex=pointLabels.setContext(scale.getPointLabelContext(i));drawPointLabelBox(ctx,optsAtIndex,item);const plFont=toFont(optsAtIndex.font),{x:x,y:y,textAlign:textAlign}=item;renderText(ctx,scale._pointLabels[i],x,y+plFont.lineHeight/2,plFont,{color:optsAtIndex.color,textAlign:textAlign,textBaseline:"middle"})}}(this,labelCount),grid.display&&this.ticks.forEach(((tick,index)=>{if(0!==index||0===index&&this.min<0){offset=this.getDistanceFromCenterForValue(tick.value);const context=this.getContext(index),optsAtIndex=grid.setContext(context),optsAtIndexBorder=border.setContext(context);!function(scale,gridLineOpts,radius,labelCount,borderOpts){const ctx=scale.ctx,circular=gridLineOpts.circular,{color:color,lineWidth:lineWidth}=gridLineOpts;!circular&&!labelCount||!color||!lineWidth||radius<0||(ctx.save(),ctx.strokeStyle=color,ctx.lineWidth=lineWidth,ctx.setLineDash(borderOpts.dash),ctx.lineDashOffset=borderOpts.dashOffset,ctx.beginPath(),pathRadiusLine(scale,radius,circular,labelCount),ctx.closePath(),ctx.stroke(),ctx.restore())}(this,optsAtIndex,offset,labelCount,optsAtIndexBorder)}})),angleLines.display){for(ctx.save(),i=labelCount-1;i>=0;i--){const optsAtIndex=angleLines.setContext(this.getPointLabelContext(i)),{color:color,lineWidth:lineWidth}=optsAtIndex;lineWidth&&color&&(ctx.lineWidth=lineWidth,ctx.strokeStyle=color,ctx.setLineDash(optsAtIndex.borderDash),ctx.lineDashOffset=optsAtIndex.borderDashOffset,offset=this.getDistanceFromCenterForValue(opts.ticks.reverse?this.min:this.max),position=this.getPointPosition(i,offset),ctx.beginPath(),ctx.moveTo(this.xCenter,this.yCenter),ctx.lineTo(position.x,position.y),ctx.stroke())}ctx.restore()}}drawBorder(){}drawLabels(){const ctx=this.ctx,opts=this.options,tickOpts=opts.ticks;if(!tickOpts.display)return;const startAngle=this.getIndexAngle(0);let offset,width;ctx.save(),ctx.translate(this.xCenter,this.yCenter),ctx.rotate(startAngle),ctx.textAlign="center",ctx.textBaseline="middle",this.ticks.forEach(((tick,index)=>{if(0===index&&this.min>=0&&!opts.reverse)return;const optsAtIndex=tickOpts.setContext(this.getContext(index)),tickFont=toFont(optsAtIndex.font);if(offset=this.getDistanceFromCenterForValue(this.ticks[index].value),optsAtIndex.showLabelBackdrop){ctx.font=tickFont.string,width=ctx.measureText(tick.label).width,ctx.fillStyle=optsAtIndex.backdropColor;const padding=toPadding(optsAtIndex.backdropPadding);ctx.fillRect(-width/2-padding.left,-offset-tickFont.size/2-padding.top,width+padding.width,tickFont.size+padding.height)}renderText(ctx,tick.label,0,-offset,tickFont,{color:optsAtIndex.color,strokeColor:optsAtIndex.textStrokeColor,strokeWidth:optsAtIndex.textStrokeWidth})})),ctx.restore()}drawTitle(){}}_defineProperty(RadialLinearScale,"id","radialLinear"),_defineProperty(RadialLinearScale,"defaults",{display:!0,animate:!0,position:"chartArea",angleLines:{display:!0,lineWidth:1,borderDash:[],borderDashOffset:0},grid:{circular:!1},startAngle:0,ticks:{showLabelBackdrop:!0,callback:Ticks.formatters.numeric},pointLabels:{backdropColor:void 0,backdropPadding:2,display:!0,font:{size:10},callback:label=>label,padding:5,centerPointLabels:!1}}),_defineProperty(RadialLinearScale,"defaultRoutes",{"angleLines.color":"borderColor","pointLabels.color":"color","ticks.color":"color"}),_defineProperty(RadialLinearScale,"descriptors",{angleLines:{_fallback:"grid"}});const INTERVALS={millisecond:{common:!0,size:1,steps:1e3},second:{common:!0,size:1e3,steps:60},minute:{common:!0,size:6e4,steps:60},hour:{common:!0,size:36e5,steps:24},day:{common:!0,size:864e5,steps:30},week:{common:!1,size:6048e5,steps:4},month:{common:!0,size:2628e6,steps:12},quarter:{common:!1,size:7884e6,steps:4},year:{common:!0,size:3154e7}},UNITS=Object.keys(INTERVALS);function sorter(a,b){return a-b}function parse(scale,input){if(isNullOrUndef(input))return null;const adapter=scale._adapter,{parser:parser,round:round,isoWeekday:isoWeekday}=scale._parseOpts;let value=input;return"function"==typeof parser&&(value=parser(value)),isNumberFinite(value)||(value="string"==typeof parser?adapter.parse(value,parser):adapter.parse(value)),null===value?null:(round&&(value="week"!==round||!isNumber(isoWeekday)&&!0!==isoWeekday?adapter.startOf(value,round):adapter.startOf(value,"isoWeek",isoWeekday)),+value)}function determineUnitForAutoTicks(minUnit,min,max,capacity){const ilen=UNITS.length;for(let i=UNITS.indexOf(minUnit);i<ilen-1;++i){const interval=INTERVALS[UNITS[i]],factor=interval.steps?interval.steps:Number.MAX_SAFE_INTEGER;if(interval.common&&Math.ceil((max-min)/(factor*interval.size))<=capacity)return UNITS[i]}return UNITS[ilen-1]}function addTick(ticks,time,timestamps){if(timestamps){if(timestamps.length){const{lo:lo,hi:hi}=_lookup(timestamps,time);ticks[timestamps[lo]>=time?timestamps[lo]:timestamps[hi]]=!0}}else ticks[time]=!0}function ticksFromTimestamps(scale,values,majorUnit){const ticks=[],map={},ilen=values.length;let i,value;for(i=0;i<ilen;++i)value=values[i],map[value]=i,ticks.push({value:value,major:!1});return 0!==ilen&&majorUnit?function(scale,ticks,map,majorUnit){const adapter=scale._adapter,first=+adapter.startOf(ticks[0].value,majorUnit),last=ticks[ticks.length-1].value;let major,index;for(major=first;major<=last;major=+adapter.add(major,1,majorUnit))index=map[major],index>=0&&(ticks[index].major=!0);return ticks}(scale,ticks,map,majorUnit):ticks}class TimeScale extends Scale{constructor(props){super(props),this._cache={data:[],labels:[],all:[]},this._unit="day",this._majorUnit=void 0,this._offsets={},this._normalized=!1,this._parseOpts=void 0}init(scaleOpts){let opts=arguments.length>1&&void 0!==arguments[1]?arguments[1]:{};const time=scaleOpts.time||(scaleOpts.time={}),adapter=this._adapter=new _adapters._date(scaleOpts.adapters.date);adapter.init(opts),mergeIf(time.displayFormats,adapter.formats()),this._parseOpts={parser:time.parser,round:time.round,isoWeekday:time.isoWeekday},super.init(scaleOpts),this._normalized=opts.normalized}parse(raw,index){return void 0===raw?null:parse(this,raw)}beforeLayout(){super.beforeLayout(),this._cache={data:[],labels:[],all:[]}}determineDataLimits(){const options=this.options,adapter=this._adapter,unit=options.time.unit||"day";let{min:min,max:max,minDefined:minDefined,maxDefined:maxDefined}=this.getUserBounds();function _applyBounds(bounds){minDefined||isNaN(bounds.min)||(min=Math.min(min,bounds.min)),maxDefined||isNaN(bounds.max)||(max=Math.max(max,bounds.max))}minDefined&&maxDefined||(_applyBounds(this._getLabelBounds()),"ticks"===options.bounds&&"labels"===options.ticks.source||_applyBounds(this.getMinMax(!1))),min=isNumberFinite(min)&&!isNaN(min)?min:+adapter.startOf(Date.now(),unit),max=isNumberFinite(max)&&!isNaN(max)?max:+adapter.endOf(Date.now(),unit)+1,this.min=Math.min(min,max-1),this.max=Math.max(min+1,max)}_getLabelBounds(){const arr=this.getLabelTimestamps();let min=Number.POSITIVE_INFINITY,max=Number.NEGATIVE_INFINITY;return arr.length&&(min=arr[0],max=arr[arr.length-1]),{min:min,max:max}}buildTicks(){const options=this.options,timeOpts=options.time,tickOpts=options.ticks,timestamps="labels"===tickOpts.source?this.getLabelTimestamps():this._generate();"ticks"===options.bounds&&timestamps.length&&(this.min=this._userMin||timestamps[0],this.max=this._userMax||timestamps[timestamps.length-1]);const min=this.min,ticks=_filterBetween(timestamps,min,this.max);return this._unit=timeOpts.unit||(tickOpts.autoSkip?determineUnitForAutoTicks(timeOpts.minUnit,this.min,this.max,this._getLabelCapacity(min)):function(scale,numTicks,minUnit,min,max){for(let i=UNITS.length-1;i>=UNITS.indexOf(minUnit);i--){const unit=UNITS[i];if(INTERVALS[unit].common&&scale._adapter.diff(max,min,unit)>=numTicks-1)return unit}return UNITS[minUnit?UNITS.indexOf(minUnit):0]}(this,ticks.length,timeOpts.minUnit,this.min,this.max)),this._majorUnit=tickOpts.major.enabled&&"year"!==this._unit?function(unit){for(let i=UNITS.indexOf(unit)+1,ilen=UNITS.length;i<ilen;++i)if(INTERVALS[UNITS[i]].common)return UNITS[i]}(this._unit):void 0,this.initOffsets(timestamps),options.reverse&&ticks.reverse(),ticksFromTimestamps(this,ticks,this._majorUnit)}afterAutoSkip(){this.options.offsetAfterAutoskip&&this.initOffsets(this.ticks.map((tick=>+tick.value)))}initOffsets(){let first,last,timestamps=arguments.length>0&&void 0!==arguments[0]?arguments[0]:[],start=0,end=0;this.options.offset&&timestamps.length&&(first=this.getDecimalForValue(timestamps[0]),start=1===timestamps.length?1-first:(this.getDecimalForValue(timestamps[1])-first)/2,last=this.getDecimalForValue(timestamps[timestamps.length-1]),end=1===timestamps.length?last:(last-this.getDecimalForValue(timestamps[timestamps.length-2]))/2);const limit=timestamps.length<3?.5:.25;start=_limitValue(start,0,limit),end=_limitValue(end,0,limit),this._offsets={start:start,end:end,factor:1/(start+1+end)}}_generate(){const adapter=this._adapter,min=this.min,max=this.max,options=this.options,timeOpts=options.time,minor=timeOpts.unit||determineUnitForAutoTicks(timeOpts.minUnit,min,max,this._getLabelCapacity(min)),stepSize=valueOrDefault(options.ticks.stepSize,1),weekday="week"===minor&&timeOpts.isoWeekday,hasWeekday=isNumber(weekday)||!0===weekday,ticks={};let time,count,first=min;if(hasWeekday&&(first=+adapter.startOf(first,"isoWeek",weekday)),first=+adapter.startOf(first,hasWeekday?"day":minor),adapter.diff(max,min,minor)>1e5*stepSize)throw new Error(min+" and "+max+" are too far apart with stepSize of "+stepSize+" "+minor);const timestamps="data"===options.ticks.source&&this.getDataTimestamps();for(time=first,count=0;time<max;time=+adapter.add(time,stepSize,minor),count++)addTick(ticks,time,timestamps);return time!==max&&"ticks"!==options.bounds&&1!==count||addTick(ticks,time,timestamps),Object.keys(ticks).sort(sorter).map((x=>+x))}getLabelForValue(value){const adapter=this._adapter,timeOpts=this.options.time;return timeOpts.tooltipFormat?adapter.format(value,timeOpts.tooltipFormat):adapter.format(value,timeOpts.displayFormats.datetime)}format(value,format){const formats=this.options.time.displayFormats,unit=this._unit,fmt=format||formats[unit];return this._adapter.format(value,fmt)}_tickFormatFunction(time,index,ticks,format){const options=this.options,formatter=options.ticks.callback;if(formatter)return callback(formatter,[time,index,ticks],this);const formats=options.time.displayFormats,unit=this._unit,majorUnit=this._majorUnit,minorFormat=unit&&formats[unit],majorFormat=majorUnit&&formats[majorUnit],tick=ticks[index],major=majorUnit&&majorFormat&&tick&&tick.major;return this._adapter.format(time,format||(major?majorFormat:minorFormat))}generateTickLabels(ticks){let i,ilen,tick;for(i=0,ilen=ticks.length;i<ilen;++i)tick=ticks[i],tick.label=this._tickFormatFunction(tick.value,i,ticks)}getDecimalForValue(value){return null===value?NaN:(value-this.min)/(this.max-this.min)}getPixelForValue(value){const offsets=this._offsets,pos=this.getDecimalForValue(value);return this.getPixelForDecimal((offsets.start+pos)*offsets.factor)}getValueForPixel(pixel){const offsets=this._offsets,pos=this.getDecimalForPixel(pixel)/offsets.factor-offsets.end;return this.min+pos*(this.max-this.min)}_getLabelSize(label){const ticksOpts=this.options.ticks,tickLabelWidth=this.ctx.measureText(label).width,angle=toRadians(this.isHorizontal()?ticksOpts.maxRotation:ticksOpts.minRotation),cosRotation=Math.cos(angle),sinRotation=Math.sin(angle),tickFontSize=this._resolveTickFontOptions(0).size;return{w:tickLabelWidth*cosRotation+tickFontSize*sinRotation,h:tickLabelWidth*sinRotation+tickFontSize*cosRotation}}_getLabelCapacity(exampleTime){const timeOpts=this.options.time,displayFormats=timeOpts.displayFormats,format=displayFormats[timeOpts.unit]||displayFormats.millisecond,exampleLabel=this._tickFormatFunction(exampleTime,0,ticksFromTimestamps(this,[exampleTime],this._majorUnit),format),size=this._getLabelSize(exampleLabel),capacity=Math.floor(this.isHorizontal()?this.width/size.w:this.height/size.h)-1;return capacity>0?capacity:1}getDataTimestamps(){let i,ilen,timestamps=this._cache.data||[];if(timestamps.length)return timestamps;const metas=this.getMatchingVisibleMetas();if(this._normalized&&metas.length)return this._cache.data=metas[0].controller.getAllParsedValues(this);for(i=0,ilen=metas.length;i<ilen;++i)timestamps=timestamps.concat(metas[i].controller.getAllParsedValues(this));return this._cache.data=this.normalize(timestamps)}getLabelTimestamps(){const timestamps=this._cache.labels||[];let i,ilen;if(timestamps.length)return timestamps;const labels=this.getLabels();for(i=0,ilen=labels.length;i<ilen;++i)timestamps.push(parse(this,labels[i]));return this._cache.labels=this._normalized?timestamps:this.normalize(timestamps)}normalize(values){return _arrayUnique(values.sort(sorter))}}function interpolate(table,val,reverse){let prevSource,nextSource,prevTarget,nextTarget,lo=0,hi=table.length-1;reverse?(val>=table[lo].pos&&val<=table[hi].pos&&({lo:lo,hi:hi}=_lookupByKey(table,"pos",val)),({pos:prevSource,time:prevTarget}=table[lo]),({pos:nextSource,time:nextTarget}=table[hi])):(val>=table[lo].time&&val<=table[hi].time&&({lo:lo,hi:hi}=_lookupByKey(table,"time",val)),({time:prevSource,pos:prevTarget}=table[lo]),({time:nextSource,pos:nextTarget}=table[hi]));const span=nextSource-prevSource;return span?prevTarget+(nextTarget-prevTarget)*(val-prevSource)/span:prevTarget}_defineProperty(TimeScale,"id","time"),_defineProperty(TimeScale,"defaults",{bounds:"data",adapters:{},time:{parser:!1,unit:!1,round:!1,isoWeekday:!1,minUnit:"millisecond",displayFormats:{}},ticks:{source:"auto",callback:!1,major:{enabled:!1}}});class TimeSeriesScale extends TimeScale{constructor(props){super(props),this._table=[],this._minPos=void 0,this._tableRange=void 0}initOffsets(){const timestamps=this._getTimestampsForTable(),table=this._table=this.buildLookupTable(timestamps);this._minPos=interpolate(table,this.min),this._tableRange=interpolate(table,this.max)-this._minPos,super.initOffsets(timestamps)}buildLookupTable(timestamps){const{min:min,max:max}=this,items=[],table=[];let i,ilen,prev,curr,next;for(i=0,ilen=timestamps.length;i<ilen;++i)curr=timestamps[i],curr>=min&&curr<=max&&items.push(curr);if(items.length<2)return[{time:min,pos:0},{time:max,pos:1}];for(i=0,ilen=items.length;i<ilen;++i)next=items[i+1],prev=items[i-1],curr=items[i],Math.round((next+prev)/2)!==curr&&table.push({time:curr,pos:i/(ilen-1)});return table}_generate(){const min=this.min,max=this.max;let timestamps=super.getDataTimestamps();return timestamps.includes(min)&&timestamps.length||timestamps.splice(0,0,min),timestamps.includes(max)&&1!==timestamps.length||timestamps.push(max),timestamps.sort(((a,b)=>a-b))}_getTimestampsForTable(){let timestamps=this._cache.all||[];if(timestamps.length)return timestamps;const data=this.getDataTimestamps(),label=this.getLabelTimestamps();return timestamps=data.length&&label.length?this.normalize(data.concat(label)):data.length?data:label,timestamps=this._cache.all=timestamps,timestamps}getDecimalForValue(value){return(interpolate(this._table,value)-this._minPos)/this._tableRange}getValueForPixel(pixel){const offsets=this._offsets,decimal=this.getDecimalForPixel(pixel)/offsets.factor-offsets.end;return interpolate(this._table,decimal*this._tableRange+this._minPos,!0)}}_defineProperty(TimeSeriesScale,"id","timeseries"),_defineProperty(TimeSeriesScale,"defaults",TimeScale.defaults);var scales=Object.freeze({__proto__:null,CategoryScale:CategoryScale,LinearScale:LinearScale,LogarithmicScale:LogarithmicScale,RadialLinearScale:RadialLinearScale,TimeScale:TimeScale,TimeSeriesScale:TimeSeriesScale});const BORDER_COLORS=["rgb(54, 162, 235)","rgb(255, 99, 132)","rgb(255, 159, 64)","rgb(255, 205, 86)","rgb(75, 192, 192)","rgb(153, 102, 255)","rgb(201, 203, 207)"],BACKGROUND_COLORS=BORDER_COLORS.map((color=>color.replace("rgb(","rgba(").replace(")",", 0.5)")));function getBorderColor(i){return BORDER_COLORS[i%BORDER_COLORS.length]}function getBackgroundColor(i){return BACKGROUND_COLORS[i%BACKGROUND_COLORS.length]}function getColorizer(chart){let i=0;return(dataset,datasetIndex)=>{const controller=chart.getDatasetMeta(datasetIndex).controller;controller instanceof DoughnutController?i=function(dataset,i){return dataset.backgroundColor=dataset.data.map((()=>getBorderColor(i++))),i}(dataset,i):controller instanceof PolarAreaController?i=function(dataset,i){return dataset.backgroundColor=dataset.data.map((()=>getBackgroundColor(i++))),i}(dataset,i):controller&&(i=function(dataset,i){return dataset.borderColor=getBorderColor(i),dataset.backgroundColor=getBackgroundColor(i),++i}(dataset,i))}}function containsColorsDefinitions(descriptors){let k;for(k in descriptors)if(descriptors[k].borderColor||descriptors[k].backgroundColor)return!0;return!1}var plugin_colors={id:"colors",defaults:{enabled:!0,forceOverride:!1},beforeLayout(chart,_args,options){if(!options.enabled)return;const{data:{datasets:datasets},options:chartOptions}=chart.config,{elements:elements}=chartOptions;if(!options.forceOverride&&(containsColorsDefinitions(datasets)||(descriptor=chartOptions)&&(descriptor.borderColor||descriptor.backgroundColor)||elements&&containsColorsDefinitions(elements)))return;var descriptor;const colorizer=getColorizer(chart);datasets.forEach(colorizer)}};function cleanDecimatedDataset(dataset){if(dataset._decimated){const data=dataset._data;delete dataset._decimated,delete dataset._data,Object.defineProperty(dataset,"data",{configurable:!0,enumerable:!0,writable:!0,value:data})}}function cleanDecimatedData(chart){chart.data.datasets.forEach((dataset=>{cleanDecimatedDataset(dataset)}))}var plugin_decimation={id:"decimation",defaults:{algorithm:"min-max",enabled:!1},beforeElementsUpdate:(chart,args,options)=>{if(!options.enabled)return void cleanDecimatedData(chart);const availableWidth=chart.width;chart.data.datasets.forEach(((dataset,datasetIndex)=>{const{_data:_data,indexAxis:indexAxis}=dataset,meta=chart.getDatasetMeta(datasetIndex),data=_data||dataset.data;if("y"===resolve([indexAxis,chart.options.indexAxis]))return;if(!meta.controller.supportsDecimation)return;const xAxis=chart.scales[meta.xAxisID];if("linear"!==xAxis.type&&"time"!==xAxis.type)return;if(chart.options.parsing)return;let decimated,{start:start,count:count}=function(meta,points){const pointCount=points.length;let count,start=0;const{iScale:iScale}=meta,{min:min,max:max,minDefined:minDefined,maxDefined:maxDefined}=iScale.getUserBounds();return minDefined&&(start=_limitValue(_lookupByKey(points,iScale.axis,min).lo,0,pointCount-1)),count=maxDefined?_limitValue(_lookupByKey(points,iScale.axis,max).hi+1,start,pointCount)-start:pointCount-start,{start:start,count:count}}(meta,data);if(count<=(options.threshold||4*availableWidth))cleanDecimatedDataset(dataset);else{switch(isNullOrUndef(_data)&&(dataset._data=data,delete dataset.data,Object.defineProperty(dataset,"data",{configurable:!0,enumerable:!0,get:function(){return this._decimated},set:function(d){this._data=d}})),options.algorithm){case"lttb":decimated=function(data,start,count,availableWidth,options){const samples=options.samples||availableWidth;if(samples>=count)return data.slice(start,start+count);const decimated=[],bucketWidth=(count-2)/(samples-2);let sampledIndex=0;const endIndex=start+count-1;let i,maxAreaPoint,maxArea,area,nextA,a=start;for(decimated[sampledIndex++]=data[a],i=0;i<samples-2;i++){let j,avgX=0,avgY=0;const avgRangeStart=Math.floor((i+1)*bucketWidth)+1+start,avgRangeEnd=Math.min(Math.floor((i+2)*bucketWidth)+1,count)+start,avgRangeLength=avgRangeEnd-avgRangeStart;for(j=avgRangeStart;j<avgRangeEnd;j++)avgX+=data[j].x,avgY+=data[j].y;avgX/=avgRangeLength,avgY/=avgRangeLength;const rangeOffs=Math.floor(i*bucketWidth)+1+start,rangeTo=Math.min(Math.floor((i+1)*bucketWidth)+1,count)+start,{x:pointAx,y:pointAy}=data[a];for(maxArea=area=-1,j=rangeOffs;j<rangeTo;j++)area=.5*Math.abs((pointAx-avgX)*(data[j].y-pointAy)-(pointAx-data[j].x)*(avgY-pointAy)),area>maxArea&&(maxArea=area,maxAreaPoint=data[j],nextA=j);decimated[sampledIndex++]=maxAreaPoint,a=nextA}return decimated[sampledIndex++]=data[endIndex],decimated}(data,start,count,availableWidth,options);break;case"min-max":decimated=function(data,start,count,availableWidth){let i,point,x,y,prevX,minIndex,maxIndex,startIndex,minY,maxY,avgX=0,countX=0;const decimated=[],endIndex=start+count-1,xMin=data[start].x,dx=data[endIndex].x-xMin;for(i=start;i<start+count;++i){point=data[i],x=(point.x-xMin)/dx*availableWidth,y=point.y;const truncX=0|x;if(truncX===prevX)y<minY?(minY=y,minIndex=i):y>maxY&&(maxY=y,maxIndex=i),avgX=(countX*avgX+point.x)/++countX;else{const lastIndex=i-1;if(!isNullOrUndef(minIndex)&&!isNullOrUndef(maxIndex)){const intermediateIndex1=Math.min(minIndex,maxIndex),intermediateIndex2=Math.max(minIndex,maxIndex);intermediateIndex1!==startIndex&&intermediateIndex1!==lastIndex&&decimated.push({...data[intermediateIndex1],x:avgX}),intermediateIndex2!==startIndex&&intermediateIndex2!==lastIndex&&decimated.push({...data[intermediateIndex2],x:avgX})}i>0&&lastIndex!==startIndex&&decimated.push(data[lastIndex]),decimated.push(point),prevX=truncX,countX=0,minY=maxY=y,minIndex=maxIndex=startIndex=i}}return decimated}(data,start,count,availableWidth);break;default:throw new Error("Unsupported decimation algorithm '".concat(options.algorithm,"'"))}dataset._decimated=decimated}}))},destroy(chart){cleanDecimatedData(chart)}};function _getBounds(property,first,last,loop){if(loop)return;let start=first[property],end=last[property];return"angle"===property&&(start=_normalizeAngle(start),end=_normalizeAngle(end)),{property:property,start:start,end:end}}function _findSegmentEnd(start,end,points){for(;end>start;end--){const point=points[end];if(!isNaN(point.x)&&!isNaN(point.y))break}return end}function _getEdge(a,b,prop,fn){return a&&b?fn(a[prop],b[prop]):a?a[prop]:b?b[prop]:0}function _createBoundaryLine(boundary,line){let points=[],_loop=!1;return isArray(boundary)?(_loop=!0,points=boundary):points=function(boundary,line){const{x:x=null,y:y=null}=boundary||{},linePoints=line.points,points=[];return line.segments.forEach((_ref8=>{let{start:start,end:end}=_ref8;end=_findSegmentEnd(start,end,linePoints);const first=linePoints[start],last=linePoints[end];null!==y?(points.push({x:first.x,y:y}),points.push({x:last.x,y:y})):null!==x&&(points.push({x:x,y:first.y}),points.push({x:x,y:last.y}))})),points}(boundary,line),points.length?new LineElement({points:points,options:{tension:0},_loop:_loop,_fullLoop:_loop}):null}function _shouldApplyFill(source){return source&&!1!==source.fill}function _resolveTarget(sources,index,propagate){let fill=sources[index].fill;const visited=[index];let target;if(!propagate)return fill;for(;!1!==fill&&-1===visited.indexOf(fill);){if(!isNumberFinite(fill))return fill;if(target=sources[fill],!target)return!1;if(target.visible)return fill;visited.push(fill),fill=target.fill}return!1}function _decodeFill(line,index,count){const fill=function(line){const options=line.options,fillOption=options.fill;let fill=valueOrDefault(fillOption&&fillOption.target,fillOption);return void 0===fill&&(fill=!!options.backgroundColor),!1!==fill&&null!==fill&&(!0===fill?"origin":fill)}(line);if(isObject(fill))return!isNaN(fill.value)&&fill;let target=parseFloat(fill);return isNumberFinite(target)&&Math.floor(target)===target?function(firstCh,index,target,count){return"-"!==firstCh&&"+"!==firstCh||(target=index+target),!(target===index||target<0||target>=count)&&target}(fill[0],index,target,count):["origin","start","end","stack","shape"].indexOf(fill)>=0&&fill}function addPointsBelow(points,sourcePoint,linesBelow){const postponed=[];for(let j=0;j<linesBelow.length;j++){const line=linesBelow[j],{first:first,last:last,point:point}=findPoint(line,sourcePoint,"x");if(!(!point||first&&last))if(first)postponed.unshift(point);else if(points.push(point),!last)break}points.push(...postponed)}function findPoint(line,sourcePoint,property){const point=line.interpolate(sourcePoint,property);if(!point)return{};const pointValue=point[property],segments=line.segments,linePoints=line.points;let first=!1,last=!1;for(let i=0;i<segments.length;i++){const segment=segments[i],firstValue=linePoints[segment.start][property],lastValue=linePoints[segment.end][property];if(_isBetween(pointValue,firstValue,lastValue)){first=pointValue===firstValue,last=pointValue===lastValue;break}}return{first:first,last:last,point:point}}class simpleArc{constructor(opts){this.x=opts.x,this.y=opts.y,this.radius=opts.radius}pathSegment(ctx,bounds,opts){const{x:x,y:y,radius:radius}=this;return bounds=bounds||{start:0,end:TAU},ctx.arc(x,y,radius,bounds.end,bounds.start,!0),!opts.bounds}interpolate(point){const{x:x,y:y,radius:radius}=this,angle=point.angle;return{x:x+Math.cos(angle)*radius,y:y+Math.sin(angle)*radius,angle:angle}}}function _getTarget(source){const{chart:chart,fill:fill,line:line}=source;if(isNumberFinite(fill))return function(chart,index){const meta=chart.getDatasetMeta(index);return meta&&chart.isDatasetVisible(index)?meta.dataset:null}(chart,fill);if("stack"===fill)return function(source){const{scale:scale,index:index,line:line}=source,points=[],segments=line.segments,sourcePoints=line.points,linesBelow=function(scale,index){const below=[],metas=scale.getMatchingVisibleMetas("line");for(let i=0;i<metas.length;i++){const meta=metas[i];if(meta.index===index)break;meta.hidden||below.unshift(meta.dataset)}return below}(scale,index);linesBelow.push(_createBoundaryLine({x:null,y:scale.bottom},line));for(let i=0;i<segments.length;i++){const segment=segments[i];for(let j=segment.start;j<=segment.end;j++)addPointsBelow(points,sourcePoints[j],linesBelow)}return new LineElement({points:points,options:{}})}(source);if("shape"===fill)return!0;const boundary=function(source){return(source.scale||{}).getPointPositionForValue?function(source){const{scale:scale,fill:fill}=source,options=scale.options,length=scale.getLabels().length,start=options.reverse?scale.max:scale.min,value=function(fill,scale,startValue){let value;return value="start"===fill?startValue:"end"===fill?scale.options.reverse?scale.min:scale.max:isObject(fill)?fill.value:scale.getBaseValue(),value}(fill,scale,start),target=[];if(options.grid.circular){const center=scale.getPointPositionForValue(0,start);return new simpleArc({x:center.x,y:center.y,radius:scale.getDistanceFromCenterForValue(value)})}for(let i=0;i<length;++i)target.push(scale.getPointPositionForValue(i,value));return target}(source):function(source){const{scale:scale={},fill:fill}=source,pixel=function(fill,scale){let pixel=null;return"start"===fill?pixel=scale.bottom:"end"===fill?pixel=scale.top:isObject(fill)?pixel=scale.getPixelForValue(fill.value):scale.getBasePixel&&(pixel=scale.getBasePixel()),pixel}(fill,scale);if(isNumberFinite(pixel)){const horizontal=scale.isHorizontal();return{x:horizontal?pixel:null,y:horizontal?null:pixel}}return null}(source)}(source);return boundary instanceof simpleArc?boundary:_createBoundaryLine(boundary,line)}function _drawfill(ctx,source,area){const target=_getTarget(source),{line:line,scale:scale,axis:axis}=source,lineOpts=line.options,fillOption=lineOpts.fill,color=lineOpts.backgroundColor,{above:above=color,below:below=color}=fillOption||{};target&&line.points.length&&(clipArea(ctx,area),function(ctx,cfg){const{line:line,target:target,above:above,below:below,area:area,scale:scale}=cfg,property=line._loop?"angle":cfg.axis;ctx.save(),"x"===property&&below!==above&&(clipVertical(ctx,target,area.top),fill(ctx,{line:line,target:target,color:above,scale:scale,property:property}),ctx.restore(),ctx.save(),clipVertical(ctx,target,area.bottom)),fill(ctx,{line:line,target:target,color:below,scale:scale,property:property}),ctx.restore()}(ctx,{line:line,target:target,above:above,below:below,area:area,scale:scale,axis:axis}),unclipArea(ctx))}function clipVertical(ctx,target,clipY){const{segments:segments,points:points}=target;let first=!0,lineLoop=!1;ctx.beginPath();for(const segment of segments){const{start:start,end:end}=segment,firstPoint=points[start],lastPoint=points[_findSegmentEnd(start,end,points)];first?(ctx.moveTo(firstPoint.x,firstPoint.y),first=!1):(ctx.lineTo(firstPoint.x,clipY),ctx.lineTo(firstPoint.x,firstPoint.y)),lineLoop=!!target.pathSegment(ctx,segment,{move:lineLoop}),lineLoop?ctx.closePath():ctx.lineTo(lastPoint.x,clipY)}ctx.lineTo(target.first().x,clipY),ctx.closePath(),ctx.clip()}function fill(ctx,cfg){const{line:line,target:target,property:property,color:color,scale:scale}=cfg,segments=function(line,target,property){const segments=line.segments,points=line.points,tpoints=target.points,parts=[];for(const segment of segments){let{start:start,end:end}=segment;end=_findSegmentEnd(start,end,points);const bounds=_getBounds(property,points[start],points[end],segment.loop);if(!target.segments){parts.push({source:segment,target:bounds,start:points[start],end:points[end]});continue}const targetSegments=_boundSegments(target,bounds);for(const tgt of targetSegments){const subBounds=_getBounds(property,tpoints[tgt.start],tpoints[tgt.end],tgt.loop),fillSources=_boundSegment(segment,points,subBounds);for(const fillSource of fillSources)parts.push({source:fillSource,target:tgt,start:{[property]:_getEdge(bounds,subBounds,"start",Math.max)},end:{[property]:_getEdge(bounds,subBounds,"end",Math.min)}})}}return parts}(line,target,property);for(const{source:src,target:tgt,start:start,end:end}of segments){const{style:{backgroundColor:backgroundColor=color}={}}=src,notShape=!0!==target;ctx.save(),ctx.fillStyle=backgroundColor,clipBounds(ctx,scale,notShape&&_getBounds(property,start,end)),ctx.beginPath();const lineLoop=!!line.pathSegment(ctx,src);let loop;if(notShape){lineLoop?ctx.closePath():interpolatedLineTo(ctx,target,end,property);const targetLoop=!!target.pathSegment(ctx,tgt,{move:lineLoop,reverse:!0});loop=lineLoop&&targetLoop,loop||interpolatedLineTo(ctx,target,start,property)}ctx.closePath(),ctx.fill(loop?"evenodd":"nonzero"),ctx.restore()}}function clipBounds(ctx,scale,bounds){const{top:top,bottom:bottom}=scale.chart.chartArea,{property:property,start:start,end:end}=bounds||{};"x"===property&&(ctx.beginPath(),ctx.rect(start,top,end-start,bottom-top),ctx.clip())}function interpolatedLineTo(ctx,target,point,property){const interpolatedPoint=target.interpolate(point,property);interpolatedPoint&&ctx.lineTo(interpolatedPoint.x,interpolatedPoint.y)}var index={id:"filler",afterDatasetsUpdate(chart,_args,options){const count=(chart.data.datasets||[]).length,sources=[];let meta,i,line,source;for(i=0;i<count;++i)meta=chart.getDatasetMeta(i),line=meta.dataset,source=null,line&&line.options&&line instanceof LineElement&&(source={visible:chart.isDatasetVisible(i),index:i,fill:_decodeFill(line,i,count),chart:chart,axis:meta.controller.options.indexAxis,scale:meta.vScale,line:line}),meta.$filler=source,sources.push(source);for(i=0;i<count;++i)source=sources[i],source&&!1!==source.fill&&(source.fill=_resolveTarget(sources,i,options.propagate))},beforeDraw(chart,_args,options){const draw="beforeDraw"===options.drawTime,metasets=chart.getSortedVisibleDatasetMetas(),area=chart.chartArea;for(let i=metasets.length-1;i>=0;--i){const source=metasets[i].$filler;source&&(source.line.updateControlPoints(area,source.axis),draw&&source.fill&&_drawfill(chart.ctx,source,area))}},beforeDatasetsDraw(chart,_args,options){if("beforeDatasetsDraw"!==options.drawTime)return;const metasets=chart.getSortedVisibleDatasetMetas();for(let i=metasets.length-1;i>=0;--i){const source=metasets[i].$filler;_shouldApplyFill(source)&&_drawfill(chart.ctx,source,chart.chartArea)}},beforeDatasetDraw(chart,args,options){const source=args.meta.$filler;_shouldApplyFill(source)&&"beforeDatasetDraw"===options.drawTime&&_drawfill(chart.ctx,source,chart.chartArea)},defaults:{propagate:!0,drawTime:"beforeDatasetDraw"}};const getBoxSize=(labelOpts,fontSize)=>{let{boxHeight:boxHeight=fontSize,boxWidth:boxWidth=fontSize}=labelOpts;return labelOpts.usePointStyle&&(boxHeight=Math.min(boxHeight,fontSize),boxWidth=labelOpts.pointStyleWidth||Math.min(boxWidth,fontSize)),{boxWidth:boxWidth,boxHeight:boxHeight,itemHeight:Math.max(fontSize,boxHeight)}};class Legend extends Element{constructor(config){super(),this._added=!1,this.legendHitBoxes=[],this._hoveredItem=null,this.doughnutMode=!1,this.chart=config.chart,this.options=config.options,this.ctx=config.ctx,this.legendItems=void 0,this.columnSizes=void 0,this.lineWidths=void 0,this.maxHeight=void 0,this.maxWidth=void 0,this.top=void 0,this.bottom=void 0,this.left=void 0,this.right=void 0,this.height=void 0,this.width=void 0,this._margins=void 0,this.position=void 0,this.weight=void 0,this.fullSize=void 0}update(maxWidth,maxHeight,margins){this.maxWidth=maxWidth,this.maxHeight=maxHeight,this._margins=margins,this.setDimensions(),this.buildLabels(),this.fit()}setDimensions(){this.isHorizontal()?(this.width=this.maxWidth,this.left=this._margins.left,this.right=this.width):(this.height=this.maxHeight,this.top=this._margins.top,this.bottom=this.height)}buildLabels(){const labelOpts=this.options.labels||{};let legendItems=callback(labelOpts.generateLabels,[this.chart],this)||[];labelOpts.filter&&(legendItems=legendItems.filter((item=>labelOpts.filter(item,this.chart.data)))),labelOpts.sort&&(legendItems=legendItems.sort(((a,b)=>labelOpts.sort(a,b,this.chart.data)))),this.options.reverse&&legendItems.reverse(),this.legendItems=legendItems}fit(){const{options:options,ctx:ctx}=this;if(!options.display)return void(this.width=this.height=0);const labelOpts=options.labels,labelFont=toFont(labelOpts.font),fontSize=labelFont.size,titleHeight=this._computeTitleHeight(),{boxWidth:boxWidth,itemHeight:itemHeight}=getBoxSize(labelOpts,fontSize);let width,height;ctx.font=labelFont.string,this.isHorizontal()?(width=this.maxWidth,height=this._fitRows(titleHeight,fontSize,boxWidth,itemHeight)+10):(height=this.maxHeight,width=this._fitCols(titleHeight,labelFont,boxWidth,itemHeight)+10),this.width=Math.min(width,options.maxWidth||this.maxWidth),this.height=Math.min(height,options.maxHeight||this.maxHeight)}_fitRows(titleHeight,fontSize,boxWidth,itemHeight){const{ctx:ctx,maxWidth:maxWidth,options:{labels:{padding:padding}}}=this,hitboxes=this.legendHitBoxes=[],lineWidths=this.lineWidths=[0],lineHeight=itemHeight+padding;let totalHeight=titleHeight;ctx.textAlign="left",ctx.textBaseline="middle";let row=-1,top=-lineHeight;return this.legendItems.forEach(((legendItem,i)=>{const itemWidth=boxWidth+fontSize/2+ctx.measureText(legendItem.text).width;(0===i||lineWidths[lineWidths.length-1]+itemWidth+2*padding>maxWidth)&&(totalHeight+=lineHeight,lineWidths[lineWidths.length-(i>0?0:1)]=0,top+=lineHeight,row++),hitboxes[i]={left:0,top:top,row:row,width:itemWidth,height:itemHeight},lineWidths[lineWidths.length-1]+=itemWidth+padding})),totalHeight}_fitCols(titleHeight,labelFont,boxWidth,_itemHeight){const{ctx:ctx,maxHeight:maxHeight,options:{labels:{padding:padding}}}=this,hitboxes=this.legendHitBoxes=[],columnSizes=this.columnSizes=[],heightLimit=maxHeight-titleHeight;let totalWidth=padding,currentColWidth=0,currentColHeight=0,left=0,col=0;return this.legendItems.forEach(((legendItem,i)=>{const{itemWidth:itemWidth,itemHeight:itemHeight}=function(boxWidth,labelFont,ctx,legendItem,_itemHeight){const itemWidth=function(legendItem,boxWidth,labelFont,ctx){let legendItemText=legendItem.text;return legendItemText&&"string"!=typeof legendItemText&&(legendItemText=legendItemText.reduce(((a,b)=>a.length>b.length?a:b))),boxWidth+labelFont.size/2+ctx.measureText(legendItemText).width}(legendItem,boxWidth,labelFont,ctx),itemHeight=function(_itemHeight,legendItem,fontLineHeight){let itemHeight=_itemHeight;return"string"!=typeof legendItem.text&&(itemHeight=calculateLegendItemHeight(legendItem,fontLineHeight)),itemHeight}(_itemHeight,legendItem,labelFont.lineHeight);return{itemWidth:itemWidth,itemHeight:itemHeight}}(boxWidth,labelFont,ctx,legendItem,_itemHeight);i>0&&currentColHeight+itemHeight+2*padding>heightLimit&&(totalWidth+=currentColWidth+padding,columnSizes.push({width:currentColWidth,height:currentColHeight}),left+=currentColWidth+padding,col++,currentColWidth=currentColHeight=0),hitboxes[i]={left:left,top:currentColHeight,col:col,width:itemWidth,height:itemHeight},currentColWidth=Math.max(currentColWidth,itemWidth),currentColHeight+=itemHeight+padding})),totalWidth+=currentColWidth,columnSizes.push({width:currentColWidth,height:currentColHeight}),totalWidth}adjustHitBoxes(){if(!this.options.display)return;const titleHeight=this._computeTitleHeight(),{legendHitBoxes:hitboxes,options:{align:align,labels:{padding:padding},rtl:rtl}}=this,rtlHelper=getRtlAdapter(rtl,this.left,this.width);if(this.isHorizontal()){let row=0,left=_alignStartEnd(align,this.left+padding,this.right-this.lineWidths[row]);for(const hitbox of hitboxes)row!==hitbox.row&&(row=hitbox.row,left=_alignStartEnd(align,this.left+padding,this.right-this.lineWidths[row])),hitbox.top+=this.top+titleHeight+padding,hitbox.left=rtlHelper.leftForLtr(rtlHelper.x(left),hitbox.width),left+=hitbox.width+padding}else{let col=0,top=_alignStartEnd(align,this.top+titleHeight+padding,this.bottom-this.columnSizes[col].height);for(const hitbox of hitboxes)hitbox.col!==col&&(col=hitbox.col,top=_alignStartEnd(align,this.top+titleHeight+padding,this.bottom-this.columnSizes[col].height)),hitbox.top=top,hitbox.left+=this.left+padding,hitbox.left=rtlHelper.leftForLtr(rtlHelper.x(hitbox.left),hitbox.width),top+=hitbox.height+padding}}isHorizontal(){return"top"===this.options.position||"bottom"===this.options.position}draw(){if(this.options.display){const ctx=this.ctx;clipArea(ctx,this),this._draw(),unclipArea(ctx)}}_draw(){const{options:opts,columnSizes:columnSizes,lineWidths:lineWidths,ctx:ctx}=this,{align:align,labels:labelOpts}=opts,defaultColor=defaults.color,rtlHelper=getRtlAdapter(opts.rtl,this.left,this.width),labelFont=toFont(labelOpts.font),{padding:padding}=labelOpts,fontSize=labelFont.size,halfFontSize=fontSize/2;let cursor;this.drawTitle(),ctx.textAlign=rtlHelper.textAlign("left"),ctx.textBaseline="middle",ctx.lineWidth=.5,ctx.font=labelFont.string;const{boxWidth:boxWidth,boxHeight:boxHeight,itemHeight:itemHeight}=getBoxSize(labelOpts,fontSize),isHorizontal=this.isHorizontal(),titleHeight=this._computeTitleHeight();cursor=isHorizontal?{x:_alignStartEnd(align,this.left+padding,this.right-lineWidths[0]),y:this.top+padding+titleHeight,line:0}:{x:this.left+padding,y:_alignStartEnd(align,this.top+titleHeight+padding,this.bottom-columnSizes[0].height),line:0},overrideTextDirection(this.ctx,opts.textDirection);const lineHeight=itemHeight+padding;this.legendItems.forEach(((legendItem,i)=>{ctx.strokeStyle=legendItem.fontColor,ctx.fillStyle=legendItem.fontColor;const textWidth=ctx.measureText(legendItem.text).width,textAlign=rtlHelper.textAlign(legendItem.textAlign||(legendItem.textAlign=labelOpts.textAlign)),width=boxWidth+halfFontSize+textWidth;let x=cursor.x,y=cursor.y;if(rtlHelper.setWidth(this.width),isHorizontal?i>0&&x+width+padding>this.right&&(y=cursor.y+=lineHeight,cursor.line++,x=cursor.x=_alignStartEnd(align,this.left+padding,this.right-lineWidths[cursor.line])):i>0&&y+lineHeight>this.bottom&&(x=cursor.x=x+columnSizes[cursor.line].width+padding,cursor.line++,y=cursor.y=_alignStartEnd(align,this.top+titleHeight+padding,this.bottom-columnSizes[cursor.line].height)),function(x,y,legendItem){if(isNaN(boxWidth)||boxWidth<=0||isNaN(boxHeight)||boxHeight<0)return;ctx.save();const lineWidth=valueOrDefault(legendItem.lineWidth,1);if(ctx.fillStyle=valueOrDefault(legendItem.fillStyle,defaultColor),ctx.lineCap=valueOrDefault(legendItem.lineCap,"butt"),ctx.lineDashOffset=valueOrDefault(legendItem.lineDashOffset,0),ctx.lineJoin=valueOrDefault(legendItem.lineJoin,"miter"),ctx.lineWidth=lineWidth,ctx.strokeStyle=valueOrDefault(legendItem.strokeStyle,defaultColor),ctx.setLineDash(valueOrDefault(legendItem.lineDash,[])),labelOpts.usePointStyle){const drawOptions={radius:boxHeight*Math.SQRT2/2,pointStyle:legendItem.pointStyle,rotation:legendItem.rotation,borderWidth:lineWidth},centerX=rtlHelper.xPlus(x,boxWidth/2);drawPointLegend(ctx,drawOptions,centerX,y+halfFontSize,labelOpts.pointStyleWidth&&boxWidth)}else{const yBoxTop=y+Math.max((fontSize-boxHeight)/2,0),xBoxLeft=rtlHelper.leftForLtr(x,boxWidth),borderRadius=toTRBLCorners(legendItem.borderRadius);ctx.beginPath(),Object.values(borderRadius).some((v=>0!==v))?addRoundedRectPath(ctx,{x:xBoxLeft,y:yBoxTop,w:boxWidth,h:boxHeight,radius:borderRadius}):ctx.rect(xBoxLeft,yBoxTop,boxWidth,boxHeight),ctx.fill(),0!==lineWidth&&ctx.stroke()}ctx.restore()}(rtlHelper.x(x),y,legendItem),x=_textX(textAlign,x+boxWidth+halfFontSize,isHorizontal?x+width:this.right,opts.rtl),function(x,y,legendItem){renderText(ctx,legendItem.text,x,y+itemHeight/2,labelFont,{strikethrough:legendItem.hidden,textAlign:rtlHelper.textAlign(legendItem.textAlign)})}(rtlHelper.x(x),y,legendItem),isHorizontal)cursor.x+=width+padding;else if("string"!=typeof legendItem.text){const fontLineHeight=labelFont.lineHeight;cursor.y+=calculateLegendItemHeight(legendItem,fontLineHeight)+padding}else cursor.y+=lineHeight})),restoreTextDirection(this.ctx,opts.textDirection)}drawTitle(){const opts=this.options,titleOpts=opts.title,titleFont=toFont(titleOpts.font),titlePadding=toPadding(titleOpts.padding);if(!titleOpts.display)return;const rtlHelper=getRtlAdapter(opts.rtl,this.left,this.width),ctx=this.ctx,position=titleOpts.position,halfFontSize=titleFont.size/2,topPaddingPlusHalfFontSize=titlePadding.top+halfFontSize;let y,left=this.left,maxWidth=this.width;if(this.isHorizontal())maxWidth=Math.max(...this.lineWidths),y=this.top+topPaddingPlusHalfFontSize,left=_alignStartEnd(opts.align,left,this.right-maxWidth);else{const maxHeight=this.columnSizes.reduce(((acc,size)=>Math.max(acc,size.height)),0);y=topPaddingPlusHalfFontSize+_alignStartEnd(opts.align,this.top,this.bottom-maxHeight-opts.labels.padding-this._computeTitleHeight())}const x=_alignStartEnd(position,left,left+maxWidth);ctx.textAlign=rtlHelper.textAlign(_toLeftRightCenter(position)),ctx.textBaseline="middle",ctx.strokeStyle=titleOpts.color,ctx.fillStyle=titleOpts.color,ctx.font=titleFont.string,renderText(ctx,titleOpts.text,x,y,titleFont)}_computeTitleHeight(){const titleOpts=this.options.title,titleFont=toFont(titleOpts.font),titlePadding=toPadding(titleOpts.padding);return titleOpts.display?titleFont.lineHeight+titlePadding.height:0}_getLegendItemAt(x,y){let i,hitBox,lh;if(_isBetween(x,this.left,this.right)&&_isBetween(y,this.top,this.bottom))for(lh=this.legendHitBoxes,i=0;i<lh.length;++i)if(hitBox=lh[i],_isBetween(x,hitBox.left,hitBox.left+hitBox.width)&&_isBetween(y,hitBox.top,hitBox.top+hitBox.height))return this.legendItems[i];return null}handleEvent(e){const opts=this.options;if(!function(type,opts){return!("mousemove"!==type&&"mouseout"!==type||!opts.onHover&&!opts.onLeave)||!(!opts.onClick||"click"!==type&&"mouseup"!==type)}(e.type,opts))return;const hoveredItem=this._getLegendItemAt(e.x,e.y);if("mousemove"===e.type||"mouseout"===e.type){const previous=this._hoveredItem,sameItem=(b=hoveredItem,null!==(a=previous)&&null!==b&&a.datasetIndex===b.datasetIndex&&a.index===b.index);previous&&!sameItem&&callback(opts.onLeave,[e,previous,this],this),this._hoveredItem=hoveredItem,hoveredItem&&!sameItem&&callback(opts.onHover,[e,hoveredItem,this],this)}else hoveredItem&&callback(opts.onClick,[e,hoveredItem,this],this);var a,b}}function calculateLegendItemHeight(legendItem,fontLineHeight){return fontLineHeight*(legendItem.text?legendItem.text.length:0)}var plugin_legend={id:"legend",_element:Legend,start(chart,_args,options){const legend=chart.legend=new Legend({ctx:chart.ctx,options:options,chart:chart});layouts.configure(chart,legend,options),layouts.addBox(chart,legend)},stop(chart){layouts.removeBox(chart,chart.legend),delete chart.legend},beforeUpdate(chart,_args,options){const legend=chart.legend;layouts.configure(chart,legend,options),legend.options=options},afterUpdate(chart){const legend=chart.legend;legend.buildLabels(),legend.adjustHitBoxes()},afterEvent(chart,args){args.replay||chart.legend.handleEvent(args.event)},defaults:{display:!0,position:"top",align:"center",fullSize:!0,reverse:!1,weight:1e3,onClick(e,legendItem,legend){const index=legendItem.datasetIndex,ci=legend.chart;ci.isDatasetVisible(index)?(ci.hide(index),legendItem.hidden=!0):(ci.show(index),legendItem.hidden=!1)},onHover:null,onLeave:null,labels:{color:ctx=>ctx.chart.options.color,boxWidth:40,padding:10,generateLabels(chart){const datasets=chart.data.datasets,{labels:{usePointStyle:usePointStyle,pointStyle:pointStyle,textAlign:textAlign,color:color,useBorderRadius:useBorderRadius,borderRadius:borderRadius}}=chart.legend.options;return chart._getSortedDatasetMetas().map((meta=>{const style=meta.controller.getStyle(usePointStyle?0:void 0),borderWidth=toPadding(style.borderWidth);return{text:datasets[meta.index].label,fillStyle:style.backgroundColor,fontColor:color,hidden:!meta.visible,lineCap:style.borderCapStyle,lineDash:style.borderDash,lineDashOffset:style.borderDashOffset,lineJoin:style.borderJoinStyle,lineWidth:(borderWidth.width+borderWidth.height)/4,strokeStyle:style.borderColor,pointStyle:pointStyle||style.pointStyle,rotation:style.rotation,textAlign:textAlign||style.textAlign,borderRadius:useBorderRadius&&(borderRadius||style.borderRadius),datasetIndex:meta.index}}),this)}},title:{color:ctx=>ctx.chart.options.color,display:!1,position:"center",text:""}},descriptors:{_scriptable:name=>!name.startsWith("on"),labels:{_scriptable:name=>!["generateLabels","filter","sort"].includes(name)}}};class Title extends Element{constructor(config){super(),this.chart=config.chart,this.options=config.options,this.ctx=config.ctx,this._padding=void 0,this.top=void 0,this.bottom=void 0,this.left=void 0,this.right=void 0,this.width=void 0,this.height=void 0,this.position=void 0,this.weight=void 0,this.fullSize=void 0}update(maxWidth,maxHeight){const opts=this.options;if(this.left=0,this.top=0,!opts.display)return void(this.width=this.height=this.right=this.bottom=0);this.width=this.right=maxWidth,this.height=this.bottom=maxHeight;const lineCount=isArray(opts.text)?opts.text.length:1;this._padding=toPadding(opts.padding);const textSize=lineCount*toFont(opts.font).lineHeight+this._padding.height;this.isHorizontal()?this.height=textSize:this.width=textSize}isHorizontal(){const pos=this.options.position;return"top"===pos||"bottom"===pos}_drawArgs(offset){const{top:top,left:left,bottom:bottom,right:right,options:options}=this,align=options.align;let maxWidth,titleX,titleY,rotation=0;return this.isHorizontal()?(titleX=_alignStartEnd(align,left,right),titleY=top+offset,maxWidth=right-left):("left"===options.position?(titleX=left+offset,titleY=_alignStartEnd(align,bottom,top),rotation=-.5*PI):(titleX=right-offset,titleY=_alignStartEnd(align,top,bottom),rotation=.5*PI),maxWidth=bottom-top),{titleX:titleX,titleY:titleY,maxWidth:maxWidth,rotation:rotation}}draw(){const ctx=this.ctx,opts=this.options;if(!opts.display)return;const fontOpts=toFont(opts.font),offset=fontOpts.lineHeight/2+this._padding.top,{titleX:titleX,titleY:titleY,maxWidth:maxWidth,rotation:rotation}=this._drawArgs(offset);renderText(ctx,opts.text,0,0,fontOpts,{color:opts.color,maxWidth:maxWidth,rotation:rotation,textAlign:_toLeftRightCenter(opts.align),textBaseline:"middle",translation:[titleX,titleY]})}}var plugin_title={id:"title",_element:Title,start(chart,_args,options){!function(chart,titleOpts){const title=new Title({ctx:chart.ctx,options:titleOpts,chart:chart});layouts.configure(chart,title,titleOpts),layouts.addBox(chart,title),chart.titleBlock=title}(chart,options)},stop(chart){const titleBlock=chart.titleBlock;layouts.removeBox(chart,titleBlock),delete chart.titleBlock},beforeUpdate(chart,_args,options){const title=chart.titleBlock;layouts.configure(chart,title,options),title.options=options},defaults:{align:"center",display:!1,font:{weight:"bold"},fullSize:!0,padding:10,position:"top",text:"",weight:2e3},defaultRoutes:{color:"color"},descriptors:{_scriptable:!0,_indexable:!1}};const map=new WeakMap;var plugin_subtitle={id:"subtitle",start(chart,_args,options){const title=new Title({ctx:chart.ctx,options:options,chart:chart});layouts.configure(chart,title,options),layouts.addBox(chart,title),map.set(chart,title)},stop(chart){layouts.removeBox(chart,map.get(chart)),map.delete(chart)},beforeUpdate(chart,_args,options){const title=map.get(chart);layouts.configure(chart,title,options),title.options=options},defaults:{align:"center",display:!1,font:{weight:"normal"},fullSize:!0,padding:0,position:"top",text:"",weight:1500},defaultRoutes:{color:"color"},descriptors:{_scriptable:!0,_indexable:!1}};const positioners={average(items){if(!items.length)return!1;let i,len,xSet=new Set,y=0,count=0;for(i=0,len=items.length;i<len;++i){const el=items[i].element;if(el&&el.hasValue()){const pos=el.tooltipPosition();xSet.add(pos.x),y+=pos.y,++count}}return{x:[...xSet].reduce(((a,b)=>a+b))/xSet.size,y:y/count}},nearest(items,eventPosition){if(!items.length)return!1;let i,len,nearestElement,x=eventPosition.x,y=eventPosition.y,minDistance=Number.POSITIVE_INFINITY;for(i=0,len=items.length;i<len;++i){const el=items[i].element;if(el&&el.hasValue()){const d=distanceBetweenPoints(eventPosition,el.getCenterPoint());d<minDistance&&(minDistance=d,nearestElement=el)}}if(nearestElement){const tp=nearestElement.tooltipPosition();x=tp.x,y=tp.y}return{x:x,y:y}}};function pushOrConcat(base,toPush){return toPush&&(isArray(toPush)?Array.prototype.push.apply(base,toPush):base.push(toPush)),base}function splitNewlines(str){return("string"==typeof str||str instanceof String)&&str.indexOf("\n")>-1?str.split("\n"):str}function createTooltipItem(chart,item){const{element:element,datasetIndex:datasetIndex,index:index}=item,controller=chart.getDatasetMeta(datasetIndex).controller,{label:label,value:value}=controller.getLabelAndValue(index);return{chart:chart,label:label,parsed:controller.getParsed(index),raw:chart.data.datasets[datasetIndex].data[index],formattedValue:value,dataset:controller.getDataset(),dataIndex:index,datasetIndex:datasetIndex,element:element}}function getTooltipSize(tooltip,options){const ctx=tooltip.chart.ctx,{body:body,footer:footer,title:title}=tooltip,{boxWidth:boxWidth,boxHeight:boxHeight}=options,bodyFont=toFont(options.bodyFont),titleFont=toFont(options.titleFont),footerFont=toFont(options.footerFont),titleLineCount=title.length,footerLineCount=footer.length,bodyLineItemCount=body.length,padding=toPadding(options.padding);let height=padding.height,width=0,combinedBodyLength=body.reduce(((count,bodyItem)=>count+bodyItem.before.length+bodyItem.lines.length+bodyItem.after.length),0);combinedBodyLength+=tooltip.beforeBody.length+tooltip.afterBody.length,titleLineCount&&(height+=titleLineCount*titleFont.lineHeight+(titleLineCount-1)*options.titleSpacing+options.titleMarginBottom),combinedBodyLength&&(height+=bodyLineItemCount*(options.displayColors?Math.max(boxHeight,bodyFont.lineHeight):bodyFont.lineHeight)+(combinedBodyLength-bodyLineItemCount)*bodyFont.lineHeight+(combinedBodyLength-1)*options.bodySpacing),footerLineCount&&(height+=options.footerMarginTop+footerLineCount*footerFont.lineHeight+(footerLineCount-1)*options.footerSpacing);let widthPadding=0;const maxLineWidth=function(line){width=Math.max(width,ctx.measureText(line).width+widthPadding)};return ctx.save(),ctx.font=titleFont.string,each(tooltip.title,maxLineWidth),ctx.font=bodyFont.string,each(tooltip.beforeBody.concat(tooltip.afterBody),maxLineWidth),widthPadding=options.displayColors?boxWidth+2+options.boxPadding:0,each(body,(bodyItem=>{each(bodyItem.before,maxLineWidth),each(bodyItem.lines,maxLineWidth),each(bodyItem.after,maxLineWidth)})),widthPadding=0,ctx.font=footerFont.string,each(tooltip.footer,maxLineWidth),ctx.restore(),width+=padding.width,{width:width,height:height}}function determineXAlign(chart,options,size,yAlign){const{x:x,width:width}=size,{width:chartWidth,chartArea:{left:left,right:right}}=chart;let xAlign="center";return"center"===yAlign?xAlign=x<=(left+right)/2?"left":"right":x<=width/2?xAlign="left":x>=chartWidth-width/2&&(xAlign="right"),function(xAlign,chart,options,size){const{x:x,width:width}=size,caret=options.caretSize+options.caretPadding;return"left"===xAlign&&x+width+caret>chart.width||"right"===xAlign&&x-width-caret<0||void 0}(xAlign,chart,options,size)&&(xAlign="center"),xAlign}function determineAlignment(chart,options,size){const yAlign=size.yAlign||options.yAlign||function(chart,size){const{y:y,height:height}=size;return y<height/2?"top":y>chart.height-height/2?"bottom":"center"}(chart,size);return{xAlign:size.xAlign||options.xAlign||determineXAlign(chart,options,size,yAlign),yAlign:yAlign}}function getBackgroundPoint(options,size,alignment,chart){const{caretSize:caretSize,caretPadding:caretPadding,cornerRadius:cornerRadius}=options,{xAlign:xAlign,yAlign:yAlign}=alignment,paddingAndSize=caretSize+caretPadding,{topLeft:topLeft,topRight:topRight,bottomLeft:bottomLeft,bottomRight:bottomRight}=toTRBLCorners(cornerRadius);let x=function(size,xAlign){let{x:x,width:width}=size;return"right"===xAlign?x-=width:"center"===xAlign&&(x-=width/2),x}(size,xAlign);const y=function(size,yAlign,paddingAndSize){let{y:y,height:height}=size;return"top"===yAlign?y+=paddingAndSize:y-="bottom"===yAlign?height+paddingAndSize:height/2,y}(size,yAlign,paddingAndSize);return"center"===yAlign?"left"===xAlign?x+=paddingAndSize:"right"===xAlign&&(x-=paddingAndSize):"left"===xAlign?x-=Math.max(topLeft,bottomLeft)+caretSize:"right"===xAlign&&(x+=Math.max(topRight,bottomRight)+caretSize),{x:_limitValue(x,0,chart.width-size.width),y:_limitValue(y,0,chart.height-size.height)}}function getAlignedX(tooltip,align,options){const padding=toPadding(options.padding);return"center"===align?tooltip.x+tooltip.width/2:"right"===align?tooltip.x+tooltip.width-padding.right:tooltip.x+padding.left}function getBeforeAfterBodyLines(callback){return pushOrConcat([],splitNewlines(callback))}function overrideCallbacks(callbacks,context){const override=context&&context.dataset&&context.dataset.tooltip&&context.dataset.tooltip.callbacks;return override?callbacks.override(override):callbacks}const defaultCallbacks={beforeTitle:noop,title(tooltipItems){if(tooltipItems.length>0){const item=tooltipItems[0],labels=item.chart.data.labels,labelCount=labels?labels.length:0;if(this&&this.options&&"dataset"===this.options.mode)return item.dataset.label||"";if(item.label)return item.label;if(labelCount>0&&item.dataIndex<labelCount)return labels[item.dataIndex]}return""},afterTitle:noop,beforeBody:noop,beforeLabel:noop,label(tooltipItem){if(this&&this.options&&"dataset"===this.options.mode)return tooltipItem.label+": "+tooltipItem.formattedValue||tooltipItem.formattedValue;let label=tooltipItem.dataset.label||"";label&&(label+=": ");const value=tooltipItem.formattedValue;return isNullOrUndef(value)||(label+=value),label},labelColor(tooltipItem){const options=tooltipItem.chart.getDatasetMeta(tooltipItem.datasetIndex).controller.getStyle(tooltipItem.dataIndex);return{borderColor:options.borderColor,backgroundColor:options.backgroundColor,borderWidth:options.borderWidth,borderDash:options.borderDash,borderDashOffset:options.borderDashOffset,borderRadius:0}},labelTextColor(){return this.options.bodyColor},labelPointStyle(tooltipItem){const options=tooltipItem.chart.getDatasetMeta(tooltipItem.datasetIndex).controller.getStyle(tooltipItem.dataIndex);return{pointStyle:options.pointStyle,rotation:options.rotation}},afterLabel:noop,afterBody:noop,beforeFooter:noop,footer:noop,afterFooter:noop};function invokeCallbackWithFallback(callbacks,name,ctx,arg){const result=callbacks[name].call(ctx,arg);return void 0===result?defaultCallbacks[name].call(ctx,arg):result}class Tooltip extends Element{constructor(config){super(),this.opacity=0,this._active=[],this._eventPosition=void 0,this._size=void 0,this._cachedAnimations=void 0,this._tooltipItems=[],this.$animations=void 0,this.$context=void 0,this.chart=config.chart,this.options=config.options,this.dataPoints=void 0,this.title=void 0,this.beforeBody=void 0,this.body=void 0,this.afterBody=void 0,this.footer=void 0,this.xAlign=void 0,this.yAlign=void 0,this.x=void 0,this.y=void 0,this.height=void 0,this.width=void 0,this.caretX=void 0,this.caretY=void 0,this.labelColors=void 0,this.labelPointStyles=void 0,this.labelTextColors=void 0}initialize(options){this.options=options,this._cachedAnimations=void 0,this.$context=void 0}_resolveAnimations(){const cached=this._cachedAnimations;if(cached)return cached;const chart=this.chart,options=this.options.setContext(this.getContext()),opts=options.enabled&&chart.options.animation&&options.animations,animations=new Animations(this.chart,opts);return opts._cacheable&&(this._cachedAnimations=Object.freeze(animations)),animations}getContext(){return this.$context||(this.$context=(parent=this.chart.getContext(),tooltip=this,tooltipItems=this._tooltipItems,createContext(parent,{tooltip:tooltip,tooltipItems:tooltipItems,type:"tooltip"})));var parent,tooltip,tooltipItems}getTitle(context,options){const{callbacks:callbacks}=options,beforeTitle=invokeCallbackWithFallback(callbacks,"beforeTitle",this,context),title=invokeCallbackWithFallback(callbacks,"title",this,context),afterTitle=invokeCallbackWithFallback(callbacks,"afterTitle",this,context);let lines=[];return lines=pushOrConcat(lines,splitNewlines(beforeTitle)),lines=pushOrConcat(lines,splitNewlines(title)),lines=pushOrConcat(lines,splitNewlines(afterTitle)),lines}getBeforeBody(tooltipItems,options){return getBeforeAfterBodyLines(invokeCallbackWithFallback(options.callbacks,"beforeBody",this,tooltipItems))}getBody(tooltipItems,options){const{callbacks:callbacks}=options,bodyItems=[];return each(tooltipItems,(context=>{const bodyItem={before:[],lines:[],after:[]},scoped=overrideCallbacks(callbacks,context);pushOrConcat(bodyItem.before,splitNewlines(invokeCallbackWithFallback(scoped,"beforeLabel",this,context))),pushOrConcat(bodyItem.lines,invokeCallbackWithFallback(scoped,"label",this,context)),pushOrConcat(bodyItem.after,splitNewlines(invokeCallbackWithFallback(scoped,"afterLabel",this,context))),bodyItems.push(bodyItem)})),bodyItems}getAfterBody(tooltipItems,options){return getBeforeAfterBodyLines(invokeCallbackWithFallback(options.callbacks,"afterBody",this,tooltipItems))}getFooter(tooltipItems,options){const{callbacks:callbacks}=options,beforeFooter=invokeCallbackWithFallback(callbacks,"beforeFooter",this,tooltipItems),footer=invokeCallbackWithFallback(callbacks,"footer",this,tooltipItems),afterFooter=invokeCallbackWithFallback(callbacks,"afterFooter",this,tooltipItems);let lines=[];return lines=pushOrConcat(lines,splitNewlines(beforeFooter)),lines=pushOrConcat(lines,splitNewlines(footer)),lines=pushOrConcat(lines,splitNewlines(afterFooter)),lines}_createItems(options){const active=this._active,data=this.chart.data,labelColors=[],labelPointStyles=[],labelTextColors=[];let i,len,tooltipItems=[];for(i=0,len=active.length;i<len;++i)tooltipItems.push(createTooltipItem(this.chart,active[i]));return options.filter&&(tooltipItems=tooltipItems.filter(((element,index,array)=>options.filter(element,index,array,data)))),options.itemSort&&(tooltipItems=tooltipItems.sort(((a,b)=>options.itemSort(a,b,data)))),each(tooltipItems,(context=>{const scoped=overrideCallbacks(options.callbacks,context);labelColors.push(invokeCallbackWithFallback(scoped,"labelColor",this,context)),labelPointStyles.push(invokeCallbackWithFallback(scoped,"labelPointStyle",this,context)),labelTextColors.push(invokeCallbackWithFallback(scoped,"labelTextColor",this,context))})),this.labelColors=labelColors,this.labelPointStyles=labelPointStyles,this.labelTextColors=labelTextColors,this.dataPoints=tooltipItems,tooltipItems}update(changed,replay){const options=this.options.setContext(this.getContext()),active=this._active;let properties,tooltipItems=[];if(active.length){const position=positioners[options.position].call(this,active,this._eventPosition);tooltipItems=this._createItems(options),this.title=this.getTitle(tooltipItems,options),this.beforeBody=this.getBeforeBody(tooltipItems,options),this.body=this.getBody(tooltipItems,options),this.afterBody=this.getAfterBody(tooltipItems,options),this.footer=this.getFooter(tooltipItems,options);const size=this._size=getTooltipSize(this,options),positionAndSize=Object.assign({},position,size),alignment=determineAlignment(this.chart,options,positionAndSize),backgroundPoint=getBackgroundPoint(options,positionAndSize,alignment,this.chart);this.xAlign=alignment.xAlign,this.yAlign=alignment.yAlign,properties={opacity:1,x:backgroundPoint.x,y:backgroundPoint.y,width:size.width,height:size.height,caretX:position.x,caretY:position.y}}else 0!==this.opacity&&(properties={opacity:0});this._tooltipItems=tooltipItems,this.$context=void 0,properties&&this._resolveAnimations().update(this,properties),changed&&options.external&&options.external.call(this,{chart:this.chart,tooltip:this,replay:replay})}drawCaret(tooltipPoint,ctx,size,options){const caretPosition=this.getCaretPosition(tooltipPoint,size,options);ctx.lineTo(caretPosition.x1,caretPosition.y1),ctx.lineTo(caretPosition.x2,caretPosition.y2),ctx.lineTo(caretPosition.x3,caretPosition.y3)}getCaretPosition(tooltipPoint,size,options){const{xAlign:xAlign,yAlign:yAlign}=this,{caretSize:caretSize,cornerRadius:cornerRadius}=options,{topLeft:topLeft,topRight:topRight,bottomLeft:bottomLeft,bottomRight:bottomRight}=toTRBLCorners(cornerRadius),{x:ptX,y:ptY}=tooltipPoint,{width:width,height:height}=size;let x1,x2,x3,y1,y2,y3;return"center"===yAlign?(y2=ptY+height/2,"left"===xAlign?(x1=ptX,x2=x1-caretSize,y1=y2+caretSize,y3=y2-caretSize):(x1=ptX+width,x2=x1+caretSize,y1=y2-caretSize,y3=y2+caretSize),x3=x1):(x2="left"===xAlign?ptX+Math.max(topLeft,bottomLeft)+caretSize:"right"===xAlign?ptX+width-Math.max(topRight,bottomRight)-caretSize:this.caretX,"top"===yAlign?(y1=ptY,y2=y1-caretSize,x1=x2-caretSize,x3=x2+caretSize):(y1=ptY+height,y2=y1+caretSize,x1=x2+caretSize,x3=x2-caretSize),y3=y1),{x1:x1,x2:x2,x3:x3,y1:y1,y2:y2,y3:y3}}drawTitle(pt,ctx,options){const title=this.title,length=title.length;let titleFont,titleSpacing,i;if(length){const rtlHelper=getRtlAdapter(options.rtl,this.x,this.width);for(pt.x=getAlignedX(this,options.titleAlign,options),ctx.textAlign=rtlHelper.textAlign(options.titleAlign),ctx.textBaseline="middle",titleFont=toFont(options.titleFont),titleSpacing=options.titleSpacing,ctx.fillStyle=options.titleColor,ctx.font=titleFont.string,i=0;i<length;++i)ctx.fillText(title[i],rtlHelper.x(pt.x),pt.y+titleFont.lineHeight/2),pt.y+=titleFont.lineHeight+titleSpacing,i+1===length&&(pt.y+=options.titleMarginBottom-titleSpacing)}}_drawColorBox(ctx,pt,i,rtlHelper,options){const labelColor=this.labelColors[i],labelPointStyle=this.labelPointStyles[i],{boxHeight:boxHeight,boxWidth:boxWidth}=options,bodyFont=toFont(options.bodyFont),colorX=getAlignedX(this,"left",options),rtlColorX=rtlHelper.x(colorX),yOffSet=boxHeight<bodyFont.lineHeight?(bodyFont.lineHeight-boxHeight)/2:0,colorY=pt.y+yOffSet;if(options.usePointStyle){const drawOptions={radius:Math.min(boxWidth,boxHeight)/2,pointStyle:labelPointStyle.pointStyle,rotation:labelPointStyle.rotation,borderWidth:1},centerX=rtlHelper.leftForLtr(rtlColorX,boxWidth)+boxWidth/2,centerY=colorY+boxHeight/2;ctx.strokeStyle=options.multiKeyBackground,ctx.fillStyle=options.multiKeyBackground,drawPoint(ctx,drawOptions,centerX,centerY),ctx.strokeStyle=labelColor.borderColor,ctx.fillStyle=labelColor.backgroundColor,drawPoint(ctx,drawOptions,centerX,centerY)}else{ctx.lineWidth=isObject(labelColor.borderWidth)?Math.max(...Object.values(labelColor.borderWidth)):labelColor.borderWidth||1,ctx.strokeStyle=labelColor.borderColor,ctx.setLineDash(labelColor.borderDash||[]),ctx.lineDashOffset=labelColor.borderDashOffset||0;const outerX=rtlHelper.leftForLtr(rtlColorX,boxWidth),innerX=rtlHelper.leftForLtr(rtlHelper.xPlus(rtlColorX,1),boxWidth-2),borderRadius=toTRBLCorners(labelColor.borderRadius);Object.values(borderRadius).some((v=>0!==v))?(ctx.beginPath(),ctx.fillStyle=options.multiKeyBackground,addRoundedRectPath(ctx,{x:outerX,y:colorY,w:boxWidth,h:boxHeight,radius:borderRadius}),ctx.fill(),ctx.stroke(),ctx.fillStyle=labelColor.backgroundColor,ctx.beginPath(),addRoundedRectPath(ctx,{x:innerX,y:colorY+1,w:boxWidth-2,h:boxHeight-2,radius:borderRadius}),ctx.fill()):(ctx.fillStyle=options.multiKeyBackground,ctx.fillRect(outerX,colorY,boxWidth,boxHeight),ctx.strokeRect(outerX,colorY,boxWidth,boxHeight),ctx.fillStyle=labelColor.backgroundColor,ctx.fillRect(innerX,colorY+1,boxWidth-2,boxHeight-2))}ctx.fillStyle=this.labelTextColors[i]}drawBody(pt,ctx,options){const{body:body}=this,{bodySpacing:bodySpacing,bodyAlign:bodyAlign,displayColors:displayColors,boxHeight:boxHeight,boxWidth:boxWidth,boxPadding:boxPadding}=options,bodyFont=toFont(options.bodyFont);let bodyLineHeight=bodyFont.lineHeight,xLinePadding=0;const rtlHelper=getRtlAdapter(options.rtl,this.x,this.width),fillLineOfText=function(line){ctx.fillText(line,rtlHelper.x(pt.x+xLinePadding),pt.y+bodyLineHeight/2),pt.y+=bodyLineHeight+bodySpacing},bodyAlignForCalculation=rtlHelper.textAlign(bodyAlign);let bodyItem,textColor,lines,i,j,ilen,jlen;for(ctx.textAlign=bodyAlign,ctx.textBaseline="middle",ctx.font=bodyFont.string,pt.x=getAlignedX(this,bodyAlignForCalculation,options),ctx.fillStyle=options.bodyColor,each(this.beforeBody,fillLineOfText),xLinePadding=displayColors&&"right"!==bodyAlignForCalculation?"center"===bodyAlign?boxWidth/2+boxPadding:boxWidth+2+boxPadding:0,i=0,ilen=body.length;i<ilen;++i){for(bodyItem=body[i],textColor=this.labelTextColors[i],ctx.fillStyle=textColor,each(bodyItem.before,fillLineOfText),lines=bodyItem.lines,displayColors&&lines.length&&(this._drawColorBox(ctx,pt,i,rtlHelper,options),bodyLineHeight=Math.max(bodyFont.lineHeight,boxHeight)),j=0,jlen=lines.length;j<jlen;++j)fillLineOfText(lines[j]),bodyLineHeight=bodyFont.lineHeight;each(bodyItem.after,fillLineOfText)}xLinePadding=0,bodyLineHeight=bodyFont.lineHeight,each(this.afterBody,fillLineOfText),pt.y-=bodySpacing}drawFooter(pt,ctx,options){const footer=this.footer,length=footer.length;let footerFont,i;if(length){const rtlHelper=getRtlAdapter(options.rtl,this.x,this.width);for(pt.x=getAlignedX(this,options.footerAlign,options),pt.y+=options.footerMarginTop,ctx.textAlign=rtlHelper.textAlign(options.footerAlign),ctx.textBaseline="middle",footerFont=toFont(options.footerFont),ctx.fillStyle=options.footerColor,ctx.font=footerFont.string,i=0;i<length;++i)ctx.fillText(footer[i],rtlHelper.x(pt.x),pt.y+footerFont.lineHeight/2),pt.y+=footerFont.lineHeight+options.footerSpacing}}drawBackground(pt,ctx,tooltipSize,options){const{xAlign:xAlign,yAlign:yAlign}=this,{x:x,y:y}=pt,{width:width,height:height}=tooltipSize,{topLeft:topLeft,topRight:topRight,bottomLeft:bottomLeft,bottomRight:bottomRight}=toTRBLCorners(options.cornerRadius);ctx.fillStyle=options.backgroundColor,ctx.strokeStyle=options.borderColor,ctx.lineWidth=options.borderWidth,ctx.beginPath(),ctx.moveTo(x+topLeft,y),"top"===yAlign&&this.drawCaret(pt,ctx,tooltipSize,options),ctx.lineTo(x+width-topRight,y),ctx.quadraticCurveTo(x+width,y,x+width,y+topRight),"center"===yAlign&&"right"===xAlign&&this.drawCaret(pt,ctx,tooltipSize,options),ctx.lineTo(x+width,y+height-bottomRight),ctx.quadraticCurveTo(x+width,y+height,x+width-bottomRight,y+height),"bottom"===yAlign&&this.drawCaret(pt,ctx,tooltipSize,options),ctx.lineTo(x+bottomLeft,y+height),ctx.quadraticCurveTo(x,y+height,x,y+height-bottomLeft),"center"===yAlign&&"left"===xAlign&&this.drawCaret(pt,ctx,tooltipSize,options),ctx.lineTo(x,y+topLeft),ctx.quadraticCurveTo(x,y,x+topLeft,y),ctx.closePath(),ctx.fill(),options.borderWidth>0&&ctx.stroke()}_updateAnimationTarget(options){const chart=this.chart,anims=this.$animations,animX=anims&&anims.x,animY=anims&&anims.y;if(animX||animY){const position=positioners[options.position].call(this,this._active,this._eventPosition);if(!position)return;const size=this._size=getTooltipSize(this,options),positionAndSize=Object.assign({},position,this._size),alignment=determineAlignment(chart,options,positionAndSize),point=getBackgroundPoint(options,positionAndSize,alignment,chart);animX._to===point.x&&animY._to===point.y||(this.xAlign=alignment.xAlign,this.yAlign=alignment.yAlign,this.width=size.width,this.height=size.height,this.caretX=position.x,this.caretY=position.y,this._resolveAnimations().update(this,point))}}_willRender(){return!!this.opacity}draw(ctx){const options=this.options.setContext(this.getContext());let opacity=this.opacity;if(!opacity)return;this._updateAnimationTarget(options);const tooltipSize={width:this.width,height:this.height},pt={x:this.x,y:this.y};opacity=Math.abs(opacity)<.001?0:opacity;const padding=toPadding(options.padding),hasTooltipContent=this.title.length||this.beforeBody.length||this.body.length||this.afterBody.length||this.footer.length;options.enabled&&hasTooltipContent&&(ctx.save(),ctx.globalAlpha=opacity,this.drawBackground(pt,ctx,tooltipSize,options),overrideTextDirection(ctx,options.textDirection),pt.y+=padding.top,this.drawTitle(pt,ctx,options),this.drawBody(pt,ctx,options),this.drawFooter(pt,ctx,options),restoreTextDirection(ctx,options.textDirection),ctx.restore())}getActiveElements(){return this._active||[]}setActiveElements(activeElements,eventPosition){const lastActive=this._active,active=activeElements.map((_ref9=>{let{datasetIndex:datasetIndex,index:index}=_ref9;const meta=this.chart.getDatasetMeta(datasetIndex);if(!meta)throw new Error("Cannot find a dataset at index "+datasetIndex);return{datasetIndex:datasetIndex,element:meta.data[index],index:index}})),changed=!_elementsEqual(lastActive,active),positionChanged=this._positionChanged(active,eventPosition);(changed||positionChanged)&&(this._active=active,this._eventPosition=eventPosition,this._ignoreReplayEvents=!0,this.update(!0))}handleEvent(e,replay){let inChartArea=!(arguments.length>2&&void 0!==arguments[2])||arguments[2];if(replay&&this._ignoreReplayEvents)return!1;this._ignoreReplayEvents=!1;const options=this.options,lastActive=this._active||[],active=this._getActiveElements(e,lastActive,replay,inChartArea),positionChanged=this._positionChanged(active,e),changed=replay||!_elementsEqual(active,lastActive)||positionChanged;return changed&&(this._active=active,(options.enabled||options.external)&&(this._eventPosition={x:e.x,y:e.y},this.update(!0,replay))),changed}_getActiveElements(e,lastActive,replay,inChartArea){const options=this.options;if("mouseout"===e.type)return[];if(!inChartArea)return lastActive.filter((i=>this.chart.data.datasets[i.datasetIndex]&&void 0!==this.chart.getDatasetMeta(i.datasetIndex).controller.getParsed(i.index)));const active=this.chart.getElementsAtEventForMode(e,options.mode,options,replay);return options.reverse&&active.reverse(),active}_positionChanged(active,e){const{caretX:caretX,caretY:caretY,options:options}=this,position=positioners[options.position].call(this,active,e);return!1!==position&&(caretX!==position.x||caretY!==position.y)}}_defineProperty(Tooltip,"positioners",positioners);var plugin_tooltip={id:"tooltip",_element:Tooltip,positioners:positioners,afterInit(chart,_args,options){options&&(chart.tooltip=new Tooltip({chart:chart,options:options}))},beforeUpdate(chart,_args,options){chart.tooltip&&chart.tooltip.initialize(options)},reset(chart,_args,options){chart.tooltip&&chart.tooltip.initialize(options)},afterDraw(chart){const tooltip=chart.tooltip;if(tooltip&&tooltip._willRender()){const args={tooltip:tooltip};if(!1===chart.notifyPlugins("beforeTooltipDraw",{...args,cancelable:!0}))return;tooltip.draw(chart.ctx),chart.notifyPlugins("afterTooltipDraw",args)}},afterEvent(chart,args){if(chart.tooltip){const useFinalPosition=args.replay;chart.tooltip.handleEvent(args.event,useFinalPosition,args.inChartArea)&&(args.changed=!0)}},defaults:{enabled:!0,external:null,position:"average",backgroundColor:"rgba(0,0,0,0.8)",titleColor:"#fff",titleFont:{weight:"bold"},titleSpacing:2,titleMarginBottom:6,titleAlign:"left",bodyColor:"#fff",bodySpacing:2,bodyFont:{},bodyAlign:"left",footerColor:"#fff",footerSpacing:2,footerMarginTop:6,footerFont:{weight:"bold"},footerAlign:"left",padding:6,caretPadding:2,caretSize:5,cornerRadius:6,boxHeight:(ctx,opts)=>opts.bodyFont.size,boxWidth:(ctx,opts)=>opts.bodyFont.size,multiKeyBackground:"#fff",displayColors:!0,boxPadding:0,borderColor:"rgba(0,0,0,0)",borderWidth:0,animation:{duration:400,easing:"easeOutQuart"},animations:{numbers:{type:"number",properties:["x","y","width","height","caretX","caretY"]},opacity:{easing:"linear",duration:200}},callbacks:defaultCallbacks},defaultRoutes:{bodyFont:"font",footerFont:"font",titleFont:"font"},descriptors:{_scriptable:name=>"filter"!==name&&"itemSort"!==name&&"external"!==name,_indexable:!1,callbacks:{_scriptable:!1,_indexable:!1},animation:{_fallback:!1},animations:{_fallback:"animation"}},additionalOptionScopes:["interaction"]};return Chart.register(controllers,scales,elements,plugins),Chart.helpers={...helpers},Chart._adapters=_adapters,Chart.Animation=Animation,Chart.Animations=Animations,Chart.animator=animator,Chart.controllers=registry.controllers.items,Chart.DatasetController=DatasetController,Chart.Element=Element,Chart.elements=elements,Chart.Interaction=Interaction,Chart.layouts=layouts,Chart.platforms=platforms,Chart.Scale=Scale,Chart.Ticks=Ticks,Object.assign(Chart,controllers,scales,elements,plugins,platforms),Chart.Chart=Chart,"undefined"!=typeof window&&(window.Chart=Chart),Chart},"object"==typeof exports&&"undefined"!=typeof module?module.exports=factory():"function"==typeof define&&define.amd?define("core/chartjs-lazy",factory):(global="undefined"!=typeof globalThis?globalThis:global||self).Chart=factory();

//# sourceMappingURL=chartjs-lazy.min.js.map